// namespaces
var dwv = dwv || {};
dwv.dicom = dwv.dicom || {};

/**
 * DICOM tag dictionary.
 * Generated using xml standard conversion
 *  from {@link https://github.com/ivmartel/dcmbench/tree/master/view/part06}
 *  with {@link http://medical.nema.org/medical/dicom/current/source/docbook/part06/part06.xml}
 * Conversion changes:
 * - (vr) "See Note" -> "NONE", "OB or OW" -> "ox", "US or SS" -> "xs"
 * - added "GenericGroupLength" element to each group
 * Local changes:
 * - tag numbers with 'xx' were replaced with '00', 'xxx' with '001' and 'xxxx' with '0004'
 */
dwv.dicom.dictionary = {
    '0x0000': {
        '0x0000': ['UL', '1', 'GroupLength'],
        '0x0001': ['UL', '1', 'CommandLengthToEnd'],
        '0x0002': ['UI', '1', 'AffectedSOPClassUID'],
        '0x0003': ['UI', '1', 'RequestedSOPClassUID'],
        '0x0010': ['CS', '1', 'CommandRecognitionCode'],
        '0x0100': ['US', '1', 'CommandField'],
        '0x0110': ['US', '1', 'MessageID'],
        '0x0120': ['US', '1', 'MessageIDBeingRespondedTo'],
        '0x0200': ['AE', '1', 'Initiator'],
        '0x0300': ['AE', '1', 'Receiver'],
        '0x0400': ['AE', '1', 'FindLocation'],
        '0x0600': ['AE', '1', 'MoveDestination'],
        '0x0700': ['US', '1', 'Priority'],
        '0x0800': ['US', '1', 'DataSetType'],
        '0x0850': ['US', '1', 'NumberOfMatches'],
        '0x0860': ['US', '1', 'ResponseSequenceNumber'],
        '0x0900': ['US', '1', 'Status'],
        '0x0901': ['AT', '1-n', 'OffendingElement'],
        '0x0902': ['LO', '1', 'ErrorComment'],
        '0x0903': ['US', '1', 'ErrorID'],
        '0x0904': ['OT', '1-n', 'ErrorInformation'],
        '0x1000': ['UI', '1', 'AffectedSOPInstanceUID'],
        '0x1001': ['UI', '1', 'RequestedSOPInstanceUID'],
        '0x1002': ['US', '1', 'EventTypeID'],
        '0x1003': ['OT', '1-n', 'EventInformation'],
        '0x1005': ['AT', '1-n', 'AttributeIdentifierList'],
        '0x1007': ['AT', '1-n', 'ModificationList'],
        '0x1008': ['US', '1', 'ActionTypeID'],
        '0x1009': ['OT', '1-n', 'ActionInformation'],
        '0x1013': ['UI', '1-n', 'SuccessfulSOPInstanceUIDList'],
        '0x1014': ['UI', '1-n', 'FailedSOPInstanceUIDList'],
        '0x1015': ['UI', '1-n', 'WarningSOPInstanceUIDList'],
        '0x1020': ['US', '1', 'NumberOfRemainingSuboperations'],
        '0x1021': ['US', '1', 'NumberOfCompletedSuboperations'],
        '0x1022': ['US', '1', 'NumberOfFailedSuboperations'],
        '0x1023': ['US', '1', 'NumberOfWarningSuboperations'],
        '0x1030': ['AE', '1', 'MoveOriginatorApplicationEntityTitle'],
        '0x1031': ['US', '1', 'MoveOriginatorMessageID'],
        '0x4000': ['AT', '1', 'DialogReceiver'],
        '0x4010': ['AT', '1', 'TerminalType'],
        '0x5010': ['SH', '1', 'MessageSetID'],
        '0x5020': ['SH', '1', 'EndMessageSet'],
        '0x5110': ['AT', '1', 'DisplayFormat'],
        '0x5120': ['AT', '1', 'PagePositionID'],
        '0x5130': ['CS', '1', 'TextFormatID'],
        '0x5140': ['CS', '1', 'NormalReverse'],
        '0x5150': ['CS', '1', 'AddGrayScale'],
        '0x5160': ['CS', '1', 'Borders'],
        '0x5170': ['IS', '1', 'Copies'],
        '0x5180': ['CS', '1', 'OldMagnificationType'],
        '0x5190': ['CS', '1', 'Erase'],
        '0x51A0': ['CS', '1', 'Print'],
        '0x51B0': ['US', '1-n', 'Overlays'],
    },
    '0x0002': {
        '0x0000': ['UL', '1', 'FileMetaInformationGroupLength'],
        '0x0001': ['OB', '1', 'FileMetaInformationVersion'],
        '0x0002': ['UI', '1', 'MediaStorageSOPClassUID'],
        '0x0003': ['UI', '1', 'MediaStorageSOPInstanceUID'],
        '0x0010': ['UI', '1', 'TransferSyntaxUID'],
        '0x0012': ['UI', '1', 'ImplementationClassUID'],
        '0x0013': ['SH', '1', 'ImplementationVersionName'],
        '0x0016': ['AE', '1', 'SourceApplicationEntityTitle'],
        '0x0017': ['AE', '1', 'SendingApplicationEntityTitle'],
        '0x0018': ['AE', '1', 'ReceivingApplicationEntityTitle'],
        '0x0100': ['UI', '1', 'PrivateInformationCreatorUID'],
        '0x0102': ['OB', '1', 'PrivateInformation'],
    },
    '0x0004': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x1130': ['CS', '1', 'FileSetID'],
        '0x1141': ['CS', '1-8', 'FileSetDescriptorFileID'],
        '0x1142': ['CS', '1', 'SpecificCharacterSetOfFileSetDescriptorFile'],
        '0x1200': ['UL', '1', 'OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity'],
        '0x1202': ['UL', '1', 'OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity'],
        '0x1212': ['US', '1', 'FileSetConsistencyFlag'],
        '0x1220': ['SQ', '1', 'DirectoryRecordSequence'],
        '0x1400': ['UL', '1', 'OffsetOfTheNextDirectoryRecord'],
        '0x1410': ['US', '1', 'RecordInUseFlag'],
        '0x1420': ['UL', '1', 'OffsetOfReferencedLowerLevelDirectoryEntity'],
        '0x1430': ['CS', '1', 'DirectoryRecordType'],
        '0x1432': ['UI', '1', 'PrivateRecordUID'],
        '0x1500': ['CS', '1-8', 'ReferencedFileID'],
        '0x1504': ['UL', '1', 'MRDRDirectoryRecordOffset'],
        '0x1510': ['UI', '1', 'ReferencedSOPClassUIDInFile'],
        '0x1511': ['UI', '1', 'ReferencedSOPInstanceUIDInFile'],
        '0x1512': ['UI', '1', 'ReferencedTransferSyntaxUIDInFile'],
        '0x151A': ['UI', '1-n', 'ReferencedRelatedGeneralSOPClassUIDInFile'],
        '0x1600': ['UL', '1', 'NumberOfReferences'],
    },
    '0x0008': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['UL', '1', 'LengthToEnd'],
        '0x0005': ['CS', '1-n', 'SpecificCharacterSet'],
        '0x0006': ['SQ', '1', 'LanguageCodeSequence'],
        '0x0008': ['CS', '2-n', 'ImageType'],
        '0x0010': ['SH', '1', 'RecognitionCode'],
        '0x0012': ['DA', '1', 'InstanceCreationDate'],
        '0x0013': ['TM', '1', 'InstanceCreationTime'],
        '0x0014': ['UI', '1', 'InstanceCreatorUID'],
        '0x0015': ['DT', '1', 'InstanceCoercionDateTime'],
        '0x0016': ['UI', '1', 'SOPClassUID'],
        '0x0018': ['UI', '1', 'SOPInstanceUID'],
        '0x001A': ['UI', '1-n', 'RelatedGeneralSOPClassUID'],
        '0x001B': ['UI', '1', 'OriginalSpecializedSOPClassUID'],
        '0x0020': ['DA', '1', 'StudyDate'],
        '0x0021': ['DA', '1', 'SeriesDate'],
        '0x0022': ['DA', '1', 'AcquisitionDate'],
        '0x0023': ['DA', '1', 'ContentDate'],
        '0x0024': ['DA', '1', 'OverlayDate'],
        '0x0025': ['DA', '1', 'CurveDate'],
        '0x002A': ['DT', '1', 'AcquisitionDateTime'],
        '0x0030': ['TM', '1', 'StudyTime'],
        '0x0031': ['TM', '1', 'SeriesTime'],
        '0x0032': ['TM', '1', 'AcquisitionTime'],
        '0x0033': ['TM', '1', 'ContentTime'],
        '0x0034': ['TM', '1', 'OverlayTime'],
        '0x0035': ['TM', '1', 'CurveTime'],
        '0x0040': ['US', '1', 'DataSetType'],
        '0x0041': ['LO', '1', 'DataSetSubtype'],
        '0x0042': ['CS', '1', 'NuclearMedicineSeriesType'],
        '0x0050': ['SH', '1', 'AccessionNumber'],
        '0x0051': ['SQ', '1', 'IssuerOfAccessionNumberSequence'],
        '0x0052': ['CS', '1', 'QueryRetrieveLevel'],
        '0x0053': ['CS', '1', 'QueryRetrieveView'],
        '0x0054': ['AE', '1-n', 'RetrieveAETitle'],
        '0x0056': ['CS', '1', 'InstanceAvailability'],
        '0x0058': ['UI', '1-n', 'FailedSOPInstanceUIDList'],
        '0x0060': ['CS', '1', 'Modality'],
        '0x0061': ['CS', '1-n', 'ModalitiesInStudy'],
        '0x0062': ['UI', '1-n', 'SOPClassesInStudy'],
        '0x0064': ['CS', '1', 'ConversionType'],
        '0x0068': ['CS', '1', 'PresentationIntentType'],
        '0x0070': ['LO', '1', 'Manufacturer'],
        '0x0080': ['LO', '1', 'InstitutionName'],
        '0x0081': ['ST', '1', 'InstitutionAddress'],
        '0x0082': ['SQ', '1', 'InstitutionCodeSequence'],
        '0x0090': ['PN', '1', 'ReferringPhysicianName'],
        '0x0092': ['ST', '1', 'ReferringPhysicianAddress'],
        '0x0094': ['SH', '1-n', 'ReferringPhysicianTelephoneNumbers'],
        '0x0096': ['SQ', '1', 'ReferringPhysicianIdentificationSequence'],
        '0x009C': ['PN', '1-n', 'ConsultingPhysicianName'],
        '0x009D': ['SQ', '1', 'ConsultingPhysicianIdentificationSequence'],
        '0x0100': ['SH', '1', 'CodeValue'],
        '0x0101': ['LO', '1', 'ExtendedCodeValue'],
        '0x0102': ['SH', '1', 'CodingSchemeDesignator'],
        '0x0103': ['SH', '1', 'CodingSchemeVersion'],
        '0x0104': ['LO', '1', 'CodeMeaning'],
        '0x0105': ['CS', '1', 'MappingResource'],
        '0x0106': ['DT', '1', 'ContextGroupVersion'],
        '0x0107': ['DT', '1', 'ContextGroupLocalVersion'],
        '0x0108': ['LT', '1', 'ExtendedCodeMeaning'],
        '0x010B': ['CS', '1', 'ContextGroupExtensionFlag'],
        '0x010C': ['UI', '1', 'CodingSchemeUID'],
        '0x010D': ['UI', '1', 'ContextGroupExtensionCreatorUID'],
        '0x010F': ['CS', '1', 'ContextIdentifier'],
        '0x0110': ['SQ', '1', 'CodingSchemeIdentificationSequence'],
        '0x0112': ['LO', '1', 'CodingSchemeRegistry'],
        '0x0114': ['ST', '1', 'CodingSchemeExternalID'],
        '0x0115': ['ST', '1', 'CodingSchemeName'],
        '0x0116': ['ST', '1', 'CodingSchemeResponsibleOrganization'],
        '0x0117': ['UI', '1', 'ContextUID'],
        '0x0118': ['UI', '1', 'MappingResourceUID'],
        '0x0119': ['UC', '1', 'LongCodeValue'],
        '0x0120': ['UR', '1', 'URNCodeValue'],
        '0x0121': ['SQ', '1', 'EquivalentCodeSequence'],
        '0x0201': ['SH', '1', 'TimezoneOffsetFromUTC'],
        '0x0300': ['SQ', '1', 'PrivateDataElementCharacteristicsSequence'],
        '0x0301': ['US', '1', 'PrivateGroupReference'],
        '0x0302': ['LO', '1', 'PrivateCreatorReference'],
        '0x0303': ['CS', '1', 'BlockIdentifyingInformationStatus'],
        '0x0304': ['US', '1-n', 'NonidentifyingPrivateElements'],
        '0x0306': ['US', '1-n', 'IdentifyingPrivateElements'],
        '0x0305': ['SQ', '1', 'DeidentificationActionSequence'],
        '0x0307': ['CS', '1', 'DeidentificationAction'],
        '0x1000': ['AE', '1', 'NetworkID'],
        '0x1010': ['SH', '1', 'StationName'],
        '0x1030': ['LO', '1', 'StudyDescription'],
        '0x1032': ['SQ', '1', 'ProcedureCodeSequence'],
        '0x103E': ['LO', '1', 'SeriesDescription'],
        '0x103F': ['SQ', '1', 'SeriesDescriptionCodeSequence'],
        '0x1040': ['LO', '1', 'InstitutionalDepartmentName'],
        '0x1048': ['PN', '1-n', 'PhysiciansOfRecord'],
        '0x1049': ['SQ', '1', 'PhysiciansOfRecordIdentificationSequence'],
        '0x1050': ['PN', '1-n', 'PerformingPhysicianName'],
        '0x1052': ['SQ', '1', 'PerformingPhysicianIdentificationSequence'],
        '0x1060': ['PN', '1-n', 'NameOfPhysiciansReadingStudy'],
        '0x1062': ['SQ', '1', 'PhysiciansReadingStudyIdentificationSequence'],
        '0x1070': ['PN', '1-n', 'OperatorsName'],
        '0x1072': ['SQ', '1', 'OperatorIdentificationSequence'],
        '0x1080': ['LO', '1-n', 'AdmittingDiagnosesDescription'],
        '0x1084': ['SQ', '1', 'AdmittingDiagnosesCodeSequence'],
        '0x1090': ['LO', '1', 'ManufacturerModelName'],
        '0x1100': ['SQ', '1', 'ReferencedResultsSequence'],
        '0x1110': ['SQ', '1', 'ReferencedStudySequence'],
        '0x1111': ['SQ', '1', 'ReferencedPerformedProcedureStepSequence'],
        '0x1115': ['SQ', '1', 'ReferencedSeriesSequence'],
        '0x1120': ['SQ', '1', 'ReferencedPatientSequence'],
        '0x1125': ['SQ', '1', 'ReferencedVisitSequence'],
        '0x1130': ['SQ', '1', 'ReferencedOverlaySequence'],
        '0x1134': ['SQ', '1', 'ReferencedStereometricInstanceSequence'],
        '0x113A': ['SQ', '1', 'ReferencedWaveformSequence'],
        '0x1140': ['SQ', '1', 'ReferencedImageSequence'],
        '0x1145': ['SQ', '1', 'ReferencedCurveSequence'],
        '0x114A': ['SQ', '1', 'ReferencedInstanceSequence'],
        '0x114B': ['SQ', '1', 'ReferencedRealWorldValueMappingInstanceSequence'],
        '0x1150': ['UI', '1', 'ReferencedSOPClassUID'],
        '0x1155': ['UI', '1', 'ReferencedSOPInstanceUID'],
        '0x115A': ['UI', '1-n', 'SOPClassesSupported'],
        '0x1160': ['IS', '1-n', 'ReferencedFrameNumber'],
        '0x1161': ['UL', '1-n', 'SimpleFrameList'],
        '0x1162': ['UL', '3-3n', 'CalculatedFrameList'],
        '0x1163': ['FD', '2', 'TimeRange'],
        '0x1164': ['SQ', '1', 'FrameExtractionSequence'],
        '0x1167': ['UI', '1', 'MultiFrameSourceSOPInstanceUID'],
        '0x1190': ['UR', '1', 'RetrieveURL'],
        '0x1195': ['UI', '1', 'TransactionUID'],
        '0x1196': ['US', '1', 'WarningReason'],
        '0x1197': ['US', '1', 'FailureReason'],
        '0x1198': ['SQ', '1', 'FailedSOPSequence'],
        '0x1199': ['SQ', '1', 'ReferencedSOPSequence'],
        '0x1200': ['SQ', '1', 'StudiesContainingOtherReferencedInstancesSequence'],
        '0x1250': ['SQ', '1', 'RelatedSeriesSequence'],
        '0x2110': ['CS', '1', 'LossyImageCompressionRetired'],
        '0x2111': ['ST', '1', 'DerivationDescription'],
        '0x2112': ['SQ', '1', 'SourceImageSequence'],
        '0x2120': ['SH', '1', 'StageName'],
        '0x2122': ['IS', '1', 'StageNumber'],
        '0x2124': ['IS', '1', 'NumberOfStages'],
        '0x2127': ['SH', '1', 'ViewName'],
        '0x2128': ['IS', '1', 'ViewNumber'],
        '0x2129': ['IS', '1', 'NumberOfEventTimers'],
        '0x212A': ['IS', '1', 'NumberOfViewsInStage'],
        '0x2130': ['DS', '1-n', 'EventElapsedTimes'],
        '0x2132': ['LO', '1-n', 'EventTimerNames'],
        '0x2133': ['SQ', '1', 'EventTimerSequence'],
        '0x2134': ['FD', '1', 'EventTimeOffset'],
        '0x2135': ['SQ', '1', 'EventCodeSequence'],
        '0x2142': ['IS', '1', 'StartTrim'],
        '0x2143': ['IS', '1', 'StopTrim'],
        '0x2144': ['IS', '1', 'RecommendedDisplayFrameRate'],
        '0x2200': ['CS', '1', 'TransducerPosition'],
        '0x2204': ['CS', '1', 'TransducerOrientation'],
        '0x2208': ['CS', '1', 'AnatomicStructure'],
        '0x2218': ['SQ', '1', 'AnatomicRegionSequence'],
        '0x2220': ['SQ', '1', 'AnatomicRegionModifierSequence'],
        '0x2228': ['SQ', '1', 'PrimaryAnatomicStructureSequence'],
        '0x2229': ['SQ', '1', 'AnatomicStructureSpaceOrRegionSequence'],
        '0x2230': ['SQ', '1', 'PrimaryAnatomicStructureModifierSequence'],
        '0x2240': ['SQ', '1', 'TransducerPositionSequence'],
        '0x2242': ['SQ', '1', 'TransducerPositionModifierSequence'],
        '0x2244': ['SQ', '1', 'TransducerOrientationSequence'],
        '0x2246': ['SQ', '1', 'TransducerOrientationModifierSequence'],
        '0x2251': ['SQ', '1', 'AnatomicStructureSpaceOrRegionCodeSequenceTrial'],
        '0x2253': ['SQ', '1', 'AnatomicPortalOfEntranceCodeSequenceTrial'],
        '0x2255': ['SQ', '1', 'AnatomicApproachDirectionCodeSequenceTrial'],
        '0x2256': ['ST', '1', 'AnatomicPerspectiveDescriptionTrial'],
        '0x2257': ['SQ', '1', 'AnatomicPerspectiveCodeSequenceTrial'],
        '0x2258': ['ST', '1', 'AnatomicLocationOfExaminingInstrumentDescriptionTrial'],
        '0x2259': ['SQ', '1', 'AnatomicLocationOfExaminingInstrumentCodeSequenceTrial'],
        '0x225A': ['SQ', '1', 'AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial'],
        '0x225C': ['SQ', '1', 'OnAxisBackgroundAnatomicStructureCodeSequenceTrial'],
        '0x3001': ['SQ', '1', 'AlternateRepresentationSequence'],
        '0x3010': ['UI', '1-n', 'IrradiationEventUID'],
        '0x3011': ['SQ', '1', 'SourceIrradiationEventSequence'],
        '0x3012': ['UI', '1', 'RadiopharmaceuticalAdministrationEventUID'],
        '0x4000': ['LT', '1', 'IdentifyingComments'],
        '0x9007': ['CS', '4', 'FrameType'],
        '0x9092': ['SQ', '1', 'ReferencedImageEvidenceSequence'],
        '0x9121': ['SQ', '1', 'ReferencedRawDataSequence'],
        '0x9123': ['UI', '1', 'CreatorVersionUID'],
        '0x9124': ['SQ', '1', 'DerivationImageSequence'],
        '0x9154': ['SQ', '1', 'SourceImageEvidenceSequence'],
        '0x9205': ['CS', '1', 'PixelPresentation'],
        '0x9206': ['CS', '1', 'VolumetricProperties'],
        '0x9207': ['CS', '1', 'VolumeBasedCalculationTechnique'],
        '0x9208': ['CS', '1', 'ComplexImageComponent'],
        '0x9209': ['CS', '1', 'AcquisitionContrast'],
        '0x9215': ['SQ', '1', 'DerivationCodeSequence'],
        '0x9237': ['SQ', '1', 'ReferencedPresentationStateSequence'],
        '0x9410': ['SQ', '1', 'ReferencedOtherPlaneSequence'],
        '0x9458': ['SQ', '1', 'FrameDisplaySequence'],
        '0x9459': ['FL', '1', 'RecommendedDisplayFrameRateInFloat'],
        '0x9460': ['CS', '1', 'SkipFrameRangeFlag'],
    },
    '0x0010': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['PN', '1', 'PatientName'],
        '0x0020': ['LO', '1', 'PatientID'],
        '0x0021': ['LO', '1', 'IssuerOfPatientID'],
        '0x0022': ['CS', '1', 'TypeOfPatientID'],
        '0x0024': ['SQ', '1', 'IssuerOfPatientIDQualifiersSequence'],
        '0x0030': ['DA', '1', 'PatientBirthDate'],
        '0x0032': ['TM', '1', 'PatientBirthTime'],
        '0x0040': ['CS', '1', 'PatientSex'],
        '0x0050': ['SQ', '1', 'PatientInsurancePlanCodeSequence'],
        '0x0101': ['SQ', '1', 'PatientPrimaryLanguageCodeSequence'],
        '0x0102': ['SQ', '1', 'PatientPrimaryLanguageModifierCodeSequence'],
        '0x0200': ['CS', '1', 'QualityControlSubject'],
        '0x0201': ['SQ', '1', 'QualityControlSubjectTypeCodeSequence'],
        '0x1000': ['LO', '1-n', 'OtherPatientIDs'],
        '0x1001': ['PN', '1-n', 'OtherPatientNames'],
        '0x1002': ['SQ', '1', 'OtherPatientIDsSequence'],
        '0x1005': ['PN', '1', 'PatientBirthName'],
        '0x1010': ['AS', '1', 'PatientAge'],
        '0x1020': ['DS', '1', 'PatientSize'],
        '0x1021': ['SQ', '1', 'PatientSizeCodeSequence'],
        '0x1030': ['DS', '1', 'PatientWeight'],
        '0x1040': ['LO', '1', 'PatientAddress'],
        '0x1050': ['LO', '1-n', 'InsurancePlanIdentification'],
        '0x1060': ['PN', '1', 'PatientMotherBirthName'],
        '0x1080': ['LO', '1', 'MilitaryRank'],
        '0x1081': ['LO', '1', 'BranchOfService'],
        '0x1090': ['LO', '1', 'MedicalRecordLocator'],
        '0x1100': ['SQ', '1', 'ReferencedPatientPhotoSequence'],
        '0x2000': ['LO', '1-n', 'MedicalAlerts'],
        '0x2110': ['LO', '1-n', 'Allergies'],
        '0x2150': ['LO', '1', 'CountryOfResidence'],
        '0x2152': ['LO', '1', 'RegionOfResidence'],
        '0x2154': ['SH', '1-n', 'PatientTelephoneNumbers'],
        '0x2155': ['LT', '1', 'PatientTelecomInformation'],
        '0x2160': ['SH', '1', 'EthnicGroup'],
        '0x2180': ['SH', '1', 'Occupation'],
        '0x21A0': ['CS', '1', 'SmokingStatus'],
        '0x21B0': ['LT', '1', 'AdditionalPatientHistory'],
        '0x21C0': ['US', '1', 'PregnancyStatus'],
        '0x21D0': ['DA', '1', 'LastMenstrualDate'],
        '0x21F0': ['LO', '1', 'PatientReligiousPreference'],
        '0x2201': ['LO', '1', 'PatientSpeciesDescription'],
        '0x2202': ['SQ', '1', 'PatientSpeciesCodeSequence'],
        '0x2203': ['CS', '1', 'PatientSexNeutered'],
        '0x2210': ['CS', '1', 'AnatomicalOrientationType'],
        '0x2292': ['LO', '1', 'PatientBreedDescription'],
        '0x2293': ['SQ', '1', 'PatientBreedCodeSequence'],
        '0x2294': ['SQ', '1', 'BreedRegistrationSequence'],
        '0x2295': ['LO', '1', 'BreedRegistrationNumber'],
        '0x2296': ['SQ', '1', 'BreedRegistryCodeSequence'],
        '0x2297': ['PN', '1', 'ResponsiblePerson'],
        '0x2298': ['CS', '1', 'ResponsiblePersonRole'],
        '0x2299': ['LO', '1', 'ResponsibleOrganization'],
        '0x4000': ['LT', '1', 'PatientComments'],
        '0x9431': ['FL', '1', 'ExaminedBodyThickness'],
    },
    '0x0012': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['LO', '1', 'ClinicalTrialSponsorName'],
        '0x0020': ['LO', '1', 'ClinicalTrialProtocolID'],
        '0x0021': ['LO', '1', 'ClinicalTrialProtocolName'],
        '0x0030': ['LO', '1', 'ClinicalTrialSiteID'],
        '0x0031': ['LO', '1', 'ClinicalTrialSiteName'],
        '0x0040': ['LO', '1', 'ClinicalTrialSubjectID'],
        '0x0042': ['LO', '1', 'ClinicalTrialSubjectReadingID'],
        '0x0050': ['LO', '1', 'ClinicalTrialTimePointID'],
        '0x0051': ['ST', '1', 'ClinicalTrialTimePointDescription'],
        '0x0060': ['LO', '1', 'ClinicalTrialCoordinatingCenterName'],
        '0x0062': ['CS', '1', 'PatientIdentityRemoved'],
        '0x0063': ['LO', '1-n', 'DeidentificationMethod'],
        '0x0064': ['SQ', '1', 'DeidentificationMethodCodeSequence'],
        '0x0071': ['LO', '1', 'ClinicalTrialSeriesID'],
        '0x0072': ['LO', '1', 'ClinicalTrialSeriesDescription'],
        '0x0081': ['LO', '1', 'ClinicalTrialProtocolEthicsCommitteeName'],
        '0x0082': ['LO', '1', 'ClinicalTrialProtocolEthicsCommitteeApprovalNumber'],
        '0x0083': ['SQ', '1', 'ConsentForClinicalTrialUseSequence'],
        '0x0084': ['CS', '1', 'DistributionType'],
        '0x0085': ['CS', '1', 'ConsentForDistributionFlag'],
    },
    '0x0014': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0023': ['ST', '1-n', 'CADFileFormat'],
        '0x0024': ['ST', '1-n', 'ComponentReferenceSystem'],
        '0x0025': ['ST', '1-n', 'ComponentManufacturingProcedure'],
        '0x0028': ['ST', '1-n', 'ComponentManufacturer'],
        '0x0030': ['DS', '1-n', 'MaterialThickness'],
        '0x0032': ['DS', '1-n', 'MaterialPipeDiameter'],
        '0x0034': ['DS', '1-n', 'MaterialIsolationDiameter'],
        '0x0042': ['ST', '1-n', 'MaterialGrade'],
        '0x0044': ['ST', '1-n', 'MaterialPropertiesDescription'],
        '0x0045': ['ST', '1-n', 'MaterialPropertiesFileFormatRetired'],
        '0x0046': ['LT', '1', 'MaterialNotes'],
        '0x0050': ['CS', '1', 'ComponentShape'],
        '0x0052': ['CS', '1', 'CurvatureType'],
        '0x0054': ['DS', '1', 'OuterDiameter'],
        '0x0056': ['DS', '1', 'InnerDiameter'],
        '0x1010': ['ST', '1', 'ActualEnvironmentalConditions'],
        '0x1020': ['DA', '1', 'ExpiryDate'],
        '0x1040': ['ST', '1', 'EnvironmentalConditions'],
        '0x2002': ['SQ', '1', 'EvaluatorSequence'],
        '0x2004': ['IS', '1', 'EvaluatorNumber'],
        '0x2006': ['PN', '1', 'EvaluatorName'],
        '0x2008': ['IS', '1', 'EvaluationAttempt'],
        '0x2012': ['SQ', '1', 'IndicationSequence'],
        '0x2014': ['IS', '1', 'IndicationNumber'],
        '0x2016': ['SH', '1', 'IndicationLabel'],
        '0x2018': ['ST', '1', 'IndicationDescription'],
        '0x201A': ['CS', '1-n', 'IndicationType'],
        '0x201C': ['CS', '1', 'IndicationDisposition'],
        '0x201E': ['SQ', '1', 'IndicationROISequence'],
        '0x2030': ['SQ', '1', 'IndicationPhysicalPropertySequence'],
        '0x2032': ['SH', '1', 'PropertyLabel'],
        '0x2202': ['IS', '1', 'CoordinateSystemNumberOfAxes'],
        '0x2204': ['SQ', '1', 'CoordinateSystemAxesSequence'],
        '0x2206': ['ST', '1', 'CoordinateSystemAxisDescription'],
        '0x2208': ['CS', '1', 'CoordinateSystemDataSetMapping'],
        '0x220A': ['IS', '1', 'CoordinateSystemAxisNumber'],
        '0x220C': ['CS', '1', 'CoordinateSystemAxisType'],
        '0x220E': ['CS', '1', 'CoordinateSystemAxisUnits'],
        '0x2210': ['OB', '1', 'CoordinateSystemAxisValues'],
        '0x2220': ['SQ', '1', 'CoordinateSystemTransformSequence'],
        '0x2222': ['ST', '1', 'TransformDescription'],
        '0x2224': ['IS', '1', 'TransformNumberOfAxes'],
        '0x2226': ['IS', '1-n', 'TransformOrderOfAxes'],
        '0x2228': ['CS', '1', 'TransformedAxisUnits'],
        '0x222A': ['DS', '1-n', 'CoordinateSystemTransformRotationAndScaleMatrix'],
        '0x222C': ['DS', '1-n', 'CoordinateSystemTransformTranslationMatrix'],
        '0x3011': ['DS', '1', 'InternalDetectorFrameTime'],
        '0x3012': ['DS', '1', 'NumberOfFramesIntegrated'],
        '0x3020': ['SQ', '1', 'DetectorTemperatureSequence'],
        '0x3022': ['ST', '1', 'SensorName'],
        '0x3024': ['DS', '1', 'HorizontalOffsetOfSensor'],
        '0x3026': ['DS', '1', 'VerticalOffsetOfSensor'],
        '0x3028': ['DS', '1', 'SensorTemperature'],
        '0x3040': ['SQ', '1', 'DarkCurrentSequence'],
        '0x3050': ['ox', '1', 'DarkCurrentCounts'],
        '0x3060': ['SQ', '1', 'GainCorrectionReferenceSequence'],
        '0x3070': ['ox', '1', 'AirCounts'],
        '0x3071': ['DS', '1', 'KVUsedInGainCalibration'],
        '0x3072': ['DS', '1', 'MAUsedInGainCalibration'],
        '0x3073': ['DS', '1', 'NumberOfFramesUsedForIntegration'],
        '0x3074': ['LO', '1', 'FilterMaterialUsedInGainCalibration'],
        '0x3075': ['DS', '1', 'FilterThicknessUsedInGainCalibration'],
        '0x3076': ['DA', '1', 'DateOfGainCalibration'],
        '0x3077': ['TM', '1', 'TimeOfGainCalibration'],
        '0x3080': ['OB', '1', 'BadPixelImage'],
        '0x3099': ['LT', '1', 'CalibrationNotes'],
        '0x4002': ['SQ', '1', 'PulserEquipmentSequence'],
        '0x4004': ['CS', '1', 'PulserType'],
        '0x4006': ['LT', '1', 'PulserNotes'],
        '0x4008': ['SQ', '1', 'ReceiverEquipmentSequence'],
        '0x400A': ['CS', '1', 'AmplifierType'],
        '0x400C': ['LT', '1', 'ReceiverNotes'],
        '0x400E': ['SQ', '1', 'PreAmplifierEquipmentSequence'],
        '0x400F': ['LT', '1', 'PreAmplifierNotes'],
        '0x4010': ['SQ', '1', 'TransmitTransducerSequence'],
        '0x4011': ['SQ', '1', 'ReceiveTransducerSequence'],
        '0x4012': ['US', '1', 'NumberOfElements'],
        '0x4013': ['CS', '1', 'ElementShape'],
        '0x4014': ['DS', '1', 'ElementDimensionA'],
        '0x4015': ['DS', '1', 'ElementDimensionB'],
        '0x4016': ['DS', '1', 'ElementPitchA'],
        '0x4017': ['DS', '1', 'MeasuredBeamDimensionA'],
        '0x4018': ['DS', '1', 'MeasuredBeamDimensionB'],
        '0x4019': ['DS', '1', 'LocationOfMeasuredBeamDiameter'],
        '0x401A': ['DS', '1', 'NominalFrequency'],
        '0x401B': ['DS', '1', 'MeasuredCenterFrequency'],
        '0x401C': ['DS', '1', 'MeasuredBandwidth'],
        '0x401D': ['DS', '1', 'ElementPitchB'],
        '0x4020': ['SQ', '1', 'PulserSettingsSequence'],
        '0x4022': ['DS', '1', 'PulseWidth'],
        '0x4024': ['DS', '1', 'ExcitationFrequency'],
        '0x4026': ['CS', '1', 'ModulationType'],
        '0x4028': ['DS', '1', 'Damping'],
        '0x4030': ['SQ', '1', 'ReceiverSettingsSequence'],
        '0x4031': ['DS', '1', 'AcquiredSoundpathLength'],
        '0x4032': ['CS', '1', 'AcquisitionCompressionType'],
        '0x4033': ['IS', '1', 'AcquisitionSampleSize'],
        '0x4034': ['DS', '1', 'RectifierSmoothing'],
        '0x4035': ['SQ', '1', 'DACSequence'],
        '0x4036': ['CS', '1', 'DACType'],
        '0x4038': ['DS', '1-n', 'DACGainPoints'],
        '0x403A': ['DS', '1-n', 'DACTimePoints'],
        '0x403C': ['DS', '1-n', 'DACAmplitude'],
        '0x4040': ['SQ', '1', 'PreAmplifierSettingsSequence'],
        '0x4050': ['SQ', '1', 'TransmitTransducerSettingsSequence'],
        '0x4051': ['SQ', '1', 'ReceiveTransducerSettingsSequence'],
        '0x4052': ['DS', '1', 'IncidentAngle'],
        '0x4054': ['ST', '1', 'CouplingTechnique'],
        '0x4056': ['ST', '1', 'CouplingMedium'],
        '0x4057': ['DS', '1', 'CouplingVelocity'],
        '0x4058': ['DS', '1', 'ProbeCenterLocationX'],
        '0x4059': ['DS', '1', 'ProbeCenterLocationZ'],
        '0x405A': ['DS', '1', 'SoundPathLength'],
        '0x405C': ['ST', '1', 'DelayLawIdentifier'],
        '0x4060': ['SQ', '1', 'GateSettingsSequence'],
        '0x4062': ['DS', '1', 'GateThreshold'],
        '0x4064': ['DS', '1', 'VelocityOfSound'],
        '0x4070': ['SQ', '1', 'CalibrationSettingsSequence'],
        '0x4072': ['ST', '1', 'CalibrationProcedure'],
        '0x4074': ['SH', '1', 'ProcedureVersion'],
        '0x4076': ['DA', '1', 'ProcedureCreationDate'],
        '0x4078': ['DA', '1', 'ProcedureExpirationDate'],
        '0x407A': ['DA', '1', 'ProcedureLastModifiedDate'],
        '0x407C': ['TM', '1-n', 'CalibrationTime'],
        '0x407E': ['DA', '1-n', 'CalibrationDate'],
        '0x4080': ['SQ', '1', 'ProbeDriveEquipmentSequence'],
        '0x4081': ['CS', '1', 'DriveType'],
        '0x4082': ['LT', '1', 'ProbeDriveNotes'],
        '0x4083': ['SQ', '1', 'DriveProbeSequence'],
        '0x4084': ['DS', '1', 'ProbeInductance'],
        '0x4085': ['DS', '1', 'ProbeResistance'],
        '0x4086': ['SQ', '1', 'ReceiveProbeSequence'],
        '0x4087': ['SQ', '1', 'ProbeDriveSettingsSequence'],
        '0x4088': ['DS', '1', 'BridgeResistors'],
        '0x4089': ['DS', '1', 'ProbeOrientationAngle'],
        '0x408B': ['DS', '1', 'UserSelectedGainY'],
        '0x408C': ['DS', '1', 'UserSelectedPhase'],
        '0x408D': ['DS', '1', 'UserSelectedOffsetX'],
        '0x408E': ['DS', '1', 'UserSelectedOffsetY'],
        '0x4091': ['SQ', '1', 'ChannelSettingsSequence'],
        '0x4092': ['DS', '1', 'ChannelThreshold'],
        '0x409A': ['SQ', '1', 'ScannerSettingsSequence'],
        '0x409B': ['ST', '1', 'ScanProcedure'],
        '0x409C': ['DS', '1', 'TranslationRateX'],
        '0x409D': ['DS', '1', 'TranslationRateY'],
        '0x409F': ['DS', '1', 'ChannelOverlap'],
        '0x40A0': ['LO', '1', 'ImageQualityIndicatorType'],
        '0x40A1': ['LO', '1', 'ImageQualityIndicatorMaterial'],
        '0x40A2': ['LO', '1', 'ImageQualityIndicatorSize'],
        '0x5002': ['IS', '1', 'LINACEnergy'],
        '0x5004': ['IS', '1', 'LINACOutput'],
        '0x5100': ['US', '1', 'ActiveAperture'],
        '0x5101': ['DS', '1', 'TotalAperture'],
        '0x5102': ['DS', '1', 'ApertureElevation'],
        '0x5103': ['DS', '1', 'MainLobeAngle'],
        '0x5104': ['DS', '1', 'MainRoofAngle'],
        '0x5105': ['CS', '1', 'ConnectorType'],
        '0x5106': ['SH', '1', 'WedgeModelNumber'],
        '0x5107': ['DS', '1', 'WedgeAngleFloat'],
        '0x5108': ['DS', '1', 'WedgeRoofAngle'],
        '0x5109': ['CS', '1', 'WedgeElement1Position'],
        '0x510A': ['DS', '1', 'WedgeMaterialVelocity'],
        '0x510B': ['SH', '1', 'WedgeMaterial'],
        '0x510C': ['DS', '1', 'WedgeOffsetZ'],
        '0x510D': ['DS', '1', 'WedgeOriginOffsetX'],
        '0x510E': ['DS', '1', 'WedgeTimeDelay'],
        '0x510F': ['SH', '1', 'WedgeName'],
        '0x5110': ['SH', '1', 'WedgeManufacturerName'],
        '0x5111': ['LO', '1', 'WedgeDescription'],
        '0x5112': ['DS', '1', 'NominalBeamAngle'],
        '0x5113': ['DS', '1', 'WedgeOffsetX'],
        '0x5114': ['DS', '1', 'WedgeOffsetY'],
        '0x5115': ['DS', '1', 'WedgeTotalLength'],
        '0x5116': ['DS', '1', 'WedgeInContactLength'],
        '0x5117': ['DS', '1', 'WedgeFrontGap'],
        '0x5118': ['DS', '1', 'WedgeTotalHeight'],
        '0x5119': ['DS', '1', 'WedgeFrontHeight'],
        '0x511A': ['DS', '1', 'WedgeRearHeight'],
        '0x511B': ['DS', '1', 'WedgeTotalWidth'],
        '0x511C': ['DS', '1', 'WedgeInContactWidth'],
        '0x511D': ['DS', '1', 'WedgeChamferHeight'],
        '0x511E': ['CS', '1', 'WedgeCurve'],
        '0x511F': ['DS', '1', 'RadiusAlongWedge'],
    },
    '0x0018': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['LO', '1', 'ContrastBolusAgent'],
        '0x0012': ['SQ', '1', 'ContrastBolusAgentSequence'],
        '0x0013': ['FL', '1', 'ContrastBolusT1Relaxivity'],
        '0x0014': ['SQ', '1', 'ContrastBolusAdministrationRouteSequence'],
        '0x0015': ['CS', '1', 'BodyPartExamined'],
        '0x0020': ['CS', '1-n', 'ScanningSequence'],
        '0x0021': ['CS', '1-n', 'SequenceVariant'],
        '0x0022': ['CS', '1-n', 'ScanOptions'],
        '0x0023': ['CS', '1', 'MRAcquisitionType'],
        '0x0024': ['SH', '1', 'SequenceName'],
        '0x0025': ['CS', '1', 'AngioFlag'],
        '0x0026': ['SQ', '1', 'InterventionDrugInformationSequence'],
        '0x0027': ['TM', '1', 'InterventionDrugStopTime'],
        '0x0028': ['DS', '1', 'InterventionDrugDose'],
        '0x0029': ['SQ', '1', 'InterventionDrugCodeSequence'],
        '0x002A': ['SQ', '1', 'AdditionalDrugSequence'],
        '0x0030': ['LO', '1-n', 'Radionuclide'],
        '0x0031': ['LO', '1', 'Radiopharmaceutical'],
        '0x0032': ['DS', '1', 'EnergyWindowCenterline'],
        '0x0033': ['DS', '1-n', 'EnergyWindowTotalWidth'],
        '0x0034': ['LO', '1', 'InterventionDrugName'],
        '0x0035': ['TM', '1', 'InterventionDrugStartTime'],
        '0x0036': ['SQ', '1', 'InterventionSequence'],
        '0x0037': ['CS', '1', 'TherapyType'],
        '0x0038': ['CS', '1', 'InterventionStatus'],
        '0x0039': ['CS', '1', 'TherapyDescription'],
        '0x003A': ['ST', '1', 'InterventionDescription'],
        '0x0040': ['IS', '1', 'CineRate'],
        '0x0042': ['CS', '1', 'InitialCineRunState'],
        '0x0050': ['DS', '1', 'SliceThickness'],
        '0x0060': ['DS', '1', 'KVP'],
        '0x0070': ['IS', '1', 'CountsAccumulated'],
        '0x0071': ['CS', '1', 'AcquisitionTerminationCondition'],
        '0x0072': ['DS', '1', 'EffectiveDuration'],
        '0x0073': ['CS', '1', 'AcquisitionStartCondition'],
        '0x0074': ['IS', '1', 'AcquisitionStartConditionData'],
        '0x0075': ['IS', '1', 'AcquisitionTerminationConditionData'],
        '0x0080': ['DS', '1', 'RepetitionTime'],
        '0x0081': ['DS', '1', 'EchoTime'],
        '0x0082': ['DS', '1', 'InversionTime'],
        '0x0083': ['DS', '1', 'NumberOfAverages'],
        '0x0084': ['DS', '1', 'ImagingFrequency'],
        '0x0085': ['SH', '1', 'ImagedNucleus'],
        '0x0086': ['IS', '1-n', 'EchoNumbers'],
        '0x0087': ['DS', '1', 'MagneticFieldStrength'],
        '0x0088': ['DS', '1', 'SpacingBetweenSlices'],
        '0x0089': ['IS', '1', 'NumberOfPhaseEncodingSteps'],
        '0x0090': ['DS', '1', 'DataCollectionDiameter'],
        '0x0091': ['IS', '1', 'EchoTrainLength'],
        '0x0093': ['DS', '1', 'PercentSampling'],
        '0x0094': ['DS', '1', 'PercentPhaseFieldOfView'],
        '0x0095': ['DS', '1', 'PixelBandwidth'],
        '0x1000': ['LO', '1', 'DeviceSerialNumber'],
        '0x1002': ['UI', '1', 'DeviceUID'],
        '0x1003': ['LO', '1', 'DeviceID'],
        '0x1004': ['LO', '1', 'PlateID'],
        '0x1005': ['LO', '1', 'GeneratorID'],
        '0x1006': ['LO', '1', 'GridID'],
        '0x1007': ['LO', '1', 'CassetteID'],
        '0x1008': ['LO', '1', 'GantryID'],
        '0x1010': ['LO', '1', 'SecondaryCaptureDeviceID'],
        '0x1011': ['LO', '1', 'HardcopyCreationDeviceID'],
        '0x1012': ['DA', '1', 'DateOfSecondaryCapture'],
        '0x1014': ['TM', '1', 'TimeOfSecondaryCapture'],
        '0x1016': ['LO', '1', 'SecondaryCaptureDeviceManufacturer'],
        '0x1017': ['LO', '1', 'HardcopyDeviceManufacturer'],
        '0x1018': ['LO', '1', 'SecondaryCaptureDeviceManufacturerModelName'],
        '0x1019': ['LO', '1-n', 'SecondaryCaptureDeviceSoftwareVersions'],
        '0x101A': ['LO', '1-n', 'HardcopyDeviceSoftwareVersion'],
        '0x101B': ['LO', '1', 'HardcopyDeviceManufacturerModelName'],
        '0x1020': ['LO', '1-n', 'SoftwareVersions'],
        '0x1022': ['SH', '1', 'VideoImageFormatAcquired'],
        '0x1023': ['LO', '1', 'DigitalImageFormatAcquired'],
        '0x1030': ['LO', '1', 'ProtocolName'],
        '0x1040': ['LO', '1', 'ContrastBolusRoute'],
        '0x1041': ['DS', '1', 'ContrastBolusVolume'],
        '0x1042': ['TM', '1', 'ContrastBolusStartTime'],
        '0x1043': ['TM', '1', 'ContrastBolusStopTime'],
        '0x1044': ['DS', '1', 'ContrastBolusTotalDose'],
        '0x1045': ['IS', '1', 'SyringeCounts'],
        '0x1046': ['DS', '1-n', 'ContrastFlowRate'],
        '0x1047': ['DS', '1-n', 'ContrastFlowDuration'],
        '0x1048': ['CS', '1', 'ContrastBolusIngredient'],
        '0x1049': ['DS', '1', 'ContrastBolusIngredientConcentration'],
        '0x1050': ['DS', '1', 'SpatialResolution'],
        '0x1060': ['DS', '1', 'TriggerTime'],
        '0x1061': ['LO', '1', 'TriggerSourceOrType'],
        '0x1062': ['IS', '1', 'NominalInterval'],
        '0x1063': ['DS', '1', 'FrameTime'],
        '0x1064': ['LO', '1', 'CardiacFramingType'],
        '0x1065': ['DS', '1-n', 'FrameTimeVector'],
        '0x1066': ['DS', '1', 'FrameDelay'],
        '0x1067': ['DS', '1', 'ImageTriggerDelay'],
        '0x1068': ['DS', '1', 'MultiplexGroupTimeOffset'],
        '0x1069': ['DS', '1', 'TriggerTimeOffset'],
        '0x106A': ['CS', '1', 'SynchronizationTrigger'],
        '0x106C': ['US', '2', 'SynchronizationChannel'],
        '0x106E': ['UL', '1', 'TriggerSamplePosition'],
        '0x1070': ['LO', '1', 'RadiopharmaceuticalRoute'],
        '0x1071': ['DS', '1', 'RadiopharmaceuticalVolume'],
        '0x1072': ['TM', '1', 'RadiopharmaceuticalStartTime'],
        '0x1073': ['TM', '1', 'RadiopharmaceuticalStopTime'],
        '0x1074': ['DS', '1', 'RadionuclideTotalDose'],
        '0x1075': ['DS', '1', 'RadionuclideHalfLife'],
        '0x1076': ['DS', '1', 'RadionuclidePositronFraction'],
        '0x1077': ['DS', '1', 'RadiopharmaceuticalSpecificActivity'],
        '0x1078': ['DT', '1', 'RadiopharmaceuticalStartDateTime'],
        '0x1079': ['DT', '1', 'RadiopharmaceuticalStopDateTime'],
        '0x1080': ['CS', '1', 'BeatRejectionFlag'],
        '0x1081': ['IS', '1', 'LowRRValue'],
        '0x1082': ['IS', '1', 'HighRRValue'],
        '0x1083': ['IS', '1', 'IntervalsAcquired'],
        '0x1084': ['IS', '1', 'IntervalsRejected'],
        '0x1085': ['LO', '1', 'PVCRejection'],
        '0x1086': ['IS', '1', 'SkipBeats'],
        '0x1088': ['IS', '1', 'HeartRate'],
        '0x1090': ['IS', '1', 'CardiacNumberOfImages'],
        '0x1094': ['IS', '1', 'TriggerWindow'],
        '0x1100': ['DS', '1', 'ReconstructionDiameter'],
        '0x1110': ['DS', '1', 'DistanceSourceToDetector'],
        '0x1111': ['DS', '1', 'DistanceSourceToPatient'],
        '0x1114': ['DS', '1', 'EstimatedRadiographicMagnificationFactor'],
        '0x1120': ['DS', '1', 'GantryDetectorTilt'],
        '0x1121': ['DS', '1', 'GantryDetectorSlew'],
        '0x1130': ['DS', '1', 'TableHeight'],
        '0x1131': ['DS', '1', 'TableTraverse'],
        '0x1134': ['CS', '1', 'TableMotion'],
        '0x1135': ['DS', '1-n', 'TableVerticalIncrement'],
        '0x1136': ['DS', '1-n', 'TableLateralIncrement'],
        '0x1137': ['DS', '1-n', 'TableLongitudinalIncrement'],
        '0x1138': ['DS', '1', 'TableAngle'],
        '0x113A': ['CS', '1', 'TableType'],
        '0x1140': ['CS', '1', 'RotationDirection'],
        '0x1141': ['DS', '1', 'AngularPosition'],
        '0x1142': ['DS', '1-n', 'RadialPosition'],
        '0x1143': ['DS', '1', 'ScanArc'],
        '0x1144': ['DS', '1', 'AngularStep'],
        '0x1145': ['DS', '1', 'CenterOfRotationOffset'],
        '0x1146': ['DS', '1-n', 'RotationOffset'],
        '0x1147': ['CS', '1', 'FieldOfViewShape'],
        '0x1149': ['IS', '1-2', 'FieldOfViewDimensions'],
        '0x1150': ['IS', '1', 'ExposureTime'],
        '0x1151': ['IS', '1', 'XRayTubeCurrent'],
        '0x1152': ['IS', '1', 'Exposure'],
        '0x1153': ['IS', '1', 'ExposureInuAs'],
        '0x1154': ['DS', '1', 'AveragePulseWidth'],
        '0x1155': ['CS', '1', 'RadiationSetting'],
        '0x1156': ['CS', '1', 'RectificationType'],
        '0x115A': ['CS', '1', 'RadiationMode'],
        '0x115E': ['DS', '1', 'ImageAndFluoroscopyAreaDoseProduct'],
        '0x1160': ['SH', '1', 'FilterType'],
        '0x1161': ['LO', '1-n', 'TypeOfFilters'],
        '0x1162': ['DS', '1', 'IntensifierSize'],
        '0x1164': ['DS', '2', 'ImagerPixelSpacing'],
        '0x1166': ['CS', '1-n', 'Grid'],
        '0x1170': ['IS', '1', 'GeneratorPower'],
        '0x1180': ['SH', '1', 'CollimatorGridName'],
        '0x1181': ['CS', '1', 'CollimatorType'],
        '0x1182': ['IS', '1-2', 'FocalDistance'],
        '0x1183': ['DS', '1-2', 'XFocusCenter'],
        '0x1184': ['DS', '1-2', 'YFocusCenter'],
        '0x1190': ['DS', '1-n', 'FocalSpots'],
        '0x1191': ['CS', '1', 'AnodeTargetMaterial'],
        '0x11A0': ['DS', '1', 'BodyPartThickness'],
        '0x11A2': ['DS', '1', 'CompressionForce'],
        '0x11A4': ['LO', '1', 'PaddleDescription'],
        '0x1200': ['DA', '1-n', 'DateOfLastCalibration'],
        '0x1201': ['TM', '1-n', 'TimeOfLastCalibration'],
        '0x1202': ['DT', '1', 'DateTimeOfLastCalibration'],
        '0x1210': ['SH', '1-n', 'ConvolutionKernel'],
        '0x1240': ['IS', '1-n', 'UpperLowerPixelValues'],
        '0x1242': ['IS', '1', 'ActualFrameDuration'],
        '0x1243': ['IS', '1', 'CountRate'],
        '0x1244': ['US', '1', 'PreferredPlaybackSequencing'],
        '0x1250': ['SH', '1', 'ReceiveCoilName'],
        '0x1251': ['SH', '1', 'TransmitCoilName'],
        '0x1260': ['SH', '1', 'PlateType'],
        '0x1261': ['LO', '1', 'PhosphorType'],
        '0x1300': ['DS', '1', 'ScanVelocity'],
        '0x1301': ['CS', '1-n', 'WholeBodyTechnique'],
        '0x1302': ['IS', '1', 'ScanLength'],
        '0x1310': ['US', '4', 'AcquisitionMatrix'],
        '0x1312': ['CS', '1', 'InPlanePhaseEncodingDirection'],
        '0x1314': ['DS', '1', 'FlipAngle'],
        '0x1315': ['CS', '1', 'VariableFlipAngleFlag'],
        '0x1316': ['DS', '1', 'SAR'],
        '0x1318': ['DS', '1', 'dBdt'],
        '0x1400': ['LO', '1', 'AcquisitionDeviceProcessingDescription'],
        '0x1401': ['LO', '1', 'AcquisitionDeviceProcessingCode'],
        '0x1402': ['CS', '1', 'CassetteOrientation'],
        '0x1403': ['CS', '1', 'CassetteSize'],
        '0x1404': ['US', '1', 'ExposuresOnPlate'],
        '0x1405': ['IS', '1', 'RelativeXRayExposure'],
        '0x1411': ['DS', '1', 'ExposureIndex'],
        '0x1412': ['DS', '1', 'TargetExposureIndex'],
        '0x1413': ['DS', '1', 'DeviationIndex'],
        '0x1450': ['DS', '1', 'ColumnAngulation'],
        '0x1460': ['DS', '1', 'TomoLayerHeight'],
        '0x1470': ['DS', '1', 'TomoAngle'],
        '0x1480': ['DS', '1', 'TomoTime'],
        '0x1490': ['CS', '1', 'TomoType'],
        '0x1491': ['CS', '1', 'TomoClass'],
        '0x1495': ['IS', '1', 'NumberOfTomosynthesisSourceImages'],
        '0x1500': ['CS', '1', 'PositionerMotion'],
        '0x1508': ['CS', '1', 'PositionerType'],
        '0x1510': ['DS', '1', 'PositionerPrimaryAngle'],
        '0x1511': ['DS', '1', 'PositionerSecondaryAngle'],
        '0x1520': ['DS', '1-n', 'PositionerPrimaryAngleIncrement'],
        '0x1521': ['DS', '1-n', 'PositionerSecondaryAngleIncrement'],
        '0x1530': ['DS', '1', 'DetectorPrimaryAngle'],
        '0x1531': ['DS', '1', 'DetectorSecondaryAngle'],
        '0x1600': ['CS', '1-3', 'ShutterShape'],
        '0x1602': ['IS', '1', 'ShutterLeftVerticalEdge'],
        '0x1604': ['IS', '1', 'ShutterRightVerticalEdge'],
        '0x1606': ['IS', '1', 'ShutterUpperHorizontalEdge'],
        '0x1608': ['IS', '1', 'ShutterLowerHorizontalEdge'],
        '0x1610': ['IS', '2', 'CenterOfCircularShutter'],
        '0x1612': ['IS', '1', 'RadiusOfCircularShutter'],
        '0x1620': ['IS', '2-2n', 'VerticesOfThePolygonalShutter'],
        '0x1622': ['US', '1', 'ShutterPresentationValue'],
        '0x1623': ['US', '1', 'ShutterOverlayGroup'],
        '0x1624': ['US', '3', 'ShutterPresentationColorCIELabValue'],
        '0x1700': ['CS', '1-3', 'CollimatorShape'],
        '0x1702': ['IS', '1', 'CollimatorLeftVerticalEdge'],
        '0x1704': ['IS', '1', 'CollimatorRightVerticalEdge'],
        '0x1706': ['IS', '1', 'CollimatorUpperHorizontalEdge'],
        '0x1708': ['IS', '1', 'CollimatorLowerHorizontalEdge'],
        '0x1710': ['IS', '2', 'CenterOfCircularCollimator'],
        '0x1712': ['IS', '1', 'RadiusOfCircularCollimator'],
        '0x1720': ['IS', '2-2n', 'VerticesOfThePolygonalCollimator'],
        '0x1800': ['CS', '1', 'AcquisitionTimeSynchronized'],
        '0x1801': ['SH', '1', 'TimeSource'],
        '0x1802': ['CS', '1', 'TimeDistributionProtocol'],
        '0x1803': ['LO', '1', 'NTPSourceAddress'],
        '0x2001': ['IS', '1-n', 'PageNumberVector'],
        '0x2002': ['SH', '1-n', 'FrameLabelVector'],
        '0x2003': ['DS', '1-n', 'FramePrimaryAngleVector'],
        '0x2004': ['DS', '1-n', 'FrameSecondaryAngleVector'],
        '0x2005': ['DS', '1-n', 'SliceLocationVector'],
        '0x2006': ['SH', '1-n', 'DisplayWindowLabelVector'],
        '0x2010': ['DS', '2', 'NominalScannedPixelSpacing'],
        '0x2020': ['CS', '1', 'DigitizingDeviceTransportDirection'],
        '0x2030': ['DS', '1', 'RotationOfScannedFilm'],
        '0x2041': ['SQ', '1', 'BiopsyTargetSequence'],
        '0x2042': ['UI', '1', 'TargetUID'],
        '0x2043': ['FL', '2', 'LocalizingCursorPosition'],
        '0x2044': ['FL', '3', 'CalculatedTargetPosition'],
        '0x2045': ['SH', '1', 'TargetLabel'],
        '0x2046': ['FL', '1', 'DisplayedZValue'],
        '0x3100': ['CS', '1', 'IVUSAcquisition'],
        '0x3101': ['DS', '1', 'IVUSPullbackRate'],
        '0x3102': ['DS', '1', 'IVUSGatedRate'],
        '0x3103': ['IS', '1', 'IVUSPullbackStartFrameNumber'],
        '0x3104': ['IS', '1', 'IVUSPullbackStopFrameNumber'],
        '0x3105': ['IS', '1-n', 'LesionNumber'],
        '0x4000': ['LT', '1', 'AcquisitionComments'],
        '0x5000': ['SH', '1-n', 'OutputPower'],
        '0x5010': ['LO', '1-n', 'TransducerData'],
        '0x5012': ['DS', '1', 'FocusDepth'],
        '0x5020': ['LO', '1', 'ProcessingFunction'],
        '0x5021': ['LO', '1', 'PostprocessingFunction'],
        '0x5022': ['DS', '1', 'MechanicalIndex'],
        '0x5024': ['DS', '1', 'BoneThermalIndex'],
        '0x5026': ['DS', '1', 'CranialThermalIndex'],
        '0x5027': ['DS', '1', 'SoftTissueThermalIndex'],
        '0x5028': ['DS', '1', 'SoftTissueFocusThermalIndex'],
        '0x5029': ['DS', '1', 'SoftTissueSurfaceThermalIndex'],
        '0x5030': ['DS', '1', 'DynamicRange'],
        '0x5040': ['DS', '1', 'TotalGain'],
        '0x5050': ['IS', '1', 'DepthOfScanField'],
        '0x5100': ['CS', '1', 'PatientPosition'],
        '0x5101': ['CS', '1', 'ViewPosition'],
        '0x5104': ['SQ', '1', 'ProjectionEponymousNameCodeSequence'],
        '0x5210': ['DS', '6', 'ImageTransformationMatrix'],
        '0x5212': ['DS', '3', 'ImageTranslationVector'],
        '0x6000': ['DS', '1', 'Sensitivity'],
        '0x6011': ['SQ', '1', 'SequenceOfUltrasoundRegions'],
        '0x6012': ['US', '1', 'RegionSpatialFormat'],
        '0x6014': ['US', '1', 'RegionDataType'],
        '0x6016': ['UL', '1', 'RegionFlags'],
        '0x6018': ['UL', '1', 'RegionLocationMinX0'],
        '0x601A': ['UL', '1', 'RegionLocationMinY0'],
        '0x601C': ['UL', '1', 'RegionLocationMaxX1'],
        '0x601E': ['UL', '1', 'RegionLocationMaxY1'],
        '0x6020': ['SL', '1', 'ReferencePixelX0'],
        '0x6022': ['SL', '1', 'ReferencePixelY0'],
        '0x6024': ['US', '1', 'PhysicalUnitsXDirection'],
        '0x6026': ['US', '1', 'PhysicalUnitsYDirection'],
        '0x6028': ['FD', '1', 'ReferencePixelPhysicalValueX'],
        '0x602A': ['FD', '1', 'ReferencePixelPhysicalValueY'],
        '0x602C': ['FD', '1', 'PhysicalDeltaX'],
        '0x602E': ['FD', '1', 'PhysicalDeltaY'],
        '0x6030': ['UL', '1', 'TransducerFrequency'],
        '0x6031': ['CS', '1', 'TransducerType'],
        '0x6032': ['UL', '1', 'PulseRepetitionFrequency'],
        '0x6034': ['FD', '1', 'DopplerCorrectionAngle'],
        '0x6036': ['FD', '1', 'SteeringAngle'],
        '0x6038': ['UL', '1', 'DopplerSampleVolumeXPositionRetired'],
        '0x6039': ['SL', '1', 'DopplerSampleVolumeXPosition'],
        '0x603A': ['UL', '1', 'DopplerSampleVolumeYPositionRetired'],
        '0x603B': ['SL', '1', 'DopplerSampleVolumeYPosition'],
        '0x603C': ['UL', '1', 'TMLinePositionX0Retired'],
        '0x603D': ['SL', '1', 'TMLinePositionX0'],
        '0x603E': ['UL', '1', 'TMLinePositionY0Retired'],
        '0x603F': ['SL', '1', 'TMLinePositionY0'],
        '0x6040': ['UL', '1', 'TMLinePositionX1Retired'],
        '0x6041': ['SL', '1', 'TMLinePositionX1'],
        '0x6042': ['UL', '1', 'TMLinePositionY1Retired'],
        '0x6043': ['SL', '1', 'TMLinePositionY1'],
        '0x6044': ['US', '1', 'PixelComponentOrganization'],
        '0x6046': ['UL', '1', 'PixelComponentMask'],
        '0x6048': ['UL', '1', 'PixelComponentRangeStart'],
        '0x604A': ['UL', '1', 'PixelComponentRangeStop'],
        '0x604C': ['US', '1', 'PixelComponentPhysicalUnits'],
        '0x604E': ['US', '1', 'PixelComponentDataType'],
        '0x6050': ['UL', '1', 'NumberOfTableBreakPoints'],
        '0x6052': ['UL', '1-n', 'TableOfXBreakPoints'],
        '0x6054': ['FD', '1-n', 'TableOfYBreakPoints'],
        '0x6056': ['UL', '1', 'NumberOfTableEntries'],
        '0x6058': ['UL', '1-n', 'TableOfPixelValues'],
        '0x605A': ['FL', '1-n', 'TableOfParameterValues'],
        '0x6060': ['FL', '1-n', 'RWaveTimeVector'],
        '0x7000': ['CS', '1', 'DetectorConditionsNominalFlag'],
        '0x7001': ['DS', '1', 'DetectorTemperature'],
        '0x7004': ['CS', '1', 'DetectorType'],
        '0x7005': ['CS', '1', 'DetectorConfiguration'],
        '0x7006': ['LT', '1', 'DetectorDescription'],
        '0x7008': ['LT', '1', 'DetectorMode'],
        '0x700A': ['SH', '1', 'DetectorID'],
        '0x700C': ['DA', '1', 'DateOfLastDetectorCalibration'],
        '0x700E': ['TM', '1', 'TimeOfLastDetectorCalibration'],
        '0x7010': ['IS', '1', 'ExposuresOnDetectorSinceLastCalibration'],
        '0x7011': ['IS', '1', 'ExposuresOnDetectorSinceManufactured'],
        '0x7012': ['DS', '1', 'DetectorTimeSinceLastExposure'],
        '0x7014': ['DS', '1', 'DetectorActiveTime'],
        '0x7016': ['DS', '1', 'DetectorActivationOffsetFromExposure'],
        '0x701A': ['DS', '2', 'DetectorBinning'],
        '0x7020': ['DS', '2', 'DetectorElementPhysicalSize'],
        '0x7022': ['DS', '2', 'DetectorElementSpacing'],
        '0x7024': ['CS', '1', 'DetectorActiveShape'],
        '0x7026': ['DS', '1-2', 'DetectorActiveDimensions'],
        '0x7028': ['DS', '2', 'DetectorActiveOrigin'],
        '0x702A': ['LO', '1', 'DetectorManufacturerName'],
        '0x702B': ['LO', '1', 'DetectorManufacturerModelName'],
        '0x7030': ['DS', '2', 'FieldOfViewOrigin'],
        '0x7032': ['DS', '1', 'FieldOfViewRotation'],
        '0x7034': ['CS', '1', 'FieldOfViewHorizontalFlip'],
        '0x7036': ['FL', '2', 'PixelDataAreaOriginRelativeToFOV'],
        '0x7038': ['FL', '1', 'PixelDataAreaRotationAngleRelativeToFOV'],
        '0x7040': ['LT', '1', 'GridAbsorbingMaterial'],
        '0x7041': ['LT', '1', 'GridSpacingMaterial'],
        '0x7042': ['DS', '1', 'GridThickness'],
        '0x7044': ['DS', '1', 'GridPitch'],
        '0x7046': ['IS', '2', 'GridAspectRatio'],
        '0x7048': ['DS', '1', 'GridPeriod'],
        '0x704C': ['DS', '1', 'GridFocalDistance'],
        '0x7050': ['CS', '1-n', 'FilterMaterial'],
        '0x7052': ['DS', '1-n', 'FilterThicknessMinimum'],
        '0x7054': ['DS', '1-n', 'FilterThicknessMaximum'],
        '0x7056': ['FL', '1-n', 'FilterBeamPathLengthMinimum'],
        '0x7058': ['FL', '1-n', 'FilterBeamPathLengthMaximum'],
        '0x7060': ['CS', '1', 'ExposureControlMode'],
        '0x7062': ['LT', '1', 'ExposureControlModeDescription'],
        '0x7064': ['CS', '1', 'ExposureStatus'],
        '0x7065': ['DS', '1', 'PhototimerSetting'],
        '0x8150': ['DS', '1', 'ExposureTimeInuS'],
        '0x8151': ['DS', '1', 'XRayTubeCurrentInuA'],
        '0x9004': ['CS', '1', 'ContentQualification'],
        '0x9005': ['SH', '1', 'PulseSequenceName'],
        '0x9006': ['SQ', '1', 'MRImagingModifierSequence'],
        '0x9008': ['CS', '1', 'EchoPulseSequence'],
        '0x9009': ['CS', '1', 'InversionRecovery'],
        '0x9010': ['CS', '1', 'FlowCompensation'],
        '0x9011': ['CS', '1', 'MultipleSpinEcho'],
        '0x9012': ['CS', '1', 'MultiPlanarExcitation'],
        '0x9014': ['CS', '1', 'PhaseContrast'],
        '0x9015': ['CS', '1', 'TimeOfFlightContrast'],
        '0x9016': ['CS', '1', 'Spoiling'],
        '0x9017': ['CS', '1', 'SteadyStatePulseSequence'],
        '0x9018': ['CS', '1', 'EchoPlanarPulseSequence'],
        '0x9019': ['FD', '1', 'TagAngleFirstAxis'],
        '0x9020': ['CS', '1', 'MagnetizationTransfer'],
        '0x9021': ['CS', '1', 'T2Preparation'],
        '0x9022': ['CS', '1', 'BloodSignalNulling'],
        '0x9024': ['CS', '1', 'SaturationRecovery'],
        '0x9025': ['CS', '1', 'SpectrallySelectedSuppression'],
        '0x9026': ['CS', '1', 'SpectrallySelectedExcitation'],
        '0x9027': ['CS', '1', 'SpatialPresaturation'],
        '0x9028': ['CS', '1', 'Tagging'],
        '0x9029': ['CS', '1', 'OversamplingPhase'],
        '0x9030': ['FD', '1', 'TagSpacingFirstDimension'],
        '0x9032': ['CS', '1', 'GeometryOfKSpaceTraversal'],
        '0x9033': ['CS', '1', 'SegmentedKSpaceTraversal'],
        '0x9034': ['CS', '1', 'RectilinearPhaseEncodeReordering'],
        '0x9035': ['FD', '1', 'TagThickness'],
        '0x9036': ['CS', '1', 'PartialFourierDirection'],
        '0x9037': ['CS', '1', 'CardiacSynchronizationTechnique'],
        '0x9041': ['LO', '1', 'ReceiveCoilManufacturerName'],
        '0x9042': ['SQ', '1', 'MRReceiveCoilSequence'],
        '0x9043': ['CS', '1', 'ReceiveCoilType'],
        '0x9044': ['CS', '1', 'QuadratureReceiveCoil'],
        '0x9045': ['SQ', '1', 'MultiCoilDefinitionSequence'],
        '0x9046': ['LO', '1', 'MultiCoilConfiguration'],
        '0x9047': ['SH', '1', 'MultiCoilElementName'],
        '0x9048': ['CS', '1', 'MultiCoilElementUsed'],
        '0x9049': ['SQ', '1', 'MRTransmitCoilSequence'],
        '0x9050': ['LO', '1', 'TransmitCoilManufacturerName'],
        '0x9051': ['CS', '1', 'TransmitCoilType'],
        '0x9052': ['FD', '1-2', 'SpectralWidth'],
        '0x9053': ['FD', '1-2', 'ChemicalShiftReference'],
        '0x9054': ['CS', '1', 'VolumeLocalizationTechnique'],
        '0x9058': ['US', '1', 'MRAcquisitionFrequencyEncodingSteps'],
        '0x9059': ['CS', '1', 'Decoupling'],
        '0x9060': ['CS', '1-2', 'DecoupledNucleus'],
        '0x9061': ['FD', '1-2', 'DecouplingFrequency'],
        '0x9062': ['CS', '1', 'DecouplingMethod'],
        '0x9063': ['FD', '1-2', 'DecouplingChemicalShiftReference'],
        '0x9064': ['CS', '1', 'KSpaceFiltering'],
        '0x9065': ['CS', '1-2', 'TimeDomainFiltering'],
        '0x9066': ['US', '1-2', 'NumberOfZeroFills'],
        '0x9067': ['CS', '1', 'BaselineCorrection'],
        '0x9069': ['FD', '1', 'ParallelReductionFactorInPlane'],
        '0x9070': ['FD', '1', 'CardiacRRIntervalSpecified'],
        '0x9073': ['FD', '1', 'AcquisitionDuration'],
        '0x9074': ['DT', '1', 'FrameAcquisitionDateTime'],
        '0x9075': ['CS', '1', 'DiffusionDirectionality'],
        '0x9076': ['SQ', '1', 'DiffusionGradientDirectionSequence'],
        '0x9077': ['CS', '1', 'ParallelAcquisition'],
        '0x9078': ['CS', '1', 'ParallelAcquisitionTechnique'],
        '0x9079': ['FD', '1-n', 'InversionTimes'],
        '0x9080': ['ST', '1', 'MetaboliteMapDescription'],
        '0x9081': ['CS', '1', 'PartialFourier'],
        '0x9082': ['FD', '1', 'EffectiveEchoTime'],
        '0x9083': ['SQ', '1', 'MetaboliteMapCodeSequence'],
        '0x9084': ['SQ', '1', 'ChemicalShiftSequence'],
        '0x9085': ['CS', '1', 'CardiacSignalSource'],
        '0x9087': ['FD', '1', 'DiffusionBValue'],
        '0x9089': ['FD', '3', 'DiffusionGradientOrientation'],
        '0x9090': ['FD', '3', 'VelocityEncodingDirection'],
        '0x9091': ['FD', '1', 'VelocityEncodingMinimumValue'],
        '0x9092': ['SQ', '1', 'VelocityEncodingAcquisitionSequence'],
        '0x9093': ['US', '1', 'NumberOfKSpaceTrajectories'],
        '0x9094': ['CS', '1', 'CoverageOfKSpace'],
        '0x9095': ['UL', '1', 'SpectroscopyAcquisitionPhaseRows'],
        '0x9096': ['FD', '1', 'ParallelReductionFactorInPlaneRetired'],
        '0x9098': ['FD', '1-2', 'TransmitterFrequency'],
        '0x9100': ['CS', '1-2', 'ResonantNucleus'],
        '0x9101': ['CS', '1', 'FrequencyCorrection'],
        '0x9103': ['SQ', '1', 'MRSpectroscopyFOVGeometrySequence'],
        '0x9104': ['FD', '1', 'SlabThickness'],
        '0x9105': ['FD', '3', 'SlabOrientation'],
        '0x9106': ['FD', '3', 'MidSlabPosition'],
        '0x9107': ['SQ', '1', 'MRSpatialSaturationSequence'],
        '0x9112': ['SQ', '1', 'MRTimingAndRelatedParametersSequence'],
        '0x9114': ['SQ', '1', 'MREchoSequence'],
        '0x9115': ['SQ', '1', 'MRModifierSequence'],
        '0x9117': ['SQ', '1', 'MRDiffusionSequence'],
        '0x9118': ['SQ', '1', 'CardiacSynchronizationSequence'],
        '0x9119': ['SQ', '1', 'MRAveragesSequence'],
        '0x9125': ['SQ', '1', 'MRFOVGeometrySequence'],
        '0x9126': ['SQ', '1', 'VolumeLocalizationSequence'],
        '0x9127': ['UL', '1', 'SpectroscopyAcquisitionDataColumns'],
        '0x9147': ['CS', '1', 'DiffusionAnisotropyType'],
        '0x9151': ['DT', '1', 'FrameReferenceDateTime'],
        '0x9152': ['SQ', '1', 'MRMetaboliteMapSequence'],
        '0x9155': ['FD', '1', 'ParallelReductionFactorOutOfPlane'],
        '0x9159': ['UL', '1', 'SpectroscopyAcquisitionOutOfPlanePhaseSteps'],
        '0x9166': ['CS', '1', 'BulkMotionStatus'],
        '0x9168': ['FD', '1', 'ParallelReductionFactorSecondInPlane'],
        '0x9169': ['CS', '1', 'CardiacBeatRejectionTechnique'],
        '0x9170': ['CS', '1', 'RespiratoryMotionCompensationTechnique'],
        '0x9171': ['CS', '1', 'RespiratorySignalSource'],
        '0x9172': ['CS', '1', 'BulkMotionCompensationTechnique'],
        '0x9173': ['CS', '1', 'BulkMotionSignalSource'],
        '0x9174': ['CS', '1', 'ApplicableSafetyStandardAgency'],
        '0x9175': ['LO', '1', 'ApplicableSafetyStandardDescription'],
        '0x9176': ['SQ', '1', 'OperatingModeSequence'],
        '0x9177': ['CS', '1', 'OperatingModeType'],
        '0x9178': ['CS', '1', 'OperatingMode'],
        '0x9179': ['CS', '1', 'SpecificAbsorptionRateDefinition'],
        '0x9180': ['CS', '1', 'GradientOutputType'],
        '0x9181': ['FD', '1', 'SpecificAbsorptionRateValue'],
        '0x9182': ['FD', '1', 'GradientOutput'],
        '0x9183': ['CS', '1', 'FlowCompensationDirection'],
        '0x9184': ['FD', '1', 'TaggingDelay'],
        '0x9185': ['ST', '1', 'RespiratoryMotionCompensationTechniqueDescription'],
        '0x9186': ['SH', '1', 'RespiratorySignalSourceID'],
        '0x9195': ['FD', '1', 'ChemicalShiftMinimumIntegrationLimitInHz'],
        '0x9196': ['FD', '1', 'ChemicalShiftMaximumIntegrationLimitInHz'],
        '0x9197': ['SQ', '1', 'MRVelocityEncodingSequence'],
        '0x9198': ['CS', '1', 'FirstOrderPhaseCorrection'],
        '0x9199': ['CS', '1', 'WaterReferencedPhaseCorrection'],
        '0x9200': ['CS', '1', 'MRSpectroscopyAcquisitionType'],
        '0x9214': ['CS', '1', 'RespiratoryCyclePosition'],
        '0x9217': ['FD', '1', 'VelocityEncodingMaximumValue'],
        '0x9218': ['FD', '1', 'TagSpacingSecondDimension'],
        '0x9219': ['SS', '1', 'TagAngleSecondAxis'],
        '0x9220': ['FD', '1', 'FrameAcquisitionDuration'],
        '0x9226': ['SQ', '1', 'MRImageFrameTypeSequence'],
        '0x9227': ['SQ', '1', 'MRSpectroscopyFrameTypeSequence'],
        '0x9231': ['US', '1', 'MRAcquisitionPhaseEncodingStepsInPlane'],
        '0x9232': ['US', '1', 'MRAcquisitionPhaseEncodingStepsOutOfPlane'],
        '0x9234': ['UL', '1', 'SpectroscopyAcquisitionPhaseColumns'],
        '0x9236': ['CS', '1', 'CardiacCyclePosition'],
        '0x9239': ['SQ', '1', 'SpecificAbsorptionRateSequence'],
        '0x9240': ['US', '1', 'RFEchoTrainLength'],
        '0x9241': ['US', '1', 'GradientEchoTrainLength'],
        '0x9250': ['CS', '1', 'ArterialSpinLabelingContrast'],
        '0x9251': ['SQ', '1', 'MRArterialSpinLabelingSequence'],
        '0x9252': ['LO', '1', 'ASLTechniqueDescription'],
        '0x9253': ['US', '1', 'ASLSlabNumber'],
        '0x9254': ['FD', '1', 'ASLSlabThickness'],
        '0x9255': ['FD', '3', 'ASLSlabOrientation'],
        '0x9256': ['FD', '3', 'ASLMidSlabPosition'],
        '0x9257': ['CS', '1', 'ASLContext'],
        '0x9258': ['UL', '1', 'ASLPulseTrainDuration'],
        '0x9259': ['CS', '1', 'ASLCrusherFlag'],
        '0x925A': ['FD', '1', 'ASLCrusherFlowLimit'],
        '0x925B': ['LO', '1', 'ASLCrusherDescription'],
        '0x925C': ['CS', '1', 'ASLBolusCutoffFlag'],
        '0x925D': ['SQ', '1', 'ASLBolusCutoffTimingSequence'],
        '0x925E': ['LO', '1', 'ASLBolusCutoffTechnique'],
        '0x925F': ['UL', '1', 'ASLBolusCutoffDelayTime'],
        '0x9260': ['SQ', '1', 'ASLSlabSequence'],
        '0x9295': ['FD', '1', 'ChemicalShiftMinimumIntegrationLimitInppm'],
        '0x9296': ['FD', '1', 'ChemicalShiftMaximumIntegrationLimitInppm'],
        '0x9297': ['CS', '1', 'WaterReferenceAcquisition'],
        '0x9298': ['IS', '1', 'EchoPeakPosition'],
        '0x9301': ['SQ', '1', 'CTAcquisitionTypeSequence'],
        '0x9302': ['CS', '1', 'AcquisitionType'],
        '0x9303': ['FD', '1', 'TubeAngle'],
        '0x9304': ['SQ', '1', 'CTAcquisitionDetailsSequence'],
        '0x9305': ['FD', '1', 'RevolutionTime'],
        '0x9306': ['FD', '1', 'SingleCollimationWidth'],
        '0x9307': ['FD', '1', 'TotalCollimationWidth'],
        '0x9308': ['SQ', '1', 'CTTableDynamicsSequence'],
        '0x9309': ['FD', '1', 'TableSpeed'],
        '0x9310': ['FD', '1', 'TableFeedPerRotation'],
        '0x9311': ['FD', '1', 'SpiralPitchFactor'],
        '0x9312': ['SQ', '1', 'CTGeometrySequence'],
        '0x9313': ['FD', '3', 'DataCollectionCenterPatient'],
        '0x9314': ['SQ', '1', 'CTReconstructionSequence'],
        '0x9315': ['CS', '1', 'ReconstructionAlgorithm'],
        '0x9316': ['CS', '1', 'ConvolutionKernelGroup'],
        '0x9317': ['FD', '2', 'ReconstructionFieldOfView'],
        '0x9318': ['FD', '3', 'ReconstructionTargetCenterPatient'],
        '0x9319': ['FD', '1', 'ReconstructionAngle'],
        '0x9320': ['SH', '1', 'ImageFilter'],
        '0x9321': ['SQ', '1', 'CTExposureSequence'],
        '0x9322': ['FD', '2', 'ReconstructionPixelSpacing'],
        '0x9323': ['CS', '1', 'ExposureModulationType'],
        '0x9324': ['FD', '1', 'EstimatedDoseSaving'],
        '0x9325': ['SQ', '1', 'CTXRayDetailsSequence'],
        '0x9326': ['SQ', '1', 'CTPositionSequence'],
        '0x9327': ['FD', '1', 'TablePosition'],
        '0x9328': ['FD', '1', 'ExposureTimeInms'],
        '0x9329': ['SQ', '1', 'CTImageFrameTypeSequence'],
        '0x9330': ['FD', '1', 'XRayTubeCurrentInmA'],
        '0x9332': ['FD', '1', 'ExposureInmAs'],
        '0x9333': ['CS', '1', 'ConstantVolumeFlag'],
        '0x9334': ['CS', '1', 'FluoroscopyFlag'],
        '0x9335': ['FD', '1', 'DistanceSourceToDataCollectionCenter'],
        '0x9337': ['US', '1', 'ContrastBolusAgentNumber'],
        '0x9338': ['SQ', '1', 'ContrastBolusIngredientCodeSequence'],
        '0x9340': ['SQ', '1', 'ContrastAdministrationProfileSequence'],
        '0x9341': ['SQ', '1', 'ContrastBolusUsageSequence'],
        '0x9342': ['CS', '1', 'ContrastBolusAgentAdministered'],
        '0x9343': ['CS', '1', 'ContrastBolusAgentDetected'],
        '0x9344': ['CS', '1', 'ContrastBolusAgentPhase'],
        '0x9345': ['FD', '1', 'CTDIvol'],
        '0x9346': ['SQ', '1', 'CTDIPhantomTypeCodeSequence'],
        '0x9351': ['FL', '1', 'CalciumScoringMassFactorPatient'],
        '0x9352': ['FL', '3', 'CalciumScoringMassFactorDevice'],
        '0x9353': ['FL', '1', 'EnergyWeightingFactor'],
        '0x9360': ['SQ', '1', 'CTAdditionalXRaySourceSequence'],
        '0x9401': ['SQ', '1', 'ProjectionPixelCalibrationSequence'],
        '0x9402': ['FL', '1', 'DistanceSourceToIsocenter'],
        '0x9403': ['FL', '1', 'DistanceObjectToTableTop'],
        '0x9404': ['FL', '2', 'ObjectPixelSpacingInCenterOfBeam'],
        '0x9405': ['SQ', '1', 'PositionerPositionSequence'],
        '0x9406': ['SQ', '1', 'TablePositionSequence'],
        '0x9407': ['SQ', '1', 'CollimatorShapeSequence'],
        '0x9410': ['CS', '1', 'PlanesInAcquisition'],
        '0x9412': ['SQ', '1', 'XAXRFFrameCharacteristicsSequence'],
        '0x9417': ['SQ', '1', 'FrameAcquisitionSequence'],
        '0x9420': ['CS', '1', 'XRayReceptorType'],
        '0x9423': ['LO', '1', 'AcquisitionProtocolName'],
        '0x9424': ['LT', '1', 'AcquisitionProtocolDescription'],
        '0x9425': ['CS', '1', 'ContrastBolusIngredientOpaque'],
        '0x9426': ['FL', '1', 'DistanceReceptorPlaneToDetectorHousing'],
        '0x9427': ['CS', '1', 'IntensifierActiveShape'],
        '0x9428': ['FL', '1-2', 'IntensifierActiveDimensions'],
        '0x9429': ['FL', '2', 'PhysicalDetectorSize'],
        '0x9430': ['FL', '2', 'PositionOfIsocenterProjection'],
        '0x9432': ['SQ', '1', 'FieldOfViewSequence'],
        '0x9433': ['LO', '1', 'FieldOfViewDescription'],
        '0x9434': ['SQ', '1', 'ExposureControlSensingRegionsSequence'],
        '0x9435': ['CS', '1', 'ExposureControlSensingRegionShape'],
        '0x9436': ['SS', '1', 'ExposureControlSensingRegionLeftVerticalEdge'],
        '0x9437': ['SS', '1', 'ExposureControlSensingRegionRightVerticalEdge'],
        '0x9438': ['SS', '1', 'ExposureControlSensingRegionUpperHorizontalEdge'],
        '0x9439': ['SS', '1', 'ExposureControlSensingRegionLowerHorizontalEdge'],
        '0x9440': ['SS', '2', 'CenterOfCircularExposureControlSensingRegion'],
        '0x9441': ['US', '1', 'RadiusOfCircularExposureControlSensingRegion'],
        '0x9442': ['SS', '2-n', 'VerticesOfThePolygonalExposureControlSensingRegion'],
        '0x9445': ['', '', ''],
        '0x9447': ['FL', '1', 'ColumnAngulationPatient'],
        '0x9449': ['FL', '1', 'BeamAngle'],
        '0x9451': ['SQ', '1', 'FrameDetectorParametersSequence'],
        '0x9452': ['FL', '1', 'CalculatedAnatomyThickness'],
        '0x9455': ['SQ', '1', 'CalibrationSequence'],
        '0x9456': ['SQ', '1', 'ObjectThicknessSequence'],
        '0x9457': ['CS', '1', 'PlaneIdentification'],
        '0x9461': ['FL', '1-2', 'FieldOfViewDimensionsInFloat'],
        '0x9462': ['SQ', '1', 'IsocenterReferenceSystemSequence'],
        '0x9463': ['FL', '1', 'PositionerIsocenterPrimaryAngle'],
        '0x9464': ['FL', '1', 'PositionerIsocenterSecondaryAngle'],
        '0x9465': ['FL', '1', 'PositionerIsocenterDetectorRotationAngle'],
        '0x9466': ['FL', '1', 'TableXPositionToIsocenter'],
        '0x9467': ['FL', '1', 'TableYPositionToIsocenter'],
        '0x9468': ['FL', '1', 'TableZPositionToIsocenter'],
        '0x9469': ['FL', '1', 'TableHorizontalRotationAngle'],
        '0x9470': ['FL', '1', 'TableHeadTiltAngle'],
        '0x9471': ['FL', '1', 'TableCradleTiltAngle'],
        '0x9472': ['SQ', '1', 'FrameDisplayShutterSequence'],
        '0x9473': ['FL', '1', 'AcquiredImageAreaDoseProduct'],
        '0x9474': ['CS', '1', 'CArmPositionerTabletopRelationship'],
        '0x9476': ['SQ', '1', 'XRayGeometrySequence'],
        '0x9477': ['SQ', '1', 'IrradiationEventIdentificationSequence'],
        '0x9504': ['SQ', '1', 'XRay3DFrameTypeSequence'],
        '0x9506': ['SQ', '1', 'ContributingSourcesSequence'],
        '0x9507': ['SQ', '1', 'XRay3DAcquisitionSequence'],
        '0x9508': ['FL', '1', 'PrimaryPositionerScanArc'],
        '0x9509': ['FL', '1', 'SecondaryPositionerScanArc'],
        '0x9510': ['FL', '1', 'PrimaryPositionerScanStartAngle'],
        '0x9511': ['FL', '1', 'SecondaryPositionerScanStartAngle'],
        '0x9514': ['FL', '1', 'PrimaryPositionerIncrement'],
        '0x9515': ['FL', '1', 'SecondaryPositionerIncrement'],
        '0x9516': ['DT', '1', 'StartAcquisitionDateTime'],
        '0x9517': ['DT', '1', 'EndAcquisitionDateTime'],
        '0x9518': ['SS', '1', 'PrimaryPositionerIncrementSign'],
        '0x9519': ['SS', '1', 'SecondaryPositionerIncrementSign'],
        '0x9524': ['LO', '1', 'ApplicationName'],
        '0x9525': ['LO', '1', 'ApplicationVersion'],
        '0x9526': ['LO', '1', 'ApplicationManufacturer'],
        '0x9527': ['CS', '1', 'AlgorithmType'],
        '0x9528': ['LO', '1', 'AlgorithmDescription'],
        '0x9530': ['SQ', '1', 'XRay3DReconstructionSequence'],
        '0x9531': ['LO', '1', 'ReconstructionDescription'],
        '0x9538': ['SQ', '1', 'PerProjectionAcquisitionSequence'],
        '0x9541': ['SQ', '1', 'DetectorPositionSequence'],
        '0x9542': ['SQ', '1', 'XRayAcquisitionDoseSequence'],
        '0x9543': ['FD', '1', 'XRaySourceIsocenterPrimaryAngle'],
        '0x9544': ['FD', '1', 'XRaySourceIsocenterSecondaryAngle'],
        '0x9545': ['FD', '1', 'BreastSupportIsocenterPrimaryAngle'],
        '0x9546': ['FD', '1', 'BreastSupportIsocenterSecondaryAngle'],
        '0x9547': ['FD', '1', 'BreastSupportXPositionToIsocenter'],
        '0x9548': ['FD', '1', 'BreastSupportYPositionToIsocenter'],
        '0x9549': ['FD', '1', 'BreastSupportZPositionToIsocenter'],
        '0x9550': ['FD', '1', 'DetectorIsocenterPrimaryAngle'],
        '0x9551': ['FD', '1', 'DetectorIsocenterSecondaryAngle'],
        '0x9552': ['FD', '1', 'DetectorXPositionToIsocenter'],
        '0x9553': ['FD', '1', 'DetectorYPositionToIsocenter'],
        '0x9554': ['FD', '1', 'DetectorZPositionToIsocenter'],
        '0x9555': ['SQ', '1', 'XRayGridSequence'],
        '0x9556': ['SQ', '1', 'XRayFilterSequence'],
        '0x9557': ['FD', '3', 'DetectorActiveAreaTLHCPosition'],
        '0x9558': ['FD', '6', 'DetectorActiveAreaOrientation'],
        '0x9559': ['CS', '1', 'PositionerPrimaryAngleDirection'],
        '0x9601': ['SQ', '1', 'DiffusionBMatrixSequence'],
        '0x9602': ['FD', '1', 'DiffusionBValueXX'],
        '0x9603': ['FD', '1', 'DiffusionBValueXY'],
        '0x9604': ['FD', '1', 'DiffusionBValueXZ'],
        '0x9605': ['FD', '1', 'DiffusionBValueYY'],
        '0x9606': ['FD', '1', 'DiffusionBValueYZ'],
        '0x9607': ['FD', '1', 'DiffusionBValueZZ'],
        '0x9701': ['DT', '1', 'DecayCorrectionDateTime'],
        '0x9715': ['FD', '1', 'StartDensityThreshold'],
        '0x9716': ['FD', '1', 'StartRelativeDensityDifferenceThreshold'],
        '0x9717': ['FD', '1', 'StartCardiacTriggerCountThreshold'],
        '0x9718': ['FD', '1', 'StartRespiratoryTriggerCountThreshold'],
        '0x9719': ['FD', '1', 'TerminationCountsThreshold'],
        '0x9720': ['FD', '1', 'TerminationDensityThreshold'],
        '0x9721': ['FD', '1', 'TerminationRelativeDensityThreshold'],
        '0x9722': ['FD', '1', 'TerminationTimeThreshold'],
        '0x9723': ['FD', '1', 'TerminationCardiacTriggerCountThreshold'],
        '0x9724': ['FD', '1', 'TerminationRespiratoryTriggerCountThreshold'],
        '0x9725': ['CS', '1', 'DetectorGeometry'],
        '0x9726': ['FD', '1', 'TransverseDetectorSeparation'],
        '0x9727': ['FD', '1', 'AxialDetectorDimension'],
        '0x9729': ['US', '1', 'RadiopharmaceuticalAgentNumber'],
        '0x9732': ['SQ', '1', 'PETFrameAcquisitionSequence'],
        '0x9733': ['SQ', '1', 'PETDetectorMotionDetailsSequence'],
        '0x9734': ['SQ', '1', 'PETTableDynamicsSequence'],
        '0x9735': ['SQ', '1', 'PETPositionSequence'],
        '0x9736': ['SQ', '1', 'PETFrameCorrectionFactorsSequence'],
        '0x9737': ['SQ', '1', 'RadiopharmaceuticalUsageSequence'],
        '0x9738': ['CS', '1', 'AttenuationCorrectionSource'],
        '0x9739': ['US', '1', 'NumberOfIterations'],
        '0x9740': ['US', '1', 'NumberOfSubsets'],
        '0x9749': ['SQ', '1', 'PETReconstructionSequence'],
        '0x9751': ['SQ', '1', 'PETFrameTypeSequence'],
        '0x9755': ['CS', '1', 'TimeOfFlightInformationUsed'],
        '0x9756': ['CS', '1', 'ReconstructionType'],
        '0x9758': ['CS', '1', 'DecayCorrected'],
        '0x9759': ['CS', '1', 'AttenuationCorrected'],
        '0x9760': ['CS', '1', 'ScatterCorrected'],
        '0x9761': ['CS', '1', 'DeadTimeCorrected'],
        '0x9762': ['CS', '1', 'GantryMotionCorrected'],
        '0x9763': ['CS', '1', 'PatientMotionCorrected'],
        '0x9764': ['CS', '1', 'CountLossNormalizationCorrected'],
        '0x9765': ['CS', '1', 'RandomsCorrected'],
        '0x9766': ['CS', '1', 'NonUniformRadialSamplingCorrected'],
        '0x9767': ['CS', '1', 'SensitivityCalibrated'],
        '0x9768': ['CS', '1', 'DetectorNormalizationCorrection'],
        '0x9769': ['CS', '1', 'IterativeReconstructionMethod'],
        '0x9770': ['CS', '1', 'AttenuationCorrectionTemporalRelationship'],
        '0x9771': ['SQ', '1', 'PatientPhysiologicalStateSequence'],
        '0x9772': ['SQ', '1', 'PatientPhysiologicalStateCodeSequence'],
        '0x9801': ['FD', '1-n', 'DepthsOfFocus'],
        '0x9803': ['SQ', '1', 'ExcludedIntervalsSequence'],
        '0x9804': ['DT', '1', 'ExclusionStartDateTime'],
        '0x9805': ['FD', '1', 'ExclusionDuration'],
        '0x9806': ['SQ', '1', 'USImageDescriptionSequence'],
        '0x9807': ['SQ', '1', 'ImageDataTypeSequence'],
        '0x9808': ['CS', '1', 'DataType'],
        '0x9809': ['SQ', '1', 'TransducerScanPatternCodeSequence'],
        '0x980B': ['CS', '1', 'AliasedDataType'],
        '0x980C': ['CS', '1', 'PositionMeasuringDeviceUsed'],
        '0x980D': ['SQ', '1', 'TransducerGeometryCodeSequence'],
        '0x980E': ['SQ', '1', 'TransducerBeamSteeringCodeSequence'],
        '0x980F': ['SQ', '1', 'TransducerApplicationCodeSequence'],
        '0x9810': ['xs', '1', 'ZeroVelocityPixelValue'],
        '0xA001': ['SQ', '1', 'ContributingEquipmentSequence'],
        '0xA002': ['DT', '1', 'ContributionDateTime'],
        '0xA003': ['ST', '1', 'ContributionDescription'],
    },
    '0x0020': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x000D': ['UI', '1', 'StudyInstanceUID'],
        '0x000E': ['UI', '1', 'SeriesInstanceUID'],
        '0x0010': ['SH', '1', 'StudyID'],
        '0x0011': ['IS', '1', 'SeriesNumber'],
        '0x0012': ['IS', '1', 'AcquisitionNumber'],
        '0x0013': ['IS', '1', 'InstanceNumber'],
        '0x0014': ['IS', '1', 'IsotopeNumber'],
        '0x0015': ['IS', '1', 'PhaseNumber'],
        '0x0016': ['IS', '1', 'IntervalNumber'],
        '0x0017': ['IS', '1', 'TimeSlotNumber'],
        '0x0018': ['IS', '1', 'AngleNumber'],
        '0x0019': ['IS', '1', 'ItemNumber'],
        '0x0020': ['CS', '2', 'PatientOrientation'],
        '0x0022': ['IS', '1', 'OverlayNumber'],
        '0x0024': ['IS', '1', 'CurveNumber'],
        '0x0026': ['IS', '1', 'LUTNumber'],
        '0x0030': ['DS', '3', 'ImagePosition'],
        '0x0032': ['DS', '3', 'ImagePositionPatient'],
        '0x0035': ['DS', '6', 'ImageOrientation'],
        '0x0037': ['DS', '6', 'ImageOrientationPatient'],
        '0x0050': ['DS', '1', 'Location'],
        '0x0052': ['UI', '1', 'FrameOfReferenceUID'],
        '0x0060': ['CS', '1', 'Laterality'],
        '0x0062': ['CS', '1', 'ImageLaterality'],
        '0x0070': ['LO', '1', 'ImageGeometryType'],
        '0x0080': ['CS', '1-n', 'MaskingImage'],
        '0x00AA': ['IS', '1', 'ReportNumber'],
        '0x0100': ['IS', '1', 'TemporalPositionIdentifier'],
        '0x0105': ['IS', '1', 'NumberOfTemporalPositions'],
        '0x0110': ['DS', '1', 'TemporalResolution'],
        '0x0200': ['UI', '1', 'SynchronizationFrameOfReferenceUID'],
        '0x0242': ['UI', '1', 'SOPInstanceUIDOfConcatenationSource'],
        '0x1000': ['IS', '1', 'SeriesInStudy'],
        '0x1001': ['IS', '1', 'AcquisitionsInSeries'],
        '0x1002': ['IS', '1', 'ImagesInAcquisition'],
        '0x1003': ['IS', '1', 'ImagesInSeries'],
        '0x1004': ['IS', '1', 'AcquisitionsInStudy'],
        '0x1005': ['IS', '1', 'ImagesInStudy'],
        '0x1020': ['LO', '1-n', 'Reference'],
        '0x1040': ['LO', '1', 'PositionReferenceIndicator'],
        '0x1041': ['DS', '1', 'SliceLocation'],
        '0x1070': ['IS', '1-n', 'OtherStudyNumbers'],
        '0x1200': ['IS', '1', 'NumberOfPatientRelatedStudies'],
        '0x1202': ['IS', '1', 'NumberOfPatientRelatedSeries'],
        '0x1204': ['IS', '1', 'NumberOfPatientRelatedInstances'],
        '0x1206': ['IS', '1', 'NumberOfStudyRelatedSeries'],
        '0x1208': ['IS', '1', 'NumberOfStudyRelatedInstances'],
        '0x1209': ['IS', '1', 'NumberOfSeriesRelatedInstances'],
        '0x3100': ['CS', '1-n', 'SourceImageIDs'],
        '0x3401': ['CS', '1', 'ModifyingDeviceID'],
        '0x3402': ['CS', '1', 'ModifiedImageID'],
        '0x3403': ['DA', '1', 'ModifiedImageDate'],
        '0x3404': ['LO', '1', 'ModifyingDeviceManufacturer'],
        '0x3405': ['TM', '1', 'ModifiedImageTime'],
        '0x3406': ['LO', '1', 'ModifiedImageDescription'],
        '0x4000': ['LT', '1', 'ImageComments'],
        '0x5000': ['AT', '1-n', 'OriginalImageIdentification'],
        '0x5002': ['LO', '1-n', 'OriginalImageIdentificationNomenclature'],
        '0x9056': ['SH', '1', 'StackID'],
        '0x9057': ['UL', '1', 'InStackPositionNumber'],
        '0x9071': ['SQ', '1', 'FrameAnatomySequence'],
        '0x9072': ['CS', '1', 'FrameLaterality'],
        '0x9111': ['SQ', '1', 'FrameContentSequence'],
        '0x9113': ['SQ', '1', 'PlanePositionSequence'],
        '0x9116': ['SQ', '1', 'PlaneOrientationSequence'],
        '0x9128': ['UL', '1', 'TemporalPositionIndex'],
        '0x9153': ['FD', '1', 'NominalCardiacTriggerDelayTime'],
        '0x9154': ['FL', '1', 'NominalCardiacTriggerTimePriorToRPeak'],
        '0x9155': ['FL', '1', 'ActualCardiacTriggerTimePriorToRPeak'],
        '0x9156': ['US', '1', 'FrameAcquisitionNumber'],
        '0x9157': ['UL', '1-n', 'DimensionIndexValues'],
        '0x9158': ['LT', '1', 'FrameComments'],
        '0x9161': ['UI', '1', 'ConcatenationUID'],
        '0x9162': ['US', '1', 'InConcatenationNumber'],
        '0x9163': ['US', '1', 'InConcatenationTotalNumber'],
        '0x9164': ['UI', '1', 'DimensionOrganizationUID'],
        '0x9165': ['AT', '1', 'DimensionIndexPointer'],
        '0x9167': ['AT', '1', 'FunctionalGroupPointer'],
        '0x9170': ['SQ', '1', 'UnassignedSharedConvertedAttributesSequence'],
        '0x9171': ['SQ', '1', 'UnassignedPerFrameConvertedAttributesSequence'],
        '0x9172': ['SQ', '1', 'ConversionSourceAttributesSequence'],
        '0x9213': ['LO', '1', 'DimensionIndexPrivateCreator'],
        '0x9221': ['SQ', '1', 'DimensionOrganizationSequence'],
        '0x9222': ['SQ', '1', 'DimensionIndexSequence'],
        '0x9228': ['UL', '1', 'ConcatenationFrameOffsetNumber'],
        '0x9238': ['LO', '1', 'FunctionalGroupPrivateCreator'],
        '0x9241': ['FL', '1', 'NominalPercentageOfCardiacPhase'],
        '0x9245': ['FL', '1', 'NominalPercentageOfRespiratoryPhase'],
        '0x9246': ['FL', '1', 'StartingRespiratoryAmplitude'],
        '0x9247': ['CS', '1', 'StartingRespiratoryPhase'],
        '0x9248': ['FL', '1', 'EndingRespiratoryAmplitude'],
        '0x9249': ['CS', '1', 'EndingRespiratoryPhase'],
        '0x9250': ['CS', '1', 'RespiratoryTriggerType'],
        '0x9251': ['FD', '1', 'RRIntervalTimeNominal'],
        '0x9252': ['FD', '1', 'ActualCardiacTriggerDelayTime'],
        '0x9253': ['SQ', '1', 'RespiratorySynchronizationSequence'],
        '0x9254': ['FD', '1', 'RespiratoryIntervalTime'],
        '0x9255': ['FD', '1', 'NominalRespiratoryTriggerDelayTime'],
        '0x9256': ['FD', '1', 'RespiratoryTriggerDelayThreshold'],
        '0x9257': ['FD', '1', 'ActualRespiratoryTriggerDelayTime'],
        '0x9301': ['FD', '3', 'ImagePositionVolume'],
        '0x9302': ['FD', '6', 'ImageOrientationVolume'],
        '0x9307': ['CS', '1', 'UltrasoundAcquisitionGeometry'],
        '0x9308': ['FD', '3', 'ApexPosition'],
        '0x9309': ['FD', '16', 'VolumeToTransducerMappingMatrix'],
        '0x930A': ['FD', '16', 'VolumeToTableMappingMatrix'],
        '0x930B': ['CS', '1', 'VolumeToTransducerRelationship'],
        '0x930C': ['CS', '1', 'PatientFrameOfReferenceSource'],
        '0x930D': ['FD', '1', 'TemporalPositionTimeOffset'],
        '0x930E': ['SQ', '1', 'PlanePositionVolumeSequence'],
        '0x930F': ['SQ', '1', 'PlaneOrientationVolumeSequence'],
        '0x9310': ['SQ', '1', 'TemporalPositionSequence'],
        '0x9311': ['CS', '1', 'DimensionOrganizationType'],
        '0x9312': ['UI', '1', 'VolumeFrameOfReferenceUID'],
        '0x9313': ['UI', '1', 'TableFrameOfReferenceUID'],
        '0x9421': ['LO', '1', 'DimensionDescriptionLabel'],
        '0x9450': ['SQ', '1', 'PatientOrientationInFrameSequence'],
        '0x9453': ['LO', '1', 'FrameLabel'],
        '0x9518': ['US', '1-n', 'AcquisitionIndex'],
        '0x9529': ['SQ', '1', 'ContributingSOPInstancesReferenceSequence'],
        '0x9536': ['US', '1', 'ReconstructionIndex'],
    },
    '0x0022': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['US', '1', 'LightPathFilterPassThroughWavelength'],
        '0x0002': ['US', '2', 'LightPathFilterPassBand'],
        '0x0003': ['US', '1', 'ImagePathFilterPassThroughWavelength'],
        '0x0004': ['US', '2', 'ImagePathFilterPassBand'],
        '0x0005': ['CS', '1', 'PatientEyeMovementCommanded'],
        '0x0006': ['SQ', '1', 'PatientEyeMovementCommandCodeSequence'],
        '0x0007': ['FL', '1', 'SphericalLensPower'],
        '0x0008': ['FL', '1', 'CylinderLensPower'],
        '0x0009': ['FL', '1', 'CylinderAxis'],
        '0x000A': ['FL', '1', 'EmmetropicMagnification'],
        '0x000B': ['FL', '1', 'IntraOcularPressure'],
        '0x000C': ['FL', '1', 'HorizontalFieldOfView'],
        '0x000D': ['CS', '1', 'PupilDilated'],
        '0x000E': ['FL', '1', 'DegreeOfDilation'],
        '0x0010': ['FL', '1', 'StereoBaselineAngle'],
        '0x0011': ['FL', '1', 'StereoBaselineDisplacement'],
        '0x0012': ['FL', '1', 'StereoHorizontalPixelOffset'],
        '0x0013': ['FL', '1', 'StereoVerticalPixelOffset'],
        '0x0014': ['FL', '1', 'StereoRotation'],
        '0x0015': ['SQ', '1', 'AcquisitionDeviceTypeCodeSequence'],
        '0x0016': ['SQ', '1', 'IlluminationTypeCodeSequence'],
        '0x0017': ['SQ', '1', 'LightPathFilterTypeStackCodeSequence'],
        '0x0018': ['SQ', '1', 'ImagePathFilterTypeStackCodeSequence'],
        '0x0019': ['SQ', '1', 'LensesCodeSequence'],
        '0x001A': ['SQ', '1', 'ChannelDescriptionCodeSequence'],
        '0x001B': ['SQ', '1', 'RefractiveStateSequence'],
        '0x001C': ['SQ', '1', 'MydriaticAgentCodeSequence'],
        '0x001D': ['SQ', '1', 'RelativeImagePositionCodeSequence'],
        '0x001E': ['FL', '1', 'CameraAngleOfView'],
        '0x0020': ['SQ', '1', 'StereoPairsSequence'],
        '0x0021': ['SQ', '1', 'LeftImageSequence'],
        '0x0022': ['SQ', '1', 'RightImageSequence'],
        '0x0028': ['CS', '1', 'StereoPairsPresent'],
        '0x0030': ['FL', '1', 'AxialLengthOfTheEye'],
        '0x0031': ['SQ', '1', 'OphthalmicFrameLocationSequence'],
        '0x0032': ['FL', '2-2n', 'ReferenceCoordinates'],
        '0x0035': ['FL', '1', 'DepthSpatialResolution'],
        '0x0036': ['FL', '1', 'MaximumDepthDistortion'],
        '0x0037': ['FL', '1', 'AlongScanSpatialResolution'],
        '0x0038': ['FL', '1', 'MaximumAlongScanDistortion'],
        '0x0039': ['CS', '1', 'OphthalmicImageOrientation'],
        '0x0041': ['FL', '1', 'DepthOfTransverseImage'],
        '0x0042': ['SQ', '1', 'MydriaticAgentConcentrationUnitsSequence'],
        '0x0048': ['FL', '1', 'AcrossScanSpatialResolution'],
        '0x0049': ['FL', '1', 'MaximumAcrossScanDistortion'],
        '0x004E': ['DS', '1', 'MydriaticAgentConcentration'],
        '0x0055': ['FL', '1', 'IlluminationWaveLength'],
        '0x0056': ['FL', '1', 'IlluminationPower'],
        '0x0057': ['FL', '1', 'IlluminationBandwidth'],
        '0x0058': ['SQ', '1', 'MydriaticAgentSequence'],
        '0x1007': ['SQ', '1', 'OphthalmicAxialMeasurementsRightEyeSequence'],
        '0x1008': ['SQ', '1', 'OphthalmicAxialMeasurementsLeftEyeSequence'],
        '0x1009': ['CS', '1', 'OphthalmicAxialMeasurementsDeviceType'],
        '0x1010': ['CS', '1', 'OphthalmicAxialLengthMeasurementsType'],
        '0x1012': ['SQ', '1', 'OphthalmicAxialLengthSequence'],
        '0x1019': ['FL', '1', 'OphthalmicAxialLength'],
        '0x1024': ['SQ', '1', 'LensStatusCodeSequence'],
        '0x1025': ['SQ', '1', 'VitreousStatusCodeSequence'],
        '0x1028': ['SQ', '1', 'IOLFormulaCodeSequence'],
        '0x1029': ['LO', '1', 'IOLFormulaDetail'],
        '0x1033': ['FL', '1', 'KeratometerIndex'],
        '0x1035': ['SQ', '1', 'SourceOfOphthalmicAxialLengthCodeSequence'],
        '0x1037': ['FL', '1', 'TargetRefraction'],
        '0x1039': ['CS', '1', 'RefractiveProcedureOccurred'],
        '0x1040': ['SQ', '1', 'RefractiveSurgeryTypeCodeSequence'],
        '0x1044': ['SQ', '1', 'OphthalmicUltrasoundMethodCodeSequence'],
        '0x1050': ['SQ', '1', 'OphthalmicAxialLengthMeasurementsSequence'],
        '0x1053': ['FL', '1', 'IOLPower'],
        '0x1054': ['FL', '1', 'PredictedRefractiveError'],
        '0x1059': ['FL', '1', 'OphthalmicAxialLengthVelocity'],
        '0x1065': ['LO', '1', 'LensStatusDescription'],
        '0x1066': ['LO', '1', 'VitreousStatusDescription'],
        '0x1090': ['SQ', '1', 'IOLPowerSequence'],
        '0x1092': ['SQ', '1', 'LensConstantSequence'],
        '0x1093': ['LO', '1', 'IOLManufacturer'],
        '0x1094': ['LO', '1', 'LensConstantDescription'],
        '0x1095': ['LO', '1', 'ImplantName'],
        '0x1096': ['SQ', '1', 'KeratometryMeasurementTypeCodeSequence'],
        '0x1097': ['LO', '1', 'ImplantPartNumber'],
        '0x1100': ['SQ', '1', 'ReferencedOphthalmicAxialMeasurementsSequence'],
        '0x1101': ['SQ', '1', 'OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence'],
        '0x1103': ['SQ', '1', 'RefractiveErrorBeforeRefractiveSurgeryCodeSequence'],
        '0x1121': ['FL', '1', 'IOLPowerForExactEmmetropia'],
        '0x1122': ['FL', '1', 'IOLPowerForExactTargetRefraction'],
        '0x1125': ['SQ', '1', 'AnteriorChamberDepthDefinitionCodeSequence'],
        '0x1127': ['SQ', '1', 'LensThicknessSequence'],
        '0x1128': ['SQ', '1', 'AnteriorChamberDepthSequence'],
        '0x1130': ['FL', '1', 'LensThickness'],
        '0x1131': ['FL', '1', 'AnteriorChamberDepth'],
        '0x1132': ['SQ', '1', 'SourceOfLensThicknessDataCodeSequence'],
        '0x1133': ['SQ', '1', 'SourceOfAnteriorChamberDepthDataCodeSequence'],
        '0x1134': ['SQ', '1', 'SourceOfRefractiveMeasurementsSequence'],
        '0x1135': ['SQ', '1', 'SourceOfRefractiveMeasurementsCodeSequence'],
        '0x1140': ['CS', '1', 'OphthalmicAxialLengthMeasurementModified'],
        '0x1150': ['SQ', '1', 'OphthalmicAxialLengthDataSourceCodeSequence'],
        '0x1153': ['SQ', '1', 'OphthalmicAxialLengthAcquisitionMethodCodeSequence'],
        '0x1155': ['FL', '1', 'SignalToNoiseRatio'],
        '0x1159': ['LO', '1', 'OphthalmicAxialLengthDataSourceDescription'],
        '0x1210': ['SQ', '1', 'OphthalmicAxialLengthMeasurementsTotalLengthSequence'],
        '0x1211': ['SQ', '1', 'OphthalmicAxialLengthMeasurementsSegmentalLengthSequence'],
        '0x1212': ['SQ', '1', 'OphthalmicAxialLengthMeasurementsLengthSummationSequence'],
        '0x1220': ['SQ', '1', 'UltrasoundOphthalmicAxialLengthMeasurementsSequence'],
        '0x1225': ['SQ', '1', 'OpticalOphthalmicAxialLengthMeasurementsSequence'],
        '0x1230': ['SQ', '1', 'UltrasoundSelectedOphthalmicAxialLengthSequence'],
        '0x1250': ['SQ', '1', 'OphthalmicAxialLengthSelectionMethodCodeSequence'],
        '0x1255': ['SQ', '1', 'OpticalSelectedOphthalmicAxialLengthSequence'],
        '0x1257': ['SQ', '1', 'SelectedSegmentalOphthalmicAxialLengthSequence'],
        '0x1260': ['SQ', '1', 'SelectedTotalOphthalmicAxialLengthSequence'],
        '0x1262': ['SQ', '1', 'OphthalmicAxialLengthQualityMetricSequence'],
        '0x1265': ['SQ', '1', 'OphthalmicAxialLengthQualityMetricTypeCodeSequence'],
        '0x1273': ['LO', '1', 'OphthalmicAxialLengthQualityMetricTypeDescription'],
        '0x1300': ['SQ', '1', 'IntraocularLensCalculationsRightEyeSequence'],
        '0x1310': ['SQ', '1', 'IntraocularLensCalculationsLeftEyeSequence'],
        '0x1330': ['SQ', '1', 'ReferencedOphthalmicAxialLengthMeasurementQCImageSequence'],
        '0x1415': ['CS', '1', 'OphthalmicMappingDeviceType'],
        '0x1420': ['SQ', '1', 'AcquisitionMethodCodeSequence'],
        '0x1423': ['SQ', '1', 'AcquisitionMethodAlgorithmSequence'],
        '0x1436': ['SQ', '1', 'OphthalmicThicknessMapTypeCodeSequence'],
        '0x1443': ['SQ', '1', 'OphthalmicThicknessMappingNormalsSequence'],
        '0x1445': ['SQ', '1', 'RetinalThicknessDefinitionCodeSequence'],
        '0x1450': ['SQ', '1', 'PixelValueMappingToCodedConceptSequence'],
        '0x1452': ['xs', '1', 'MappedPixelValue'],
        '0x1454': ['LO', '1', 'PixelValueMappingExplanation'],
        '0x1458': ['SQ', '1', 'OphthalmicThicknessMapQualityThresholdSequence'],
        '0x1460': ['FL', '1', 'OphthalmicThicknessMapThresholdQualityRating'],
        '0x1463': ['FL', '2', 'AnatomicStructureReferencePoint'],
        '0x1465': ['SQ', '1', 'RegistrationToLocalizerSequence'],
        '0x1466': ['CS', '1', 'RegisteredLocalizerUnits'],
        '0x1467': ['FL', '2', 'RegisteredLocalizerTopLeftHandCorner'],
        '0x1468': ['FL', '2', 'RegisteredLocalizerBottomRightHandCorner'],
        '0x1470': ['SQ', '1', 'OphthalmicThicknessMapQualityRatingSequence'],
        '0x1472': ['SQ', '1', 'RelevantOPTAttributesSequence'],
        '0x1512': ['SQ', '1', 'TransformationMethodCodeSequence'],
        '0x1513': ['SQ', '1', 'TransformationAlgorithmSequence'],
        '0x1515': ['CS', '1', 'OphthalmicAxialLengthMethod'],
        '0x1517': ['FL', '1', 'OphthalmicFOV'],
        '0x1518': ['SQ', '1', 'TwoDimensionalToThreeDimensionalMapSequence'],
        '0x1525': ['SQ', '1', 'WideFieldOphthalmicPhotographyQualityRatingSequence'],
        '0x1526': ['SQ', '1', 'WideFieldOphthalmicPhotographyQualityThresholdSequence'],
        '0x1527': ['FL', '1', 'WideFieldOphthalmicPhotographyThresholdQualityRating'],
        '0x1528': ['FL', '1', 'XCoordinatesCenterPixelViewAngle'],
        '0x1529': ['FL', '1', 'YCoordinatesCenterPixelViewAngle'],
        '0x1530': ['UL', '1', 'NumberOfMapPoints'],
        '0x1531': ['OF', '1', 'TwoDimensionalToThreeDimensionalMapData'],
    },
    '0x0024': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['FL', '1', 'VisualFieldHorizontalExtent'],
        '0x0011': ['FL', '1', 'VisualFieldVerticalExtent'],
        '0x0012': ['CS', '1', 'VisualFieldShape'],
        '0x0016': ['SQ', '1', 'ScreeningTestModeCodeSequence'],
        '0x0018': ['FL', '1', 'MaximumStimulusLuminance'],
        '0x0020': ['FL', '1', 'BackgroundLuminance'],
        '0x0021': ['SQ', '1', 'StimulusColorCodeSequence'],
        '0x0024': ['SQ', '1', 'BackgroundIlluminationColorCodeSequence'],
        '0x0025': ['FL', '1', 'StimulusArea'],
        '0x0028': ['FL', '1', 'StimulusPresentationTime'],
        '0x0032': ['SQ', '1', 'FixationSequence'],
        '0x0033': ['SQ', '1', 'FixationMonitoringCodeSequence'],
        '0x0034': ['SQ', '1', 'VisualFieldCatchTrialSequence'],
        '0x0035': ['US', '1', 'FixationCheckedQuantity'],
        '0x0036': ['US', '1', 'PatientNotProperlyFixatedQuantity'],
        '0x0037': ['CS', '1', 'PresentedVisualStimuliDataFlag'],
        '0x0038': ['US', '1', 'NumberOfVisualStimuli'],
        '0x0039': ['CS', '1', 'ExcessiveFixationLossesDataFlag'],
        '0x0040': ['CS', '1', 'ExcessiveFixationLosses'],
        '0x0042': ['US', '1', 'StimuliRetestingQuantity'],
        '0x0044': ['LT', '1', 'CommentsOnPatientPerformanceOfVisualField'],
        '0x0045': ['CS', '1', 'FalseNegativesEstimateFlag'],
        '0x0046': ['FL', '1', 'FalseNegativesEstimate'],
        '0x0048': ['US', '1', 'NegativeCatchTrialsQuantity'],
        '0x0050': ['US', '1', 'FalseNegativesQuantity'],
        '0x0051': ['CS', '1', 'ExcessiveFalseNegativesDataFlag'],
        '0x0052': ['CS', '1', 'ExcessiveFalseNegatives'],
        '0x0053': ['CS', '1', 'FalsePositivesEstimateFlag'],
        '0x0054': ['FL', '1', 'FalsePositivesEstimate'],
        '0x0055': ['CS', '1', 'CatchTrialsDataFlag'],
        '0x0056': ['US', '1', 'PositiveCatchTrialsQuantity'],
        '0x0057': ['CS', '1', 'TestPointNormalsDataFlag'],
        '0x0058': ['SQ', '1', 'TestPointNormalsSequence'],
        '0x0059': ['CS', '1', 'GlobalDeviationProbabilityNormalsFlag'],
        '0x0060': ['US', '1', 'FalsePositivesQuantity'],
        '0x0061': ['CS', '1', 'ExcessiveFalsePositivesDataFlag'],
        '0x0062': ['CS', '1', 'ExcessiveFalsePositives'],
        '0x0063': ['CS', '1', 'VisualFieldTestNormalsFlag'],
        '0x0064': ['SQ', '1', 'ResultsNormalsSequence'],
        '0x0065': ['SQ', '1', 'AgeCorrectedSensitivityDeviationAlgorithmSequence'],
        '0x0066': ['FL', '1', 'GlobalDeviationFromNormal'],
        '0x0067': ['SQ', '1', 'GeneralizedDefectSensitivityDeviationAlgorithmSequence'],
        '0x0068': ['FL', '1', 'LocalizedDeviationFromNormal'],
        '0x0069': ['LO', '1', 'PatientReliabilityIndicator'],
        '0x0070': ['FL', '1', 'VisualFieldMeanSensitivity'],
        '0x0071': ['FL', '1', 'GlobalDeviationProbability'],
        '0x0072': ['CS', '1', 'LocalDeviationProbabilityNormalsFlag'],
        '0x0073': ['FL', '1', 'LocalizedDeviationProbability'],
        '0x0074': ['CS', '1', 'ShortTermFluctuationCalculated'],
        '0x0075': ['FL', '1', 'ShortTermFluctuation'],
        '0x0076': ['CS', '1', 'ShortTermFluctuationProbabilityCalculated'],
        '0x0077': ['FL', '1', 'ShortTermFluctuationProbability'],
        '0x0078': ['CS', '1', 'CorrectedLocalizedDeviationFromNormalCalculated'],
        '0x0079': ['FL', '1', 'CorrectedLocalizedDeviationFromNormal'],
        '0x0080': ['CS', '1', 'CorrectedLocalizedDeviationFromNormalProbabilityCalculated'],
        '0x0081': ['FL', '1', 'CorrectedLocalizedDeviationFromNormalProbability'],
        '0x0083': ['SQ', '1', 'GlobalDeviationProbabilitySequence'],
        '0x0085': ['SQ', '1', 'LocalizedDeviationProbabilitySequence'],
        '0x0086': ['CS', '1', 'FovealSensitivityMeasured'],
        '0x0087': ['FL', '1', 'FovealSensitivity'],
        '0x0088': ['FL', '1', 'VisualFieldTestDuration'],
        '0x0089': ['SQ', '1', 'VisualFieldTestPointSequence'],
        '0x0090': ['FL', '1', 'VisualFieldTestPointXCoordinate'],
        '0x0091': ['FL', '1', 'VisualFieldTestPointYCoordinate'],
        '0x0092': ['FL', '1', 'AgeCorrectedSensitivityDeviationValue'],
        '0x0093': ['CS', '1', 'StimulusResults'],
        '0x0094': ['FL', '1', 'SensitivityValue'],
        '0x0095': ['CS', '1', 'RetestStimulusSeen'],
        '0x0096': ['FL', '1', 'RetestSensitivityValue'],
        '0x0097': ['SQ', '1', 'VisualFieldTestPointNormalsSequence'],
        '0x0098': ['FL', '1', 'QuantifiedDefect'],
        '0x0100': ['FL', '1', 'AgeCorrectedSensitivityDeviationProbabilityValue'],
        '0x0102': ['CS', '1', 'GeneralizedDefectCorrectedSensitivityDeviationFlag'],
        '0x0103': ['FL', '1', 'GeneralizedDefectCorrectedSensitivityDeviationValue'],
        '0x0104': ['FL', '1', 'GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue'],
        '0x0105': ['FL', '1', 'MinimumSensitivityValue'],
        '0x0106': ['CS', '1', 'BlindSpotLocalized'],
        '0x0107': ['FL', '1', 'BlindSpotXCoordinate'],
        '0x0108': ['FL', '1', 'BlindSpotYCoordinate'],
        '0x0110': ['SQ', '1', 'VisualAcuityMeasurementSequence'],
        '0x0112': ['SQ', '1', 'RefractiveParametersUsedOnPatientSequence'],
        '0x0113': ['CS', '1', 'MeasurementLaterality'],
        '0x0114': ['SQ', '1', 'OphthalmicPatientClinicalInformationLeftEyeSequence'],
        '0x0115': ['SQ', '1', 'OphthalmicPatientClinicalInformationRightEyeSequence'],
        '0x0117': ['CS', '1', 'FovealPointNormativeDataFlag'],
        '0x0118': ['FL', '1', 'FovealPointProbabilityValue'],
        '0x0120': ['CS', '1', 'ScreeningBaselineMeasured'],
        '0x0122': ['SQ', '1', 'ScreeningBaselineMeasuredSequence'],
        '0x0124': ['CS', '1', 'ScreeningBaselineType'],
        '0x0126': ['FL', '1', 'ScreeningBaselineValue'],
        '0x0202': ['LO', '1', 'AlgorithmSource'],
        '0x0306': ['LO', '1', 'DataSetName'],
        '0x0307': ['LO', '1', 'DataSetVersion'],
        '0x0308': ['LO', '1', 'DataSetSource'],
        '0x0309': ['LO', '1', 'DataSetDescription'],
        '0x0317': ['SQ', '1', 'VisualFieldTestReliabilityGlobalIndexSequence'],
        '0x0320': ['SQ', '1', 'VisualFieldGlobalResultsIndexSequence'],
        '0x0325': ['SQ', '1', 'DataObservationSequence'],
        '0x0338': ['CS', '1', 'IndexNormalsFlag'],
        '0x0341': ['FL', '1', 'IndexProbability'],
        '0x0344': ['SQ', '1', 'IndexProbabilitySequence'],
    },
    '0x0028': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['US', '1', 'SamplesPerPixel'],
        '0x0003': ['US', '1', 'SamplesPerPixelUsed'],
        '0x0004': ['CS', '1', 'PhotometricInterpretation'],
        '0x0005': ['US', '1', 'ImageDimensions'],
        '0x0006': ['US', '1', 'PlanarConfiguration'],
        '0x0008': ['IS', '1', 'NumberOfFrames'],
        '0x0009': ['AT', '1-n', 'FrameIncrementPointer'],
        '0x000A': ['AT', '1-n', 'FrameDimensionPointer'],
        '0x0010': ['US', '1', 'Rows'],
        '0x0011': ['US', '1', 'Columns'],
        '0x0012': ['US', '1', 'Planes'],
        '0x0014': ['US', '1', 'UltrasoundColorDataPresent'],
        '0x0020': ['', '', ''],
        '0x0030': ['DS', '2', 'PixelSpacing'],
        '0x0031': ['DS', '2', 'ZoomFactor'],
        '0x0032': ['DS', '2', 'ZoomCenter'],
        '0x0034': ['IS', '2', 'PixelAspectRatio'],
        '0x0040': ['CS', '1', 'ImageFormat'],
        '0x0050': ['LO', '1-n', 'ManipulatedImage'],
        '0x0051': ['CS', '1-n', 'CorrectedImage'],
        '0x005F': ['LO', '1', 'CompressionRecognitionCode'],
        '0x0060': ['CS', '1', 'CompressionCode'],
        '0x0061': ['SH', '1', 'CompressionOriginator'],
        '0x0062': ['LO', '1', 'CompressionLabel'],
        '0x0063': ['SH', '1', 'CompressionDescription'],
        '0x0065': ['CS', '1-n', 'CompressionSequence'],
        '0x0066': ['AT', '1-n', 'CompressionStepPointers'],
        '0x0068': ['US', '1', 'RepeatInterval'],
        '0x0069': ['US', '1', 'BitsGrouped'],
        '0x0070': ['US', '1-n', 'PerimeterTable'],
        '0x0071': ['xs', '1', 'PerimeterValue'],
        '0x0080': ['US', '1', 'PredictorRows'],
        '0x0081': ['US', '1', 'PredictorColumns'],
        '0x0082': ['US', '1-n', 'PredictorConstants'],
        '0x0090': ['CS', '1', 'BlockedPixels'],
        '0x0091': ['US', '1', 'BlockRows'],
        '0x0092': ['US', '1', 'BlockColumns'],
        '0x0093': ['US', '1', 'RowOverlap'],
        '0x0094': ['US', '1', 'ColumnOverlap'],
        '0x0100': ['US', '1', 'BitsAllocated'],
        '0x0101': ['US', '1', 'BitsStored'],
        '0x0102': ['US', '1', 'HighBit'],
        '0x0103': ['US', '1', 'PixelRepresentation'],
        '0x0104': ['xs', '1', 'SmallestValidPixelValue'],
        '0x0105': ['xs', '1', 'LargestValidPixelValue'],
        '0x0106': ['xs', '1', 'SmallestImagePixelValue'],
        '0x0107': ['xs', '1', 'LargestImagePixelValue'],
        '0x0108': ['xs', '1', 'SmallestPixelValueInSeries'],
        '0x0109': ['xs', '1', 'LargestPixelValueInSeries'],
        '0x0110': ['xs', '1', 'SmallestImagePixelValueInPlane'],
        '0x0111': ['xs', '1', 'LargestImagePixelValueInPlane'],
        '0x0120': ['xs', '1', 'PixelPaddingValue'],
        '0x0121': ['xs', '1', 'PixelPaddingRangeLimit'],
        '0x0122': ['FL', '1', 'FloatPixelPaddingValue'],
        '0x0123': ['FD', '1', 'DoubleFloatPixelPaddingValue'],
        '0x0124': ['FL', '1', 'FloatPixelPaddingRangeLimit'],
        '0x0125': ['FD', '1', 'DoubleFloatPixelPaddingRangeLimit'],
        '0x0200': ['US', '1', 'ImageLocation'],
        '0x0300': ['CS', '1', 'QualityControlImage'],
        '0x0301': ['CS', '1', 'BurnedInAnnotation'],
        '0x0302': ['CS', '1', 'RecognizableVisualFeatures'],
        '0x0303': ['CS', '1', 'LongitudinalTemporalInformationModified'],
        '0x0304': ['UI', '1', 'ReferencedColorPaletteInstanceUID'],
        '0x0400': ['LO', '1', 'TransformLabel'],
        '0x0401': ['LO', '1', 'TransformVersionNumber'],
        '0x0402': ['US', '1', 'NumberOfTransformSteps'],
        '0x0403': ['LO', '1-n', 'SequenceOfCompressedData'],
        '0x0404': ['AT', '1-n', 'DetailsOfCoefficients'],
        '0x04x0': ['US', '1', 'RowsForNthOrderCoefficients'],
        '0x04x1': ['US', '1', 'ColumnsForNthOrderCoefficients'],
        '0x04x2': ['LO', '1-n', 'CoefficientCoding'],
        '0x04x3': ['AT', '1-n', 'CoefficientCodingPointers'],
        '0x0700': ['LO', '1', 'DCTLabel'],
        '0x0701': ['CS', '1-n', 'DataBlockDescription'],
        '0x0702': ['AT', '1-n', 'DataBlock'],
        '0x0710': ['US', '1', 'NormalizationFactorFormat'],
        '0x0720': ['US', '1', 'ZonalMapNumberFormat'],
        '0x0721': ['AT', '1-n', 'ZonalMapLocation'],
        '0x0722': ['US', '1', 'ZonalMapFormat'],
        '0x0730': ['US', '1', 'AdaptiveMapFormat'],
        '0x0740': ['US', '1', 'CodeNumberFormat'],
        '0x08x0': ['CS', '1-n', 'CodeLabel'],
        '0x08x2': ['US', '1', 'NumberOfTables'],
        '0x08x3': ['AT', '1-n', 'CodeTableLocation'],
        '0x08x4': ['US', '1', 'BitsForCodeWord'],
        '0x08x8': ['AT', '1-n', 'ImageDataLocation'],
        '0x0A02': ['CS', '1', 'PixelSpacingCalibrationType'],
        '0x0A04': ['LO', '1', 'PixelSpacingCalibrationDescription'],
        '0x1040': ['CS', '1', 'PixelIntensityRelationship'],
        '0x1041': ['SS', '1', 'PixelIntensityRelationshipSign'],
        '0x1050': ['DS', '1-n', 'WindowCenter'],
        '0x1051': ['DS', '1-n', 'WindowWidth'],
        '0x1052': ['DS', '1', 'RescaleIntercept'],
        '0x1053': ['DS', '1', 'RescaleSlope'],
        '0x1054': ['LO', '1', 'RescaleType'],
        '0x1055': ['LO', '1-n', 'WindowCenterWidthExplanation'],
        '0x1056': ['CS', '1', 'VOILUTFunction'],
        '0x1080': ['CS', '1', 'GrayScale'],
        '0x1090': ['CS', '1', 'RecommendedViewingMode'],
        '0x1100': ['xs', '3', 'GrayLookupTableDescriptor'],
        '0x1101': ['xs', '3', 'RedPaletteColorLookupTableDescriptor'],
        '0x1102': ['xs', '3', 'GreenPaletteColorLookupTableDescriptor'],
        '0x1103': ['xs', '3', 'BluePaletteColorLookupTableDescriptor'],
        '0x1104': ['US', '3', 'AlphaPaletteColorLookupTableDescriptor'],
        '0x1111': ['xs', '4', 'LargeRedPaletteColorLookupTableDescriptor'],
        '0x1112': ['xs', '4', 'LargeGreenPaletteColorLookupTableDescriptor'],
        '0x1113': ['xs', '4', 'LargeBluePaletteColorLookupTableDescriptor'],
        '0x1199': ['UI', '1', 'PaletteColorLookupTableUID'],
        '0x1200': ['US or SS or OW', '1-n or 1', 'GrayLookupTableData'],
        '0x1201': ['OW', '1', 'RedPaletteColorLookupTableData'],
        '0x1202': ['OW', '1', 'GreenPaletteColorLookupTableData'],
        '0x1203': ['OW', '1', 'BluePaletteColorLookupTableData'],
        '0x1204': ['OW', '1', 'AlphaPaletteColorLookupTableData'],
        '0x1211': ['OW', '1', 'LargeRedPaletteColorLookupTableData'],
        '0x1212': ['OW', '1', 'LargeGreenPaletteColorLookupTableData'],
        '0x1213': ['OW', '1', 'LargeBluePaletteColorLookupTableData'],
        '0x1214': ['UI', '1', 'LargePaletteColorLookupTableUID'],
        '0x1221': ['OW', '1', 'SegmentedRedPaletteColorLookupTableData'],
        '0x1222': ['OW', '1', 'SegmentedGreenPaletteColorLookupTableData'],
        '0x1223': ['OW', '1', 'SegmentedBluePaletteColorLookupTableData'],
        '0x1300': ['CS', '1', 'BreastImplantPresent'],
        '0x1350': ['CS', '1', 'PartialView'],
        '0x1351': ['ST', '1', 'PartialViewDescription'],
        '0x1352': ['SQ', '1', 'PartialViewCodeSequence'],
        '0x135A': ['CS', '1', 'SpatialLocationsPreserved'],
        '0x1401': ['SQ', '1', 'DataFrameAssignmentSequence'],
        '0x1402': ['CS', '1', 'DataPathAssignment'],
        '0x1403': ['US', '1', 'BitsMappedToColorLookupTable'],
        '0x1404': ['SQ', '1', 'BlendingLUT1Sequence'],
        '0x1405': ['CS', '1', 'BlendingLUT1TransferFunction'],
        '0x1406': ['FD', '1', 'BlendingWeightConstant'],
        '0x1407': ['US', '3', 'BlendingLookupTableDescriptor'],
        '0x1408': ['OW', '1', 'BlendingLookupTableData'],
        '0x140B': ['SQ', '1', 'EnhancedPaletteColorLookupTableSequence'],
        '0x140C': ['SQ', '1', 'BlendingLUT2Sequence'],
        '0x140D': ['CS', '1', 'BlendingLUT2TransferFunction'],
        '0x140E': ['CS', '1', 'DataPathID'],
        '0x140F': ['CS', '1', 'RGBLUTTransferFunction'],
        '0x1410': ['CS', '1', 'AlphaLUTTransferFunction'],
        '0x2000': ['OB', '1', 'ICCProfile'],
        '0x2110': ['CS', '1', 'LossyImageCompression'],
        '0x2112': ['DS', '1-n', 'LossyImageCompressionRatio'],
        '0x2114': ['CS', '1-n', 'LossyImageCompressionMethod'],
        '0x3000': ['SQ', '1', 'ModalityLUTSequence'],
        '0x3002': ['xs', '3', 'LUTDescriptor'],
        '0x3003': ['LO', '1', 'LUTExplanation'],
        '0x3004': ['LO', '1', 'ModalityLUTType'],
        '0x3006': ['US or OW', '1-n or 1', 'LUTData'],
        '0x3010': ['SQ', '1', 'VOILUTSequence'],
        '0x3110': ['SQ', '1', 'SoftcopyVOILUTSequence'],
        '0x4000': ['LT', '1', 'ImagePresentationComments'],
        '0x5000': ['SQ', '1', 'BiPlaneAcquisitionSequence'],
        '0x6010': ['US', '1', 'RepresentativeFrameNumber'],
        '0x6020': ['US', '1-n', 'FrameNumbersOfInterest'],
        '0x6022': ['LO', '1-n', 'FrameOfInterestDescription'],
        '0x6023': ['CS', '1-n', 'FrameOfInterestType'],
        '0x6030': ['US', '1-n', 'MaskPointers'],
        '0x6040': ['US', '1-n', 'RWavePointer'],
        '0x6100': ['SQ', '1', 'MaskSubtractionSequence'],
        '0x6101': ['CS', '1', 'MaskOperation'],
        '0x6102': ['US', '2-2n', 'ApplicableFrameRange'],
        '0x6110': ['US', '1-n', 'MaskFrameNumbers'],
        '0x6112': ['US', '1', 'ContrastFrameAveraging'],
        '0x6114': ['FL', '2', 'MaskSubPixelShift'],
        '0x6120': ['SS', '1', 'TIDOffset'],
        '0x6190': ['ST', '1', 'MaskOperationExplanation'],
        '0x7000': ['SQ', '1', 'EquipmentAdministratorSequence'],
        '0x7001': ['US', '1', 'NumberOfDisplaySubsystems'],
        '0x7002': ['US', '1', 'CurrentConfigurationID'],
        '0x7003': ['US', '1', 'DisplaySubsystemID'],
        '0x7004': ['SH', '1', 'DisplaySubsystemName'],
        '0x7005': ['LO', '1', 'DisplaySubsystemDescription'],
        '0x7006': ['CS', '1', 'SystemStatus'],
        '0x7007': ['LO', '1', 'SystemStatusComment'],
        '0x7008': ['SQ', '1', 'TargetLuminanceCharacteristicsSequence'],
        '0x7009': ['US', '1', 'LuminanceCharacteristicsID'],
        '0x700A': ['SQ', '1', 'DisplaySubsystemConfigurationSequence'],
        '0x700B': ['US', '1', 'ConfigurationID'],
        '0x700C': ['SH', '1', 'ConfigurationName'],
        '0x700D': ['LO', '1', 'ConfigurationDescription'],
        '0x700E': ['US', '1', 'ReferencedTargetLuminanceCharacteristicsID'],
        '0x700F': ['SQ', '1', 'QAResultsSequence'],
        '0x7010': ['SQ', '1', 'DisplaySubsystemQAResultsSequence'],
        '0x7011': ['SQ', '1', 'ConfigurationQAResultsSequence'],
        '0x7012': ['SQ', '1', 'MeasurementEquipmentSequence'],
        '0x7013': ['CS', '1-n', 'MeasurementFunctions'],
        '0x7014': ['CS', '1', 'MeasurementEquipmentType'],
        '0x7015': ['SQ', '1', 'VisualEvaluationResultSequence'],
        '0x7016': ['SQ', '1', 'DisplayCalibrationResultSequence'],
        '0x7017': ['US', '1', 'DDLValue'],
        '0x7018': ['FL', '2', 'CIExyWhitePoint'],
        '0x7019': ['CS', '1', 'DisplayFunctionType'],
        '0x701A': ['FL', '1', 'GammaValue'],
        '0x701B': ['US', '1', 'NumberOfLuminancePoints'],
        '0x701C': ['SQ', '1', 'LuminanceResponseSequence'],
        '0x701D': ['FL', '1', 'TargetMinimumLuminance'],
        '0x701E': ['FL', '1', 'TargetMaximumLuminance'],
        '0x701F': ['FL', '1', 'LuminanceValue'],
        '0x7020': ['LO', '1', 'LuminanceResponseDescription'],
        '0x7021': ['CS', '1', 'WhitePointFlag'],
        '0x7022': ['SQ', '1', 'DisplayDeviceTypeCodeSequence'],
        '0x7023': ['SQ', '1', 'DisplaySubsystemSequence'],
        '0x7024': ['SQ', '1', 'LuminanceResultSequence'],
        '0x7025': ['CS', '1', 'AmbientLightValueSource'],
        '0x7026': ['CS', '1-n', 'MeasuredCharacteristics'],
        '0x7027': ['SQ', '1', 'LuminanceUniformityResultSequence'],
        '0x7028': ['SQ', '1', 'VisualEvaluationTestSequence'],
        '0x7029': ['CS', '1', 'TestResult'],
        '0x702A': ['LO', '1', 'TestResultComment'],
        '0x702B': ['CS', '1', 'TestImageValidation'],
        '0x702C': ['SQ', '1', 'TestPatternCodeSequence'],
        '0x702D': ['SQ', '1', 'MeasurementPatternCodeSequence'],
        '0x702E': ['SQ', '1', 'VisualEvaluationMethodCodeSequence'],
        '0x7FE0': ['UR', '1', 'PixelDataProviderURL'],
        '0x9001': ['UL', '1', 'DataPointRows'],
        '0x9002': ['UL', '1', 'DataPointColumns'],
        '0x9003': ['CS', '1', 'SignalDomainColumns'],
        '0x9099': ['US', '1', 'LargestMonochromePixelValue'],
        '0x9108': ['CS', '1', 'DataRepresentation'],
        '0x9110': ['SQ', '1', 'PixelMeasuresSequence'],
        '0x9132': ['SQ', '1', 'FrameVOILUTSequence'],
        '0x9145': ['SQ', '1', 'PixelValueTransformationSequence'],
        '0x9235': ['CS', '1', 'SignalDomainRows'],
        '0x9411': ['FL', '1', 'DisplayFilterPercentage'],
        '0x9415': ['SQ', '1', 'FramePixelShiftSequence'],
        '0x9416': ['US', '1', 'SubtractionItemID'],
        '0x9422': ['SQ', '1', 'PixelIntensityRelationshipLUTSequence'],
        '0x9443': ['SQ', '1', 'FramePixelDataPropertiesSequence'],
        '0x9444': ['CS', '1', 'GeometricalProperties'],
        '0x9445': ['FL', '1', 'GeometricMaximumDistortion'],
        '0x9446': ['CS', '1-n', 'ImageProcessingApplied'],
        '0x9454': ['CS', '1', 'MaskSelectionMode'],
        '0x9474': ['CS', '1', 'LUTFunction'],
        '0x9478': ['FL', '1', 'MaskVisibilityPercentage'],
        '0x9501': ['SQ', '1', 'PixelShiftSequence'],
        '0x9502': ['SQ', '1', 'RegionPixelShiftSequence'],
        '0x9503': ['SS', '2-2n', 'VerticesOfTheRegion'],
        '0x9505': ['SQ', '1', 'MultiFramePresentationSequence'],
        '0x9506': ['US', '2-2n', 'PixelShiftFrameRange'],
        '0x9507': ['US', '2-2n', 'LUTFrameRange'],
        '0x9520': ['DS', '16', 'ImageToEquipmentMappingMatrix'],
        '0x9537': ['CS', '1', 'EquipmentCoordinateSystemIdentification'],
    },
    '0x0032': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x000A': ['CS', '1', 'StudyStatusID'],
        '0x000C': ['CS', '1', 'StudyPriorityID'],
        '0x0012': ['LO', '1', 'StudyIDIssuer'],
        '0x0032': ['DA', '1', 'StudyVerifiedDate'],
        '0x0033': ['TM', '1', 'StudyVerifiedTime'],
        '0x0034': ['DA', '1', 'StudyReadDate'],
        '0x0035': ['TM', '1', 'StudyReadTime'],
        '0x1000': ['DA', '1', 'ScheduledStudyStartDate'],
        '0x1001': ['TM', '1', 'ScheduledStudyStartTime'],
        '0x1010': ['DA', '1', 'ScheduledStudyStopDate'],
        '0x1011': ['TM', '1', 'ScheduledStudyStopTime'],
        '0x1020': ['LO', '1', 'ScheduledStudyLocation'],
        '0x1021': ['AE', '1-n', 'ScheduledStudyLocationAETitle'],
        '0x1030': ['LO', '1', 'ReasonForStudy'],
        '0x1031': ['SQ', '1', 'RequestingPhysicianIdentificationSequence'],
        '0x1032': ['PN', '1', 'RequestingPhysician'],
        '0x1033': ['LO', '1', 'RequestingService'],
        '0x1034': ['SQ', '1', 'RequestingServiceCodeSequence'],
        '0x1040': ['DA', '1', 'StudyArrivalDate'],
        '0x1041': ['TM', '1', 'StudyArrivalTime'],
        '0x1050': ['DA', '1', 'StudyCompletionDate'],
        '0x1051': ['TM', '1', 'StudyCompletionTime'],
        '0x1055': ['CS', '1', 'StudyComponentStatusID'],
        '0x1060': ['LO', '1', 'RequestedProcedureDescription'],
        '0x1064': ['SQ', '1', 'RequestedProcedureCodeSequence'],
        '0x1070': ['LO', '1', 'RequestedContrastAgent'],
        '0x4000': ['LT', '1', 'StudyComments'],
    },
    '0x0038': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0004': ['SQ', '1', 'ReferencedPatientAliasSequence'],
        '0x0008': ['CS', '1', 'VisitStatusID'],
        '0x0010': ['LO', '1', 'AdmissionID'],
        '0x0011': ['LO', '1', 'IssuerOfAdmissionID'],
        '0x0014': ['SQ', '1', 'IssuerOfAdmissionIDSequence'],
        '0x0016': ['LO', '1', 'RouteOfAdmissions'],
        '0x001A': ['DA', '1', 'ScheduledAdmissionDate'],
        '0x001B': ['TM', '1', 'ScheduledAdmissionTime'],
        '0x001C': ['DA', '1', 'ScheduledDischargeDate'],
        '0x001D': ['TM', '1', 'ScheduledDischargeTime'],
        '0x001E': ['LO', '1', 'ScheduledPatientInstitutionResidence'],
        '0x0020': ['DA', '1', 'AdmittingDate'],
        '0x0021': ['TM', '1', 'AdmittingTime'],
        '0x0030': ['DA', '1', 'DischargeDate'],
        '0x0032': ['TM', '1', 'DischargeTime'],
        '0x0040': ['LO', '1', 'DischargeDiagnosisDescription'],
        '0x0044': ['SQ', '1', 'DischargeDiagnosisCodeSequence'],
        '0x0050': ['LO', '1', 'SpecialNeeds'],
        '0x0060': ['LO', '1', 'ServiceEpisodeID'],
        '0x0061': ['LO', '1', 'IssuerOfServiceEpisodeID'],
        '0x0062': ['LO', '1', 'ServiceEpisodeDescription'],
        '0x0064': ['SQ', '1', 'IssuerOfServiceEpisodeIDSequence'],
        '0x0100': ['SQ', '1', 'PertinentDocumentsSequence'],
        '0x0101': ['SQ', '1', 'PertinentResourcesSequence'],
        '0x0102': ['LO', '1', 'ResourceDescription'],
        '0x0300': ['LO', '1', 'CurrentPatientLocation'],
        '0x0400': ['LO', '1', 'PatientInstitutionResidence'],
        '0x0500': ['LO', '1', 'PatientState'],
        '0x0502': ['SQ', '1', 'PatientClinicalTrialParticipationSequence'],
        '0x4000': ['LT', '1', 'VisitComments'],
    },
    '0x003A': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0004': ['CS', '1', 'WaveformOriginality'],
        '0x0005': ['US', '1', 'NumberOfWaveformChannels'],
        '0x0010': ['UL', '1', 'NumberOfWaveformSamples'],
        '0x001A': ['DS', '1', 'SamplingFrequency'],
        '0x0020': ['SH', '1', 'MultiplexGroupLabel'],
        '0x0200': ['SQ', '1', 'ChannelDefinitionSequence'],
        '0x0202': ['IS', '1', 'WaveformChannelNumber'],
        '0x0203': ['SH', '1', 'ChannelLabel'],
        '0x0205': ['CS', '1-n', 'ChannelStatus'],
        '0x0208': ['SQ', '1', 'ChannelSourceSequence'],
        '0x0209': ['SQ', '1', 'ChannelSourceModifiersSequence'],
        '0x020A': ['SQ', '1', 'SourceWaveformSequence'],
        '0x020C': ['LO', '1', 'ChannelDerivationDescription'],
        '0x0210': ['DS', '1', 'ChannelSensitivity'],
        '0x0211': ['SQ', '1', 'ChannelSensitivityUnitsSequence'],
        '0x0212': ['DS', '1', 'ChannelSensitivityCorrectionFactor'],
        '0x0213': ['DS', '1', 'ChannelBaseline'],
        '0x0214': ['DS', '1', 'ChannelTimeSkew'],
        '0x0215': ['DS', '1', 'ChannelSampleSkew'],
        '0x0218': ['DS', '1', 'ChannelOffset'],
        '0x021A': ['US', '1', 'WaveformBitsStored'],
        '0x0220': ['DS', '1', 'FilterLowFrequency'],
        '0x0221': ['DS', '1', 'FilterHighFrequency'],
        '0x0222': ['DS', '1', 'NotchFilterFrequency'],
        '0x0223': ['DS', '1', 'NotchFilterBandwidth'],
        '0x0230': ['FL', '1', 'WaveformDataDisplayScale'],
        '0x0231': ['US', '3', 'WaveformDisplayBackgroundCIELabValue'],
        '0x0240': ['SQ', '1', 'WaveformPresentationGroupSequence'],
        '0x0241': ['US', '1', 'PresentationGroupNumber'],
        '0x0242': ['SQ', '1', 'ChannelDisplaySequence'],
        '0x0244': ['US', '3', 'ChannelRecommendedDisplayCIELabValue'],
        '0x0245': ['FL', '1', 'ChannelPosition'],
        '0x0246': ['CS', '1', 'DisplayShadingFlag'],
        '0x0247': ['FL', '1', 'FractionalChannelDisplayScale'],
        '0x0248': ['FL', '1', 'AbsoluteChannelDisplayScale'],
        '0x0300': ['SQ', '1', 'MultiplexedAudioChannelsDescriptionCodeSequence'],
        '0x0301': ['IS', '1', 'ChannelIdentificationCode'],
        '0x0302': ['CS', '1', 'ChannelMode'],
    },
    '0x0040': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['AE', '1-n', 'ScheduledStationAETitle'],
        '0x0002': ['DA', '1', 'ScheduledProcedureStepStartDate'],
        '0x0003': ['TM', '1', 'ScheduledProcedureStepStartTime'],
        '0x0004': ['DA', '1', 'ScheduledProcedureStepEndDate'],
        '0x0005': ['TM', '1', 'ScheduledProcedureStepEndTime'],
        '0x0006': ['PN', '1', 'ScheduledPerformingPhysicianName'],
        '0x0007': ['LO', '1', 'ScheduledProcedureStepDescription'],
        '0x0008': ['SQ', '1', 'ScheduledProtocolCodeSequence'],
        '0x0009': ['SH', '1', 'ScheduledProcedureStepID'],
        '0x000A': ['SQ', '1', 'StageCodeSequence'],
        '0x000B': ['SQ', '1', 'ScheduledPerformingPhysicianIdentificationSequence'],
        '0x0010': ['SH', '1-n', 'ScheduledStationName'],
        '0x0011': ['SH', '1', 'ScheduledProcedureStepLocation'],
        '0x0012': ['LO', '1', 'PreMedication'],
        '0x0020': ['CS', '1', 'ScheduledProcedureStepStatus'],
        '0x0026': ['SQ', '1', 'OrderPlacerIdentifierSequence'],
        '0x0027': ['SQ', '1', 'OrderFillerIdentifierSequence'],
        '0x0031': ['UT', '1', 'LocalNamespaceEntityID'],
        '0x0032': ['UT', '1', 'UniversalEntityID'],
        '0x0033': ['CS', '1', 'UniversalEntityIDType'],
        '0x0035': ['CS', '1', 'IdentifierTypeCode'],
        '0x0036': ['SQ', '1', 'AssigningFacilitySequence'],
        '0x0039': ['SQ', '1', 'AssigningJurisdictionCodeSequence'],
        '0x003A': ['SQ', '1', 'AssigningAgencyOrDepartmentCodeSequence'],
        '0x0100': ['SQ', '1', 'ScheduledProcedureStepSequence'],
        '0x0220': ['SQ', '1', 'ReferencedNonImageCompositeSOPInstanceSequence'],
        '0x0241': ['AE', '1', 'PerformedStationAETitle'],
        '0x0242': ['SH', '1', 'PerformedStationName'],
        '0x0243': ['SH', '1', 'PerformedLocation'],
        '0x0244': ['DA', '1', 'PerformedProcedureStepStartDate'],
        '0x0245': ['TM', '1', 'PerformedProcedureStepStartTime'],
        '0x0250': ['DA', '1', 'PerformedProcedureStepEndDate'],
        '0x0251': ['TM', '1', 'PerformedProcedureStepEndTime'],
        '0x0252': ['CS', '1', 'PerformedProcedureStepStatus'],
        '0x0253': ['SH', '1', 'PerformedProcedureStepID'],
        '0x0254': ['LO', '1', 'PerformedProcedureStepDescription'],
        '0x0255': ['LO', '1', 'PerformedProcedureTypeDescription'],
        '0x0260': ['SQ', '1', 'PerformedProtocolCodeSequence'],
        '0x0261': ['CS', '1', 'PerformedProtocolType'],
        '0x0270': ['SQ', '1', 'ScheduledStepAttributesSequence'],
        '0x0275': ['SQ', '1', 'RequestAttributesSequence'],
        '0x0280': ['ST', '1', 'CommentsOnThePerformedProcedureStep'],
        '0x0281': ['SQ', '1', 'PerformedProcedureStepDiscontinuationReasonCodeSequence'],
        '0x0293': ['SQ', '1', 'QuantitySequence'],
        '0x0294': ['DS', '1', 'Quantity'],
        '0x0295': ['SQ', '1', 'MeasuringUnitsSequence'],
        '0x0296': ['SQ', '1', 'BillingItemSequence'],
        '0x0300': ['US', '1', 'TotalTimeOfFluoroscopy'],
        '0x0301': ['US', '1', 'TotalNumberOfExposures'],
        '0x0302': ['US', '1', 'EntranceDose'],
        '0x0303': ['US', '1-2', 'ExposedArea'],
        '0x0306': ['DS', '1', 'DistanceSourceToEntrance'],
        '0x0307': ['DS', '1', 'DistanceSourceToSupport'],
        '0x030E': ['SQ', '1', 'ExposureDoseSequence'],
        '0x0310': ['ST', '1', 'CommentsOnRadiationDose'],
        '0x0312': ['DS', '1', 'XRayOutput'],
        '0x0314': ['DS', '1', 'HalfValueLayer'],
        '0x0316': ['DS', '1', 'OrganDose'],
        '0x0318': ['CS', '1', 'OrganExposed'],
        '0x0320': ['SQ', '1', 'BillingProcedureStepSequence'],
        '0x0321': ['SQ', '1', 'FilmConsumptionSequence'],
        '0x0324': ['SQ', '1', 'BillingSuppliesAndDevicesSequence'],
        '0x0330': ['SQ', '1', 'ReferencedProcedureStepSequence'],
        '0x0340': ['SQ', '1', 'PerformedSeriesSequence'],
        '0x0400': ['LT', '1', 'CommentsOnTheScheduledProcedureStep'],
        '0x0440': ['SQ', '1', 'ProtocolContextSequence'],
        '0x0441': ['SQ', '1', 'ContentItemModifierSequence'],
        '0x0500': ['SQ', '1', 'ScheduledSpecimenSequence'],
        '0x050A': ['LO', '1', 'SpecimenAccessionNumber'],
        '0x0512': ['LO', '1', 'ContainerIdentifier'],
        '0x0513': ['SQ', '1', 'IssuerOfTheContainerIdentifierSequence'],
        '0x0515': ['SQ', '1', 'AlternateContainerIdentifierSequence'],
        '0x0518': ['SQ', '1', 'ContainerTypeCodeSequence'],
        '0x051A': ['LO', '1', 'ContainerDescription'],
        '0x0520': ['SQ', '1', 'ContainerComponentSequence'],
        '0x0550': ['SQ', '1', 'SpecimenSequence'],
        '0x0551': ['LO', '1', 'SpecimenIdentifier'],
        '0x0552': ['SQ', '1', 'SpecimenDescriptionSequenceTrial'],
        '0x0553': ['ST', '1', 'SpecimenDescriptionTrial'],
        '0x0554': ['UI', '1', 'SpecimenUID'],
        '0x0555': ['SQ', '1', 'AcquisitionContextSequence'],
        '0x0556': ['ST', '1', 'AcquisitionContextDescription'],
        '0x059A': ['SQ', '1', 'SpecimenTypeCodeSequence'],
        '0x0560': ['SQ', '1', 'SpecimenDescriptionSequence'],
        '0x0562': ['SQ', '1', 'IssuerOfTheSpecimenIdentifierSequence'],
        '0x0600': ['LO', '1', 'SpecimenShortDescription'],
        '0x0602': ['UT', '1', 'SpecimenDetailedDescription'],
        '0x0610': ['SQ', '1', 'SpecimenPreparationSequence'],
        '0x0612': ['SQ', '1', 'SpecimenPreparationStepContentItemSequence'],
        '0x0620': ['SQ', '1', 'SpecimenLocalizationContentItemSequence'],
        '0x06FA': ['LO', '1', 'SlideIdentifier'],
        '0x071A': ['SQ', '1', 'ImageCenterPointCoordinatesSequence'],
        '0x072A': ['DS', '1', 'XOffsetInSlideCoordinateSystem'],
        '0x073A': ['DS', '1', 'YOffsetInSlideCoordinateSystem'],
        '0x074A': ['DS', '1', 'ZOffsetInSlideCoordinateSystem'],
        '0x08D8': ['SQ', '1', 'PixelSpacingSequence'],
        '0x08DA': ['SQ', '1', 'CoordinateSystemAxisCodeSequence'],
        '0x08EA': ['SQ', '1', 'MeasurementUnitsCodeSequence'],
        '0x09F8': ['SQ', '1', 'VitalStainCodeSequenceTrial'],
        '0x1001': ['SH', '1', 'RequestedProcedureID'],
        '0x1002': ['LO', '1', 'ReasonForTheRequestedProcedure'],
        '0x1003': ['SH', '1', 'RequestedProcedurePriority'],
        '0x1004': ['LO', '1', 'PatientTransportArrangements'],
        '0x1005': ['LO', '1', 'RequestedProcedureLocation'],
        '0x1006': ['SH', '1', 'PlacerOrderNumberProcedure'],
        '0x1007': ['SH', '1', 'FillerOrderNumberProcedure'],
        '0x1008': ['LO', '1', 'ConfidentialityCode'],
        '0x1009': ['SH', '1', 'ReportingPriority'],
        '0x100A': ['SQ', '1', 'ReasonForRequestedProcedureCodeSequence'],
        '0x1010': ['PN', '1-n', 'NamesOfIntendedRecipientsOfResults'],
        '0x1011': ['SQ', '1', 'IntendedRecipientsOfResultsIdentificationSequence'],
        '0x1012': ['SQ', '1', 'ReasonForPerformedProcedureCodeSequence'],
        '0x1060': ['LO', '1', 'RequestedProcedureDescriptionTrial'],
        '0x1101': ['SQ', '1', 'PersonIdentificationCodeSequence'],
        '0x1102': ['ST', '1', 'PersonAddress'],
        '0x1103': ['LO', '1-n', 'PersonTelephoneNumbers'],
        '0x1104': ['LT', '1', 'PersonTelecomInformation'],
        '0x1400': ['LT', '1', 'RequestedProcedureComments'],
        '0x2001': ['LO', '1', 'ReasonForTheImagingServiceRequest'],
        '0x2004': ['DA', '1', 'IssueDateOfImagingServiceRequest'],
        '0x2005': ['TM', '1', 'IssueTimeOfImagingServiceRequest'],
        '0x2006': ['SH', '1', 'PlacerOrderNumberImagingServiceRequestRetired'],
        '0x2007': ['SH', '1', 'FillerOrderNumberImagingServiceRequestRetired'],
        '0x2008': ['PN', '1', 'OrderEnteredBy'],
        '0x2009': ['SH', '1', 'OrderEntererLocation'],
        '0x2010': ['SH', '1', 'OrderCallbackPhoneNumber'],
        '0x2011': ['LT', '1', 'OrderCallbackTelecomInformation'],
        '0x2016': ['LO', '1', 'PlacerOrderNumberImagingServiceRequest'],
        '0x2017': ['LO', '1', 'FillerOrderNumberImagingServiceRequest'],
        '0x2400': ['LT', '1', 'ImagingServiceRequestComments'],
        '0x3001': ['LO', '1', 'ConfidentialityConstraintOnPatientDataDescription'],
        '0x4001': ['CS', '1', 'GeneralPurposeScheduledProcedureStepStatus'],
        '0x4002': ['CS', '1', 'GeneralPurposePerformedProcedureStepStatus'],
        '0x4003': ['CS', '1', 'GeneralPurposeScheduledProcedureStepPriority'],
        '0x4004': ['SQ', '1', 'ScheduledProcessingApplicationsCodeSequence'],
        '0x4005': ['DT', '1', 'ScheduledProcedureStepStartDateTime'],
        '0x4006': ['CS', '1', 'MultipleCopiesFlag'],
        '0x4007': ['SQ', '1', 'PerformedProcessingApplicationsCodeSequence'],
        '0x4009': ['SQ', '1', 'HumanPerformerCodeSequence'],
        '0x4010': ['DT', '1', 'ScheduledProcedureStepModificationDateTime'],
        '0x4011': ['DT', '1', 'ExpectedCompletionDateTime'],
        '0x4015': ['SQ', '1', 'ResultingGeneralPurposePerformedProcedureStepsSequence'],
        '0x4016': ['SQ', '1', 'ReferencedGeneralPurposeScheduledProcedureStepSequence'],
        '0x4018': ['SQ', '1', 'ScheduledWorkitemCodeSequence'],
        '0x4019': ['SQ', '1', 'PerformedWorkitemCodeSequence'],
        '0x4020': ['CS', '1', 'InputAvailabilityFlag'],
        '0x4021': ['SQ', '1', 'InputInformationSequence'],
        '0x4022': ['SQ', '1', 'RelevantInformationSequence'],
        '0x4023': ['UI', '1', 'ReferencedGeneralPurposeScheduledProcedureStepTransactionUID'],
        '0x4025': ['SQ', '1', 'ScheduledStationNameCodeSequence'],
        '0x4026': ['SQ', '1', 'ScheduledStationClassCodeSequence'],
        '0x4027': ['SQ', '1', 'ScheduledStationGeographicLocationCodeSequence'],
        '0x4028': ['SQ', '1', 'PerformedStationNameCodeSequence'],
        '0x4029': ['SQ', '1', 'PerformedStationClassCodeSequence'],
        '0x4030': ['SQ', '1', 'PerformedStationGeographicLocationCodeSequence'],
        '0x4031': ['SQ', '1', 'RequestedSubsequentWorkitemCodeSequence'],
        '0x4032': ['SQ', '1', 'NonDICOMOutputCodeSequence'],
        '0x4033': ['SQ', '1', 'OutputInformationSequence'],
        '0x4034': ['SQ', '1', 'ScheduledHumanPerformersSequence'],
        '0x4035': ['SQ', '1', 'ActualHumanPerformersSequence'],
        '0x4036': ['LO', '1', 'HumanPerformerOrganization'],
        '0x4037': ['PN', '1', 'HumanPerformerName'],
        '0x4040': ['CS', '1', 'RawDataHandling'],
        '0x4041': ['CS', '1', 'InputReadinessState'],
        '0x4050': ['DT', '1', 'PerformedProcedureStepStartDateTime'],
        '0x4051': ['DT', '1', 'PerformedProcedureStepEndDateTime'],
        '0x4052': ['DT', '1', 'ProcedureStepCancellationDateTime'],
        '0x8302': ['DS', '1', 'EntranceDoseInmGy'],
        '0x9092': ['SQ', '1', 'ParametricMapFrameTypeSequence'],
        '0x9094': ['SQ', '1', 'ReferencedImageRealWorldValueMappingSequence'],
        '0x9096': ['SQ', '1', 'RealWorldValueMappingSequence'],
        '0x9098': ['SQ', '1', 'PixelValueMappingCodeSequence'],
        '0x9210': ['SH', '1', 'LUTLabel'],
        '0x9211': ['xs', '1', 'RealWorldValueLastValueMapped'],
        '0x9212': ['FD', '1-n', 'RealWorldValueLUTData'],
        '0x9216': ['xs', '1', 'RealWorldValueFirstValueMapped'],
        '0x9220': ['SQ', '1', 'QuantityDefinitionSequence'],
        '0x9224': ['FD', '1', 'RealWorldValueIntercept'],
        '0x9225': ['FD', '1', 'RealWorldValueSlope'],
        '0xA007': ['CS', '1', 'FindingsFlagTrial'],
        '0xA010': ['CS', '1', 'RelationshipType'],
        '0xA020': ['SQ', '1', 'FindingsSequenceTrial'],
        '0xA021': ['UI', '1', 'FindingsGroupUIDTrial'],
        '0xA022': ['UI', '1', 'ReferencedFindingsGroupUIDTrial'],
        '0xA023': ['DA', '1', 'FindingsGroupRecordingDateTrial'],
        '0xA024': ['TM', '1', 'FindingsGroupRecordingTimeTrial'],
        '0xA026': ['SQ', '1', 'FindingsSourceCategoryCodeSequenceTrial'],
        '0xA027': ['LO', '1', 'VerifyingOrganization'],
        '0xA028': ['SQ', '1', 'DocumentingOrganizationIdentifierCodeSequenceTrial'],
        '0xA030': ['DT', '1', 'VerificationDateTime'],
        '0xA032': ['DT', '1', 'ObservationDateTime'],
        '0xA040': ['CS', '1', 'ValueType'],
        '0xA043': ['SQ', '1', 'ConceptNameCodeSequence'],
        '0xA047': ['LO', '1', 'MeasurementPrecisionDescriptionTrial'],
        '0xA050': ['CS', '1', 'ContinuityOfContent'],
        '0xA057': ['CS', '1-n', 'UrgencyOrPriorityAlertsTrial'],
        '0xA060': ['LO', '1', 'SequencingIndicatorTrial'],
        '0xA066': ['SQ', '1', 'DocumentIdentifierCodeSequenceTrial'],
        '0xA067': ['PN', '1', 'DocumentAuthorTrial'],
        '0xA068': ['SQ', '1', 'DocumentAuthorIdentifierCodeSequenceTrial'],
        '0xA070': ['SQ', '1', 'IdentifierCodeSequenceTrial'],
        '0xA073': ['SQ', '1', 'VerifyingObserverSequence'],
        '0xA074': ['OB', '1', 'ObjectBinaryIdentifierTrial'],
        '0xA075': ['PN', '1', 'VerifyingObserverName'],
        '0xA076': ['SQ', '1', 'DocumentingObserverIdentifierCodeSequenceTrial'],
        '0xA078': ['SQ', '1', 'AuthorObserverSequence'],
        '0xA07A': ['SQ', '1', 'ParticipantSequence'],
        '0xA07C': ['SQ', '1', 'CustodialOrganizationSequence'],
        '0xA080': ['CS', '1', 'ParticipationType'],
        '0xA082': ['DT', '1', 'ParticipationDateTime'],
        '0xA084': ['CS', '1', 'ObserverType'],
        '0xA085': ['SQ', '1', 'ProcedureIdentifierCodeSequenceTrial'],
        '0xA088': ['SQ', '1', 'VerifyingObserverIdentificationCodeSequence'],
        '0xA089': ['OB', '1', 'ObjectDirectoryBinaryIdentifierTrial'],
        '0xA090': ['SQ', '1', 'EquivalentCDADocumentSequence'],
        '0xA0B0': ['US', '2-2n', 'ReferencedWaveformChannels'],
        '0xA110': ['DA', '1', 'DateOfDocumentOrVerbalTransactionTrial'],
        '0xA112': ['TM', '1', 'TimeOfDocumentCreationOrVerbalTransactionTrial'],
        '0xA120': ['DT', '1', 'DateTime'],
        '0xA121': ['DA', '1', 'Date'],
        '0xA122': ['TM', '1', 'Time'],
        '0xA123': ['PN', '1', 'PersonName'],
        '0xA124': ['UI', '1', 'UID'],
        '0xA125': ['CS', '2', 'ReportStatusIDTrial'],
        '0xA130': ['CS', '1', 'TemporalRangeType'],
        '0xA132': ['UL', '1-n', 'ReferencedSamplePositions'],
        '0xA136': ['US', '1-n', 'ReferencedFrameNumbers'],
        '0xA138': ['DS', '1-n', 'ReferencedTimeOffsets'],
        '0xA13A': ['DT', '1-n', 'ReferencedDateTime'],
        '0xA160': ['UT', '1', 'TextValue'],
        '0xA161': ['FD', '1-n', 'FloatingPointValue'],
        '0xA162': ['SL', '1-n', 'RationalNumeratorValue'],
        '0xA163': ['UL', '1-n', 'RationalDenominatorValue'],
        '0xA167': ['SQ', '1', 'ObservationCategoryCodeSequenceTrial'],
        '0xA168': ['SQ', '1', 'ConceptCodeSequence'],
        '0xA16A': ['ST', '1', 'BibliographicCitationTrial'],
        '0xA170': ['SQ', '1', 'PurposeOfReferenceCodeSequence'],
        '0xA171': ['UI', '1', 'ObservationUID'],
        '0xA172': ['UI', '1', 'ReferencedObservationUIDTrial'],
        '0xA173': ['CS', '1', 'ReferencedObservationClassTrial'],
        '0xA174': ['CS', '1', 'ReferencedObjectObservationClassTrial'],
        '0xA180': ['US', '1', 'AnnotationGroupNumber'],
        '0xA192': ['DA', '1', 'ObservationDateTrial'],
        '0xA193': ['TM', '1', 'ObservationTimeTrial'],
        '0xA194': ['CS', '1', 'MeasurementAutomationTrial'],
        '0xA195': ['SQ', '1', 'ModifierCodeSequence'],
        '0xA224': ['ST', '1', 'IdentificationDescriptionTrial'],
        '0xA290': ['CS', '1', 'CoordinatesSetGeometricTypeTrial'],
        '0xA296': ['SQ', '1', 'AlgorithmCodeSequenceTrial'],
        '0xA297': ['ST', '1', 'AlgorithmDescriptionTrial'],
        '0xA29A': ['SL', '2-2n', 'PixelCoordinatesSetTrial'],
        '0xA300': ['SQ', '1', 'MeasuredValueSequence'],
        '0xA301': ['SQ', '1', 'NumericValueQualifierCodeSequence'],
        '0xA307': ['PN', '1', 'CurrentObserverTrial'],
        '0xA30A': ['DS', '1-n', 'NumericValue'],
        '0xA313': ['SQ', '1', 'ReferencedAccessionSequenceTrial'],
        '0xA33A': ['ST', '1', 'ReportStatusCommentTrial'],
        '0xA340': ['SQ', '1', 'ProcedureContextSequenceTrial'],
        '0xA352': ['PN', '1', 'VerbalSourceTrial'],
        '0xA353': ['ST', '1', 'AddressTrial'],
        '0xA354': ['LO', '1', 'TelephoneNumberTrial'],
        '0xA358': ['SQ', '1', 'VerbalSourceIdentifierCodeSequenceTrial'],
        '0xA360': ['SQ', '1', 'PredecessorDocumentsSequence'],
        '0xA370': ['SQ', '1', 'ReferencedRequestSequence'],
        '0xA372': ['SQ', '1', 'PerformedProcedureCodeSequence'],
        '0xA375': ['SQ', '1', 'CurrentRequestedProcedureEvidenceSequence'],
        '0xA380': ['SQ', '1', 'ReportDetailSequenceTrial'],
        '0xA385': ['SQ', '1', 'PertinentOtherEvidenceSequence'],
        '0xA390': ['SQ', '1', 'HL7StructuredDocumentReferenceSequence'],
        '0xA402': ['UI', '1', 'ObservationSubjectUIDTrial'],
        '0xA403': ['CS', '1', 'ObservationSubjectClassTrial'],
        '0xA404': ['SQ', '1', 'ObservationSubjectTypeCodeSequenceTrial'],
        '0xA491': ['CS', '1', 'CompletionFlag'],
        '0xA492': ['LO', '1', 'CompletionFlagDescription'],
        '0xA493': ['CS', '1', 'VerificationFlag'],
        '0xA494': ['CS', '1', 'ArchiveRequested'],
        '0xA496': ['CS', '1', 'PreliminaryFlag'],
        '0xA504': ['SQ', '1', 'ContentTemplateSequence'],
        '0xA525': ['SQ', '1', 'IdenticalDocumentsSequence'],
        '0xA600': ['CS', '1', 'ObservationSubjectContextFlagTrial'],
        '0xA601': ['CS', '1', 'ObserverContextFlagTrial'],
        '0xA603': ['CS', '1', 'ProcedureContextFlagTrial'],
        '0xA730': ['SQ', '1', 'ContentSequence'],
        '0xA731': ['SQ', '1', 'RelationshipSequenceTrial'],
        '0xA732': ['SQ', '1', 'RelationshipTypeCodeSequenceTrial'],
        '0xA744': ['SQ', '1', 'LanguageCodeSequenceTrial'],
        '0xA992': ['ST', '1', 'UniformResourceLocatorTrial'],
        '0xB020': ['SQ', '1', 'WaveformAnnotationSequence'],
        '0xDB00': ['CS', '1', 'TemplateIdentifier'],
        '0xDB06': ['DT', '1', 'TemplateVersion'],
        '0xDB07': ['DT', '1', 'TemplateLocalVersion'],
        '0xDB0B': ['CS', '1', 'TemplateExtensionFlag'],
        '0xDB0C': ['UI', '1', 'TemplateExtensionOrganizationUID'],
        '0xDB0D': ['UI', '1', 'TemplateExtensionCreatorUID'],
        '0xDB73': ['UL', '1-n', 'ReferencedContentItemIdentifier'],
        '0xE001': ['ST', '1', 'HL7InstanceIdentifier'],
        '0xE004': ['DT', '1', 'HL7DocumentEffectiveTime'],
        '0xE006': ['SQ', '1', 'HL7DocumentTypeCodeSequence'],
        '0xE008': ['SQ', '1', 'DocumentClassCodeSequence'],
        '0xE010': ['UR', '1', 'RetrieveURI'],
        '0xE011': ['UI', '1', 'RetrieveLocationUID'],
        '0xE020': ['CS', '1', 'TypeOfInstances'],
        '0xE021': ['SQ', '1', 'DICOMRetrievalSequence'],
        '0xE022': ['SQ', '1', 'DICOMMediaRetrievalSequence'],
        '0xE023': ['SQ', '1', 'WADORetrievalSequence'],
        '0xE024': ['SQ', '1', 'XDSRetrievalSequence'],
        '0xE025': ['SQ', '1', 'WADORSRetrievalSequence'],
        '0xE030': ['UI', '1', 'RepositoryUniqueID'],
        '0xE031': ['UI', '1', 'HomeCommunityID'],
    },
    '0x0042': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['ST', '1', 'DocumentTitle'],
        '0x0011': ['OB', '1', 'EncapsulatedDocument'],
        '0x0012': ['LO', '1', 'MIMETypeOfEncapsulatedDocument'],
        '0x0013': ['SQ', '1', 'SourceInstanceSequence'],
        '0x0014': ['LO', '1-n', 'ListOfMIMETypes'],
    },
    '0x0044': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['ST', '1', 'ProductPackageIdentifier'],
        '0x0002': ['CS', '1', 'SubstanceAdministrationApproval'],
        '0x0003': ['LT', '1', 'ApprovalStatusFurtherDescription'],
        '0x0004': ['DT', '1', 'ApprovalStatusDateTime'],
        '0x0007': ['SQ', '1', 'ProductTypeCodeSequence'],
        '0x0008': ['LO', '1-n', 'ProductName'],
        '0x0009': ['LT', '1', 'ProductDescription'],
        '0x000A': ['LO', '1', 'ProductLotIdentifier'],
        '0x000B': ['DT', '1', 'ProductExpirationDateTime'],
        '0x0010': ['DT', '1', 'SubstanceAdministrationDateTime'],
        '0x0011': ['LO', '1', 'SubstanceAdministrationNotes'],
        '0x0012': ['LO', '1', 'SubstanceAdministrationDeviceID'],
        '0x0013': ['SQ', '1', 'ProductParameterSequence'],
        '0x0019': ['SQ', '1', 'SubstanceAdministrationParameterSequence'],
    },
    '0x0046': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0012': ['LO', '1', 'LensDescription'],
        '0x0014': ['SQ', '1', 'RightLensSequence'],
        '0x0015': ['SQ', '1', 'LeftLensSequence'],
        '0x0016': ['SQ', '1', 'UnspecifiedLateralityLensSequence'],
        '0x0018': ['SQ', '1', 'CylinderSequence'],
        '0x0028': ['SQ', '1', 'PrismSequence'],
        '0x0030': ['FD', '1', 'HorizontalPrismPower'],
        '0x0032': ['CS', '1', 'HorizontalPrismBase'],
        '0x0034': ['FD', '1', 'VerticalPrismPower'],
        '0x0036': ['CS', '1', 'VerticalPrismBase'],
        '0x0038': ['CS', '1', 'LensSegmentType'],
        '0x0040': ['FD', '1', 'OpticalTransmittance'],
        '0x0042': ['FD', '1', 'ChannelWidth'],
        '0x0044': ['FD', '1', 'PupilSize'],
        '0x0046': ['FD', '1', 'CornealSize'],
        '0x0050': ['SQ', '1', 'AutorefractionRightEyeSequence'],
        '0x0052': ['SQ', '1', 'AutorefractionLeftEyeSequence'],
        '0x0060': ['FD', '1', 'DistancePupillaryDistance'],
        '0x0062': ['FD', '1', 'NearPupillaryDistance'],
        '0x0063': ['FD', '1', 'IntermediatePupillaryDistance'],
        '0x0064': ['FD', '1', 'OtherPupillaryDistance'],
        '0x0070': ['SQ', '1', 'KeratometryRightEyeSequence'],
        '0x0071': ['SQ', '1', 'KeratometryLeftEyeSequence'],
        '0x0074': ['SQ', '1', 'SteepKeratometricAxisSequence'],
        '0x0075': ['FD', '1', 'RadiusOfCurvature'],
        '0x0076': ['FD', '1', 'KeratometricPower'],
        '0x0077': ['FD', '1', 'KeratometricAxis'],
        '0x0080': ['SQ', '1', 'FlatKeratometricAxisSequence'],
        '0x0092': ['CS', '1', 'BackgroundColor'],
        '0x0094': ['CS', '1', 'Optotype'],
        '0x0095': ['CS', '1', 'OptotypePresentation'],
        '0x0097': ['SQ', '1', 'SubjectiveRefractionRightEyeSequence'],
        '0x0098': ['SQ', '1', 'SubjectiveRefractionLeftEyeSequence'],
        '0x0100': ['SQ', '1', 'AddNearSequence'],
        '0x0101': ['SQ', '1', 'AddIntermediateSequence'],
        '0x0102': ['SQ', '1', 'AddOtherSequence'],
        '0x0104': ['FD', '1', 'AddPower'],
        '0x0106': ['FD', '1', 'ViewingDistance'],
        '0x0121': ['SQ', '1', 'VisualAcuityTypeCodeSequence'],
        '0x0122': ['SQ', '1', 'VisualAcuityRightEyeSequence'],
        '0x0123': ['SQ', '1', 'VisualAcuityLeftEyeSequence'],
        '0x0124': ['SQ', '1', 'VisualAcuityBothEyesOpenSequence'],
        '0x0125': ['CS', '1', 'ViewingDistanceType'],
        '0x0135': ['SS', '2', 'VisualAcuityModifiers'],
        '0x0137': ['FD', '1', 'DecimalVisualAcuity'],
        '0x0139': ['LO', '1', 'OptotypeDetailedDefinition'],
        '0x0145': ['SQ', '1', 'ReferencedRefractiveMeasurementsSequence'],
        '0x0146': ['FD', '1', 'SpherePower'],
        '0x0147': ['FD', '1', 'CylinderPower'],
        '0x0201': ['CS', '1', 'CornealTopographySurface'],
        '0x0202': ['FL', '2', 'CornealVertexLocation'],
        '0x0203': ['FL', '1', 'PupilCentroidXCoordinate'],
        '0x0204': ['FL', '1', 'PupilCentroidYCoordinate'],
        '0x0205': ['FL', '1', 'EquivalentPupilRadius'],
        '0x0207': ['SQ', '1', 'CornealTopographyMapTypeCodeSequence'],
        '0x0208': ['IS', '2-2n', 'VerticesOfTheOutlineOfPupil'],
        '0x0210': ['SQ', '1', 'CornealTopographyMappingNormalsSequence'],
        '0x0211': ['SQ', '1', 'MaximumCornealCurvatureSequence'],
        '0x0212': ['FL', '1', 'MaximumCornealCurvature'],
        '0x0213': ['FL', '2', 'MaximumCornealCurvatureLocation'],
        '0x0215': ['SQ', '1', 'MinimumKeratometricSequence'],
        '0x0218': ['SQ', '1', 'SimulatedKeratometricCylinderSequence'],
        '0x0220': ['FL', '1', 'AverageCornealPower'],
        '0x0224': ['FL', '1', 'CornealISValue'],
        '0x0227': ['FL', '1', 'AnalyzedArea'],
        '0x0230': ['FL', '1', 'SurfaceRegularityIndex'],
        '0x0232': ['FL', '1', 'SurfaceAsymmetryIndex'],
        '0x0234': ['FL', '1', 'CornealEccentricityIndex'],
        '0x0236': ['FL', '1', 'KeratoconusPredictionIndex'],
        '0x0238': ['FL', '1', 'DecimalPotentialVisualAcuity'],
        '0x0242': ['CS', '1', 'CornealTopographyMapQualityEvaluation'],
        '0x0244': ['SQ', '1', 'SourceImageCornealProcessedDataSequence'],
        '0x0247': ['FL', '3', 'CornealPointLocation'],
        '0x0248': ['CS', '1', 'CornealPointEstimated'],
        '0x0249': ['FL', '1', 'AxialPower'],
        '0x0250': ['FL', '1', 'TangentialPower'],
        '0x0251': ['FL', '1', 'RefractivePower'],
        '0x0252': ['FL', '1', 'RelativeElevation'],
        '0x0253': ['FL', '1', 'CornealWavefront'],
    },
    '0x0048': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['FL', '1', 'ImagedVolumeWidth'],
        '0x0002': ['FL', '1', 'ImagedVolumeHeight'],
        '0x0003': ['FL', '1', 'ImagedVolumeDepth'],
        '0x0006': ['UL', '1', 'TotalPixelMatrixColumns'],
        '0x0007': ['UL', '1', 'TotalPixelMatrixRows'],
        '0x0008': ['SQ', '1', 'TotalPixelMatrixOriginSequence'],
        '0x0010': ['CS', '1', 'SpecimenLabelInImage'],
        '0x0011': ['CS', '1', 'FocusMethod'],
        '0x0012': ['CS', '1', 'ExtendedDepthOfField'],
        '0x0013': ['US', '1', 'NumberOfFocalPlanes'],
        '0x0014': ['FL', '1', 'DistanceBetweenFocalPlanes'],
        '0x0015': ['US', '3', 'RecommendedAbsentPixelCIELabValue'],
        '0x0100': ['SQ', '1', 'IlluminatorTypeCodeSequence'],
        '0x0102': ['DS', '6', 'ImageOrientationSlide'],
        '0x0105': ['SQ', '1', 'OpticalPathSequence'],
        '0x0106': ['SH', '1', 'OpticalPathIdentifier'],
        '0x0107': ['ST', '1', 'OpticalPathDescription'],
        '0x0108': ['SQ', '1', 'IlluminationColorCodeSequence'],
        '0x0110': ['SQ', '1', 'SpecimenReferenceSequence'],
        '0x0111': ['DS', '1', 'CondenserLensPower'],
        '0x0112': ['DS', '1', 'ObjectiveLensPower'],
        '0x0113': ['DS', '1', 'ObjectiveLensNumericalAperture'],
        '0x0120': ['SQ', '1', 'PaletteColorLookupTableSequence'],
        '0x0200': ['SQ', '1', 'ReferencedImageNavigationSequence'],
        '0x0201': ['US', '2', 'TopLeftHandCornerOfLocalizerArea'],
        '0x0202': ['US', '2', 'BottomRightHandCornerOfLocalizerArea'],
        '0x0207': ['SQ', '1', 'OpticalPathIdentificationSequence'],
        '0x021A': ['SQ', '1', 'PlanePositionSlideSequence'],
        '0x021E': ['SL', '1', 'ColumnPositionInTotalImagePixelMatrix'],
        '0x021F': ['SL', '1', 'RowPositionInTotalImagePixelMatrix'],
        '0x0301': ['CS', '1', 'PixelOriginInterpretation'],
    },
    '0x0050': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0004': ['CS', '1', 'CalibrationImage'],
        '0x0010': ['SQ', '1', 'DeviceSequence'],
        '0x0012': ['SQ', '1', 'ContainerComponentTypeCodeSequence'],
        '0x0013': ['FD', '1', 'ContainerComponentThickness'],
        '0x0014': ['DS', '1', 'DeviceLength'],
        '0x0015': ['FD', '1', 'ContainerComponentWidth'],
        '0x0016': ['DS', '1', 'DeviceDiameter'],
        '0x0017': ['CS', '1', 'DeviceDiameterUnits'],
        '0x0018': ['DS', '1', 'DeviceVolume'],
        '0x0019': ['DS', '1', 'InterMarkerDistance'],
        '0x001A': ['CS', '1', 'ContainerComponentMaterial'],
        '0x001B': ['LO', '1', 'ContainerComponentID'],
        '0x001C': ['FD', '1', 'ContainerComponentLength'],
        '0x001D': ['FD', '1', 'ContainerComponentDiameter'],
        '0x001E': ['LO', '1', 'ContainerComponentDescription'],
        '0x0020': ['LO', '1', 'DeviceDescription'],
    },
    '0x0052': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['FL', '1', 'ContrastBolusIngredientPercentByVolume'],
        '0x0002': ['FD', '1', 'OCTFocalDistance'],
        '0x0003': ['FD', '1', 'BeamSpotSize'],
        '0x0004': ['FD', '1', 'EffectiveRefractiveIndex'],
        '0x0006': ['CS', '1', 'OCTAcquisitionDomain'],
        '0x0007': ['FD', '1', 'OCTOpticalCenterWavelength'],
        '0x0008': ['FD', '1', 'AxialResolution'],
        '0x0009': ['FD', '1', 'RangingDepth'],
        '0x0011': ['FD', '1', 'ALineRate'],
        '0x0012': ['US', '1', 'ALinesPerFrame'],
        '0x0013': ['FD', '1', 'CatheterRotationalRate'],
        '0x0014': ['FD', '1', 'ALinePixelSpacing'],
        '0x0016': ['SQ', '1', 'ModeOfPercutaneousAccessSequence'],
        '0x0025': ['SQ', '1', 'IntravascularOCTFrameTypeSequence'],
        '0x0026': ['CS', '1', 'OCTZOffsetApplied'],
        '0x0027': ['SQ', '1', 'IntravascularFrameContentSequence'],
        '0x0028': ['FD', '1', 'IntravascularLongitudinalDistance'],
        '0x0029': ['SQ', '1', 'IntravascularOCTFrameContentSequence'],
        '0x0030': ['SS', '1', 'OCTZOffsetCorrection'],
        '0x0031': ['CS', '1', 'CatheterDirectionOfRotation'],
        '0x0033': ['FD', '1', 'SeamLineLocation'],
        '0x0034': ['FD', '1', 'FirstALineLocation'],
        '0x0036': ['US', '1', 'SeamLineIndex'],
        '0x0038': ['US', '1', 'NumberOfPaddedALines'],
        '0x0039': ['CS', '1', 'InterpolationType'],
        '0x003A': ['CS', '1', 'RefractiveIndexApplied'],
    },
    '0x0054': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['US', '1-n', 'EnergyWindowVector'],
        '0x0011': ['US', '1', 'NumberOfEnergyWindows'],
        '0x0012': ['SQ', '1', 'EnergyWindowInformationSequence'],
        '0x0013': ['SQ', '1', 'EnergyWindowRangeSequence'],
        '0x0014': ['DS', '1', 'EnergyWindowLowerLimit'],
        '0x0015': ['DS', '1', 'EnergyWindowUpperLimit'],
        '0x0016': ['SQ', '1', 'RadiopharmaceuticalInformationSequence'],
        '0x0017': ['IS', '1', 'ResidualSyringeCounts'],
        '0x0018': ['SH', '1', 'EnergyWindowName'],
        '0x0020': ['US', '1-n', 'DetectorVector'],
        '0x0021': ['US', '1', 'NumberOfDetectors'],
        '0x0022': ['SQ', '1', 'DetectorInformationSequence'],
        '0x0030': ['US', '1-n', 'PhaseVector'],
        '0x0031': ['US', '1', 'NumberOfPhases'],
        '0x0032': ['SQ', '1', 'PhaseInformationSequence'],
        '0x0033': ['US', '1', 'NumberOfFramesInPhase'],
        '0x0036': ['IS', '1', 'PhaseDelay'],
        '0x0038': ['IS', '1', 'PauseBetweenFrames'],
        '0x0039': ['CS', '1', 'PhaseDescription'],
        '0x0050': ['US', '1-n', 'RotationVector'],
        '0x0051': ['US', '1', 'NumberOfRotations'],
        '0x0052': ['SQ', '1', 'RotationInformationSequence'],
        '0x0053': ['US', '1', 'NumberOfFramesInRotation'],
        '0x0060': ['US', '1-n', 'RRIntervalVector'],
        '0x0061': ['US', '1', 'NumberOfRRIntervals'],
        '0x0062': ['SQ', '1', 'GatedInformationSequence'],
        '0x0063': ['SQ', '1', 'DataInformationSequence'],
        '0x0070': ['US', '1-n', 'TimeSlotVector'],
        '0x0071': ['US', '1', 'NumberOfTimeSlots'],
        '0x0072': ['SQ', '1', 'TimeSlotInformationSequence'],
        '0x0073': ['DS', '1', 'TimeSlotTime'],
        '0x0080': ['US', '1-n', 'SliceVector'],
        '0x0081': ['US', '1', 'NumberOfSlices'],
        '0x0090': ['US', '1-n', 'AngularViewVector'],
        '0x0100': ['US', '1-n', 'TimeSliceVector'],
        '0x0101': ['US', '1', 'NumberOfTimeSlices'],
        '0x0200': ['DS', '1', 'StartAngle'],
        '0x0202': ['CS', '1', 'TypeOfDetectorMotion'],
        '0x0210': ['IS', '1-n', 'TriggerVector'],
        '0x0211': ['US', '1', 'NumberOfTriggersInPhase'],
        '0x0220': ['SQ', '1', 'ViewCodeSequence'],
        '0x0222': ['SQ', '1', 'ViewModifierCodeSequence'],
        '0x0300': ['SQ', '1', 'RadionuclideCodeSequence'],
        '0x0302': ['SQ', '1', 'AdministrationRouteCodeSequence'],
        '0x0304': ['SQ', '1', 'RadiopharmaceuticalCodeSequence'],
        '0x0306': ['SQ', '1', 'CalibrationDataSequence'],
        '0x0308': ['US', '1', 'EnergyWindowNumber'],
        '0x0400': ['SH', '1', 'ImageID'],
        '0x0410': ['SQ', '1', 'PatientOrientationCodeSequence'],
        '0x0412': ['SQ', '1', 'PatientOrientationModifierCodeSequence'],
        '0x0414': ['SQ', '1', 'PatientGantryRelationshipCodeSequence'],
        '0x0500': ['CS', '1', 'SliceProgressionDirection'],
        '0x0501': ['CS', '1', 'ScanProgressionDirection'],
        '0x1000': ['CS', '2', 'SeriesType'],
        '0x1001': ['CS', '1', 'Units'],
        '0x1002': ['CS', '1', 'CountsSource'],
        '0x1004': ['CS', '1', 'ReprojectionMethod'],
        '0x1006': ['CS', '1', 'SUVType'],
        '0x1100': ['CS', '1', 'RandomsCorrectionMethod'],
        '0x1101': ['LO', '1', 'AttenuationCorrectionMethod'],
        '0x1102': ['CS', '1', 'DecayCorrection'],
        '0x1103': ['LO', '1', 'ReconstructionMethod'],
        '0x1104': ['LO', '1', 'DetectorLinesOfResponseUsed'],
        '0x1105': ['LO', '1', 'ScatterCorrectionMethod'],
        '0x1200': ['DS', '1', 'AxialAcceptance'],
        '0x1201': ['IS', '2', 'AxialMash'],
        '0x1202': ['IS', '1', 'TransverseMash'],
        '0x1203': ['DS', '2', 'DetectorElementSize'],
        '0x1210': ['DS', '1', 'CoincidenceWindowWidth'],
        '0x1220': ['CS', '1-n', 'SecondaryCountsType'],
        '0x1300': ['DS', '1', 'FrameReferenceTime'],
        '0x1310': ['IS', '1', 'PrimaryPromptsCountsAccumulated'],
        '0x1311': ['IS', '1-n', 'SecondaryCountsAccumulated'],
        '0x1320': ['DS', '1', 'SliceSensitivityFactor'],
        '0x1321': ['DS', '1', 'DecayFactor'],
        '0x1322': ['DS', '1', 'DoseCalibrationFactor'],
        '0x1323': ['DS', '1', 'ScatterFractionFactor'],
        '0x1324': ['DS', '1', 'DeadTimeFactor'],
        '0x1330': ['US', '1', 'ImageIndex'],
        '0x1400': ['CS', '1-n', 'CountsIncluded'],
        '0x1401': ['CS', '1', 'DeadTimeCorrectionFlag'],
    },
    '0x0060': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x3000': ['SQ', '1', 'HistogramSequence'],
        '0x3002': ['US', '1', 'HistogramNumberOfBins'],
        '0x3004': ['xs', '1', 'HistogramFirstBinValue'],
        '0x3006': ['xs', '1', 'HistogramLastBinValue'],
        '0x3008': ['US', '1', 'HistogramBinWidth'],
        '0x3010': ['LO', '1', 'HistogramExplanation'],
        '0x3020': ['UL', '1-n', 'HistogramData'],
    },
    '0x0062': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['CS', '1', 'SegmentationType'],
        '0x0002': ['SQ', '1', 'SegmentSequence'],
        '0x0003': ['SQ', '1', 'SegmentedPropertyCategoryCodeSequence'],
        '0x0004': ['US', '1', 'SegmentNumber'],
        '0x0005': ['LO', '1', 'SegmentLabel'],
        '0x0006': ['ST', '1', 'SegmentDescription'],
        '0x0008': ['CS', '1', 'SegmentAlgorithmType'],
        '0x0009': ['LO', '1', 'SegmentAlgorithmName'],
        '0x000A': ['SQ', '1', 'SegmentIdentificationSequence'],
        '0x000B': ['US', '1-n', 'ReferencedSegmentNumber'],
        '0x000C': ['US', '1', 'RecommendedDisplayGrayscaleValue'],
        '0x000D': ['US', '3', 'RecommendedDisplayCIELabValue'],
        '0x000E': ['US', '1', 'MaximumFractionalValue'],
        '0x000F': ['SQ', '1', 'SegmentedPropertyTypeCodeSequence'],
        '0x0010': ['CS', '1', 'SegmentationFractionalType'],
        '0x0011': ['SQ', '1', 'SegmentedPropertyTypeModifierCodeSequence'],
        '0x0012': ['SQ', '1', 'UsedSegmentsSequence'],
    },
    '0x0064': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['SQ', '1', 'DeformableRegistrationSequence'],
        '0x0003': ['UI', '1', 'SourceFrameOfReferenceUID'],
        '0x0005': ['SQ', '1', 'DeformableRegistrationGridSequence'],
        '0x0007': ['UL', '3', 'GridDimensions'],
        '0x0008': ['FD', '3', 'GridResolution'],
        '0x0009': ['OF', '1', 'VectorGridData'],
        '0x000F': ['SQ', '1', 'PreDeformationMatrixRegistrationSequence'],
        '0x0010': ['SQ', '1', 'PostDeformationMatrixRegistrationSequence'],
    },
    '0x0066': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['UL', '1', 'NumberOfSurfaces'],
        '0x0002': ['SQ', '1', 'SurfaceSequence'],
        '0x0003': ['UL', '1', 'SurfaceNumber'],
        '0x0004': ['LT', '1', 'SurfaceComments'],
        '0x0009': ['CS', '1', 'SurfaceProcessing'],
        '0x000A': ['FL', '1', 'SurfaceProcessingRatio'],
        '0x000B': ['LO', '1', 'SurfaceProcessingDescription'],
        '0x000C': ['FL', '1', 'RecommendedPresentationOpacity'],
        '0x000D': ['CS', '1', 'RecommendedPresentationType'],
        '0x000E': ['CS', '1', 'FiniteVolume'],
        '0x0010': ['CS', '1', 'Manifold'],
        '0x0011': ['SQ', '1', 'SurfacePointsSequence'],
        '0x0012': ['SQ', '1', 'SurfacePointsNormalsSequence'],
        '0x0013': ['SQ', '1', 'SurfaceMeshPrimitivesSequence'],
        '0x0015': ['UL', '1', 'NumberOfSurfacePoints'],
        '0x0016': ['OF', '1', 'PointCoordinatesData'],
        '0x0017': ['FL', '3', 'PointPositionAccuracy'],
        '0x0018': ['FL', '1', 'MeanPointDistance'],
        '0x0019': ['FL', '1', 'MaximumPointDistance'],
        '0x001A': ['FL', '6', 'PointsBoundingBoxCoordinates'],
        '0x001B': ['FL', '3', 'AxisOfRotation'],
        '0x001C': ['FL', '3', 'CenterOfRotation'],
        '0x001E': ['UL', '1', 'NumberOfVectors'],
        '0x001F': ['US', '1', 'VectorDimensionality'],
        '0x0020': ['FL', '1-n', 'VectorAccuracy'],
        '0x0021': ['OF', '1', 'VectorCoordinateData'],
        '0x0023': ['OW', '1', 'TrianglePointIndexList'],
        '0x0024': ['OW', '1', 'EdgePointIndexList'],
        '0x0025': ['OW', '1', 'VertexPointIndexList'],
        '0x0026': ['SQ', '1', 'TriangleStripSequence'],
        '0x0027': ['SQ', '1', 'TriangleFanSequence'],
        '0x0028': ['SQ', '1', 'LineSequence'],
        '0x0029': ['OW', '1', 'PrimitivePointIndexList'],
        '0x002A': ['UL', '1', 'SurfaceCount'],
        '0x002B': ['SQ', '1', 'ReferencedSurfaceSequence'],
        '0x002C': ['UL', '1', 'ReferencedSurfaceNumber'],
        '0x002D': ['SQ', '1', 'SegmentSurfaceGenerationAlgorithmIdentificationSequence'],
        '0x002E': ['SQ', '1', 'SegmentSurfaceSourceInstanceSequence'],
        '0x002F': ['SQ', '1', 'AlgorithmFamilyCodeSequence'],
        '0x0030': ['SQ', '1', 'AlgorithmNameCodeSequence'],
        '0x0031': ['LO', '1', 'AlgorithmVersion'],
        '0x0032': ['LT', '1', 'AlgorithmParameters'],
        '0x0034': ['SQ', '1', 'FacetSequence'],
        '0x0035': ['SQ', '1', 'SurfaceProcessingAlgorithmIdentificationSequence'],
        '0x0036': ['LO', '1', 'AlgorithmName'],
        '0x0037': ['FL', '1', 'RecommendedPointRadius'],
        '0x0038': ['FL', '1', 'RecommendedLineThickness'],
        '0x0040': ['UL', '1-n', 'LongPrimitivePointIndexList'],
        '0x0041': ['UL', '3-3n', 'LongTrianglePointIndexList'],
        '0x0042': ['UL', '2-2n', 'LongEdgePointIndexList'],
        '0x0043': ['UL', '1-n', 'LongVertexPointIndexList'],
    },
    '0x0068': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x6210': ['LO', '1', 'ImplantSize'],
        '0x6221': ['LO', '1', 'ImplantTemplateVersion'],
        '0x6222': ['SQ', '1', 'ReplacedImplantTemplateSequence'],
        '0x6223': ['CS', '1', 'ImplantType'],
        '0x6224': ['SQ', '1', 'DerivationImplantTemplateSequence'],
        '0x6225': ['SQ', '1', 'OriginalImplantTemplateSequence'],
        '0x6226': ['DT', '1', 'EffectiveDateTime'],
        '0x6230': ['SQ', '1', 'ImplantTargetAnatomySequence'],
        '0x6260': ['SQ', '1', 'InformationFromManufacturerSequence'],
        '0x6265': ['SQ', '1', 'NotificationFromManufacturerSequence'],
        '0x6270': ['DT', '1', 'InformationIssueDateTime'],
        '0x6280': ['ST', '1', 'InformationSummary'],
        '0x62A0': ['SQ', '1', 'ImplantRegulatoryDisapprovalCodeSequence'],
        '0x62A5': ['FD', '1', 'OverallTemplateSpatialTolerance'],
        '0x62C0': ['SQ', '1', 'HPGLDocumentSequence'],
        '0x62D0': ['US', '1', 'HPGLDocumentID'],
        '0x62D5': ['LO', '1', 'HPGLDocumentLabel'],
        '0x62E0': ['SQ', '1', 'ViewOrientationCodeSequence'],
        '0x62F0': ['FD', '9', 'ViewOrientationModifier'],
        '0x62F2': ['FD', '1', 'HPGLDocumentScaling'],
        '0x6300': ['OB', '1', 'HPGLDocument'],
        '0x6310': ['US', '1', 'HPGLContourPenNumber'],
        '0x6320': ['SQ', '1', 'HPGLPenSequence'],
        '0x6330': ['US', '1', 'HPGLPenNumber'],
        '0x6340': ['LO', '1', 'HPGLPenLabel'],
        '0x6345': ['ST', '1', 'HPGLPenDescription'],
        '0x6346': ['FD', '2', 'RecommendedRotationPoint'],
        '0x6347': ['FD', '4', 'BoundingRectangle'],
        '0x6350': ['US', '1-n', 'ImplantTemplate3DModelSurfaceNumber'],
        '0x6360': ['SQ', '1', 'SurfaceModelDescriptionSequence'],
        '0x6380': ['LO', '1', 'SurfaceModelLabel'],
        '0x6390': ['FD', '1', 'SurfaceModelScalingFactor'],
        '0x63A0': ['SQ', '1', 'MaterialsCodeSequence'],
        '0x63A4': ['SQ', '1', 'CoatingMaterialsCodeSequence'],
        '0x63A8': ['SQ', '1', 'ImplantTypeCodeSequence'],
        '0x63AC': ['SQ', '1', 'FixationMethodCodeSequence'],
        '0x63B0': ['SQ', '1', 'MatingFeatureSetsSequence'],
        '0x63C0': ['US', '1', 'MatingFeatureSetID'],
        '0x63D0': ['LO', '1', 'MatingFeatureSetLabel'],
        '0x63E0': ['SQ', '1', 'MatingFeatureSequence'],
        '0x63F0': ['US', '1', 'MatingFeatureID'],
        '0x6400': ['SQ', '1', 'MatingFeatureDegreeOfFreedomSequence'],
        '0x6410': ['US', '1', 'DegreeOfFreedomID'],
        '0x6420': ['CS', '1', 'DegreeOfFreedomType'],
        '0x6430': ['SQ', '1', 'TwoDMatingFeatureCoordinatesSequence'],
        '0x6440': ['US', '1', 'ReferencedHPGLDocumentID'],
        '0x6450': ['FD', '2', 'TwoDMatingPoint'],
        '0x6460': ['FD', '4', 'TwoDMatingAxes'],
        '0x6470': ['SQ', '1', 'TwoDDegreeOfFreedomSequence'],
        '0x6490': ['FD', '3', 'ThreeDDegreeOfFreedomAxis'],
        '0x64A0': ['FD', '2', 'RangeOfFreedom'],
        '0x64C0': ['FD', '3', 'ThreeDMatingPoint'],
        '0x64D0': ['FD', '9', 'ThreeDMatingAxes'],
        '0x64F0': ['FD', '3', 'TwoDDegreeOfFreedomAxis'],
        '0x6500': ['SQ', '1', 'PlanningLandmarkPointSequence'],
        '0x6510': ['SQ', '1', 'PlanningLandmarkLineSequence'],
        '0x6520': ['SQ', '1', 'PlanningLandmarkPlaneSequence'],
        '0x6530': ['US', '1', 'PlanningLandmarkID'],
        '0x6540': ['LO', '1', 'PlanningLandmarkDescription'],
        '0x6545': ['SQ', '1', 'PlanningLandmarkIdentificationCodeSequence'],
        '0x6550': ['SQ', '1', 'TwoDPointCoordinatesSequence'],
        '0x6560': ['FD', '2', 'TwoDPointCoordinates'],
        '0x6590': ['FD', '3', 'ThreeDPointCoordinates'],
        '0x65A0': ['SQ', '1', 'TwoDLineCoordinatesSequence'],
        '0x65B0': ['FD', '4', 'TwoDLineCoordinates'],
        '0x65D0': ['FD', '6', 'ThreeDLineCoordinates'],
        '0x65E0': ['SQ', '1', 'TwoDPlaneCoordinatesSequence'],
        '0x65F0': ['FD', '4', 'TwoDPlaneIntersection'],
        '0x6610': ['FD', '3', 'ThreeDPlaneOrigin'],
        '0x6620': ['FD', '3', 'ThreeDPlaneNormal'],
    },
    '0x0070': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['SQ', '1', 'GraphicAnnotationSequence'],
        '0x0002': ['CS', '1', 'GraphicLayer'],
        '0x0003': ['CS', '1', 'BoundingBoxAnnotationUnits'],
        '0x0004': ['CS', '1', 'AnchorPointAnnotationUnits'],
        '0x0005': ['CS', '1', 'GraphicAnnotationUnits'],
        '0x0006': ['ST', '1', 'UnformattedTextValue'],
        '0x0008': ['SQ', '1', 'TextObjectSequence'],
        '0x0009': ['SQ', '1', 'GraphicObjectSequence'],
        '0x0010': ['FL', '2', 'BoundingBoxTopLeftHandCorner'],
        '0x0011': ['FL', '2', 'BoundingBoxBottomRightHandCorner'],
        '0x0012': ['CS', '1', 'BoundingBoxTextHorizontalJustification'],
        '0x0014': ['FL', '2', 'AnchorPoint'],
        '0x0015': ['CS', '1', 'AnchorPointVisibility'],
        '0x0020': ['US', '1', 'GraphicDimensions'],
        '0x0021': ['US', '1', 'NumberOfGraphicPoints'],
        '0x0022': ['FL', '2-n', 'GraphicData'],
        '0x0023': ['CS', '1', 'GraphicType'],
        '0x0024': ['CS', '1', 'GraphicFilled'],
        '0x0040': ['IS', '1', 'ImageRotationRetired'],
        '0x0041': ['CS', '1', 'ImageHorizontalFlip'],
        '0x0042': ['US', '1', 'ImageRotation'],
        '0x0050': ['US', '2', 'DisplayedAreaTopLeftHandCornerTrial'],
        '0x0051': ['US', '2', 'DisplayedAreaBottomRightHandCornerTrial'],
        '0x0052': ['SL', '2', 'DisplayedAreaTopLeftHandCorner'],
        '0x0053': ['SL', '2', 'DisplayedAreaBottomRightHandCorner'],
        '0x005A': ['SQ', '1', 'DisplayedAreaSelectionSequence'],
        '0x0060': ['SQ', '1', 'GraphicLayerSequence'],
        '0x0062': ['IS', '1', 'GraphicLayerOrder'],
        '0x0066': ['US', '1', 'GraphicLayerRecommendedDisplayGrayscaleValue'],
        '0x0067': ['US', '3', 'GraphicLayerRecommendedDisplayRGBValue'],
        '0x0068': ['LO', '1', 'GraphicLayerDescription'],
        '0x0080': ['CS', '1', 'ContentLabel'],
        '0x0081': ['LO', '1', 'ContentDescription'],
        '0x0082': ['DA', '1', 'PresentationCreationDate'],
        '0x0083': ['TM', '1', 'PresentationCreationTime'],
        '0x0084': ['PN', '1', 'ContentCreatorName'],
        '0x0086': ['SQ', '1', 'ContentCreatorIdentificationCodeSequence'],
        '0x0087': ['SQ', '1', 'AlternateContentDescriptionSequence'],
        '0x0100': ['CS', '1', 'PresentationSizeMode'],
        '0x0101': ['DS', '2', 'PresentationPixelSpacing'],
        '0x0102': ['IS', '2', 'PresentationPixelAspectRatio'],
        '0x0103': ['FL', '1', 'PresentationPixelMagnificationRatio'],
        '0x0207': ['LO', '1', 'GraphicGroupLabel'],
        '0x0208': ['ST', '1', 'GraphicGroupDescription'],
        '0x0209': ['SQ', '1', 'CompoundGraphicSequence'],
        '0x0226': ['UL', '1', 'CompoundGraphicInstanceID'],
        '0x0227': ['LO', '1', 'FontName'],
        '0x0228': ['CS', '1', 'FontNameType'],
        '0x0229': ['LO', '1', 'CSSFontName'],
        '0x0230': ['FD', '1', 'RotationAngle'],
        '0x0231': ['SQ', '1', 'TextStyleSequence'],
        '0x0232': ['SQ', '1', 'LineStyleSequence'],
        '0x0233': ['SQ', '1', 'FillStyleSequence'],
        '0x0234': ['SQ', '1', 'GraphicGroupSequence'],
        '0x0241': ['US', '3', 'TextColorCIELabValue'],
        '0x0242': ['CS', '1', 'HorizontalAlignment'],
        '0x0243': ['CS', '1', 'VerticalAlignment'],
        '0x0244': ['CS', '1', 'ShadowStyle'],
        '0x0245': ['FL', '1', 'ShadowOffsetX'],
        '0x0246': ['FL', '1', 'ShadowOffsetY'],
        '0x0247': ['US', '3', 'ShadowColorCIELabValue'],
        '0x0248': ['CS', '1', 'Underlined'],
        '0x0249': ['CS', '1', 'Bold'],
        '0x0250': ['CS', '1', 'Italic'],
        '0x0251': ['US', '3', 'PatternOnColorCIELabValue'],
        '0x0252': ['US', '3', 'PatternOffColorCIELabValue'],
        '0x0253': ['FL', '1', 'LineThickness'],
        '0x0254': ['CS', '1', 'LineDashingStyle'],
        '0x0255': ['UL', '1', 'LinePattern'],
        '0x0256': ['OB', '1', 'FillPattern'],
        '0x0257': ['CS', '1', 'FillMode'],
        '0x0258': ['FL', '1', 'ShadowOpacity'],
        '0x0261': ['FL', '1', 'GapLength'],
        '0x0262': ['FL', '1', 'DiameterOfVisibility'],
        '0x0273': ['FL', '2', 'RotationPoint'],
        '0x0274': ['CS', '1', 'TickAlignment'],
        '0x0278': ['CS', '1', 'ShowTickLabel'],
        '0x0279': ['CS', '1', 'TickLabelAlignment'],
        '0x0282': ['CS', '1', 'CompoundGraphicUnits'],
        '0x0284': ['FL', '1', 'PatternOnOpacity'],
        '0x0285': ['FL', '1', 'PatternOffOpacity'],
        '0x0287': ['SQ', '1', 'MajorTicksSequence'],
        '0x0288': ['FL', '1', 'TickPosition'],
        '0x0289': ['SH', '1', 'TickLabel'],
        '0x0294': ['CS', '1', 'CompoundGraphicType'],
        '0x0295': ['UL', '1', 'GraphicGroupID'],
        '0x0306': ['CS', '1', 'ShapeType'],
        '0x0308': ['SQ', '1', 'RegistrationSequence'],
        '0x0309': ['SQ', '1', 'MatrixRegistrationSequence'],
        '0x030A': ['SQ', '1', 'MatrixSequence'],
        '0x030C': ['CS', '1', 'FrameOfReferenceTransformationMatrixType'],
        '0x030D': ['SQ', '1', 'RegistrationTypeCodeSequence'],
        '0x030F': ['ST', '1', 'FiducialDescription'],
        '0x0310': ['SH', '1', 'FiducialIdentifier'],
        '0x0311': ['SQ', '1', 'FiducialIdentifierCodeSequence'],
        '0x0312': ['FD', '1', 'ContourUncertaintyRadius'],
        '0x0314': ['SQ', '1', 'UsedFiducialsSequence'],
        '0x0318': ['SQ', '1', 'GraphicCoordinatesDataSequence'],
        '0x031A': ['UI', '1', 'FiducialUID'],
        '0x031C': ['SQ', '1', 'FiducialSetSequence'],
        '0x031E': ['SQ', '1', 'FiducialSequence'],
        '0x0401': ['US', '3', 'GraphicLayerRecommendedDisplayCIELabValue'],
        '0x0402': ['SQ', '1', 'BlendingSequence'],
        '0x0403': ['FL', '1', 'RelativeOpacity'],
        '0x0404': ['SQ', '1', 'ReferencedSpatialRegistrationSequence'],
        '0x0405': ['CS', '1', 'BlendingPosition'],
    },
    '0x0072': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['SH', '1', 'HangingProtocolName'],
        '0x0004': ['LO', '1', 'HangingProtocolDescription'],
        '0x0006': ['CS', '1', 'HangingProtocolLevel'],
        '0x0008': ['LO', '1', 'HangingProtocolCreator'],
        '0x000A': ['DT', '1', 'HangingProtocolCreationDateTime'],
        '0x000C': ['SQ', '1', 'HangingProtocolDefinitionSequence'],
        '0x000E': ['SQ', '1', 'HangingProtocolUserIdentificationCodeSequence'],
        '0x0010': ['LO', '1', 'HangingProtocolUserGroupName'],
        '0x0012': ['SQ', '1', 'SourceHangingProtocolSequence'],
        '0x0014': ['US', '1', 'NumberOfPriorsReferenced'],
        '0x0020': ['SQ', '1', 'ImageSetsSequence'],
        '0x0022': ['SQ', '1', 'ImageSetSelectorSequence'],
        '0x0024': ['CS', '1', 'ImageSetSelectorUsageFlag'],
        '0x0026': ['AT', '1', 'SelectorAttribute'],
        '0x0028': ['US', '1', 'SelectorValueNumber'],
        '0x0030': ['SQ', '1', 'TimeBasedImageSetsSequence'],
        '0x0032': ['US', '1', 'ImageSetNumber'],
        '0x0034': ['CS', '1', 'ImageSetSelectorCategory'],
        '0x0038': ['US', '2', 'RelativeTime'],
        '0x003A': ['CS', '1', 'RelativeTimeUnits'],
        '0x003C': ['SS', '2', 'AbstractPriorValue'],
        '0x003E': ['SQ', '1', 'AbstractPriorCodeSequence'],
        '0x0040': ['LO', '1', 'ImageSetLabel'],
        '0x0050': ['CS', '1', 'SelectorAttributeVR'],
        '0x0052': ['AT', '1-n', 'SelectorSequencePointer'],
        '0x0054': ['LO', '1-n', 'SelectorSequencePointerPrivateCreator'],
        '0x0056': ['LO', '1', 'SelectorAttributePrivateCreator'],
        '0x0060': ['AT', '1-n', 'SelectorATValue'],
        '0x0062': ['CS', '1-n', 'SelectorCSValue'],
        '0x0064': ['IS', '1-n', 'SelectorISValue'],
        '0x0066': ['LO', '1-n', 'SelectorLOValue'],
        '0x0068': ['LT', '1', 'SelectorLTValue'],
        '0x006A': ['PN', '1-n', 'SelectorPNValue'],
        '0x006C': ['SH', '1-n', 'SelectorSHValue'],
        '0x006E': ['ST', '1', 'SelectorSTValue'],
        '0x0070': ['UT', '1', 'SelectorUTValue'],
        '0x0072': ['DS', '1-n', 'SelectorDSValue'],
        '0x0074': ['FD', '1-n', 'SelectorFDValue'],
        '0x0076': ['FL', '1-n', 'SelectorFLValue'],
        '0x0078': ['UL', '1-n', 'SelectorULValue'],
        '0x007A': ['US', '1-n', 'SelectorUSValue'],
        '0x007C': ['SL', '1-n', 'SelectorSLValue'],
        '0x007E': ['SS', '1-n', 'SelectorSSValue'],
        '0x007F': ['UI', '1-n', 'SelectorUIValue'],
        '0x0080': ['SQ', '1', 'SelectorCodeSequenceValue'],
        '0x0100': ['US', '1', 'NumberOfScreens'],
        '0x0102': ['SQ', '1', 'NominalScreenDefinitionSequence'],
        '0x0104': ['US', '1', 'NumberOfVerticalPixels'],
        '0x0106': ['US', '1', 'NumberOfHorizontalPixels'],
        '0x0108': ['FD', '4', 'DisplayEnvironmentSpatialPosition'],
        '0x010A': ['US', '1', 'ScreenMinimumGrayscaleBitDepth'],
        '0x010C': ['US', '1', 'ScreenMinimumColorBitDepth'],
        '0x010E': ['US', '1', 'ApplicationMaximumRepaintTime'],
        '0x0200': ['SQ', '1', 'DisplaySetsSequence'],
        '0x0202': ['US', '1', 'DisplaySetNumber'],
        '0x0203': ['LO', '1', 'DisplaySetLabel'],
        '0x0204': ['US', '1', 'DisplaySetPresentationGroup'],
        '0x0206': ['LO', '1', 'DisplaySetPresentationGroupDescription'],
        '0x0208': ['CS', '1', 'PartialDataDisplayHandling'],
        '0x0210': ['SQ', '1', 'SynchronizedScrollingSequence'],
        '0x0212': ['US', '2-n', 'DisplaySetScrollingGroup'],
        '0x0214': ['SQ', '1', 'NavigationIndicatorSequence'],
        '0x0216': ['US', '1', 'NavigationDisplaySet'],
        '0x0218': ['US', '1-n', 'ReferenceDisplaySets'],
        '0x0300': ['SQ', '1', 'ImageBoxesSequence'],
        '0x0302': ['US', '1', 'ImageBoxNumber'],
        '0x0304': ['CS', '1', 'ImageBoxLayoutType'],
        '0x0306': ['US', '1', 'ImageBoxTileHorizontalDimension'],
        '0x0308': ['US', '1', 'ImageBoxTileVerticalDimension'],
        '0x0310': ['CS', '1', 'ImageBoxScrollDirection'],
        '0x0312': ['CS', '1', 'ImageBoxSmallScrollType'],
        '0x0314': ['US', '1', 'ImageBoxSmallScrollAmount'],
        '0x0316': ['CS', '1', 'ImageBoxLargeScrollType'],
        '0x0318': ['US', '1', 'ImageBoxLargeScrollAmount'],
        '0x0320': ['US', '1', 'ImageBoxOverlapPriority'],
        '0x0330': ['FD', '1', 'CineRelativeToRealTime'],
        '0x0400': ['SQ', '1', 'FilterOperationsSequence'],
        '0x0402': ['CS', '1', 'FilterByCategory'],
        '0x0404': ['CS', '1', 'FilterByAttributePresence'],
        '0x0406': ['CS', '1', 'FilterByOperator'],
        '0x0420': ['US', '3', 'StructuredDisplayBackgroundCIELabValue'],
        '0x0421': ['US', '3', 'EmptyImageBoxCIELabValue'],
        '0x0422': ['SQ', '1', 'StructuredDisplayImageBoxSequence'],
        '0x0424': ['SQ', '1', 'StructuredDisplayTextBoxSequence'],
        '0x0427': ['SQ', '1', 'ReferencedFirstFrameSequence'],
        '0x0430': ['SQ', '1', 'ImageBoxSynchronizationSequence'],
        '0x0432': ['US', '2-n', 'SynchronizedImageBoxList'],
        '0x0434': ['CS', '1', 'TypeOfSynchronization'],
        '0x0500': ['CS', '1', 'BlendingOperationType'],
        '0x0510': ['CS', '1', 'ReformattingOperationType'],
        '0x0512': ['FD', '1', 'ReformattingThickness'],
        '0x0514': ['FD', '1', 'ReformattingInterval'],
        '0x0516': ['CS', '1', 'ReformattingOperationInitialViewDirection'],
        '0x0520': ['CS', '1-n', 'ThreeDRenderingType'],
        '0x0600': ['SQ', '1', 'SortingOperationsSequence'],
        '0x0602': ['CS', '1', 'SortByCategory'],
        '0x0604': ['CS', '1', 'SortingDirection'],
        '0x0700': ['CS', '2', 'DisplaySetPatientOrientation'],
        '0x0702': ['CS', '1', 'VOIType'],
        '0x0704': ['CS', '1', 'PseudoColorType'],
        '0x0705': ['SQ', '1', 'PseudoColorPaletteInstanceReferenceSequence'],
        '0x0706': ['CS', '1', 'ShowGrayscaleInverted'],
        '0x0710': ['CS', '1', 'ShowImageTrueSizeFlag'],
        '0x0712': ['CS', '1', 'ShowGraphicAnnotationFlag'],
        '0x0714': ['CS', '1', 'ShowPatientDemographicsFlag'],
        '0x0716': ['CS', '1', 'ShowAcquisitionTechniquesFlag'],
        '0x0717': ['CS', '1', 'DisplaySetHorizontalJustification'],
        '0x0718': ['CS', '1', 'DisplaySetVerticalJustification'],
    },
    '0x0074': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0120': ['FD', '1', 'ContinuationStartMeterset'],
        '0x0121': ['FD', '1', 'ContinuationEndMeterset'],
        '0x1000': ['CS', '1', 'ProcedureStepState'],
        '0x1002': ['SQ', '1', 'ProcedureStepProgressInformationSequence'],
        '0x1004': ['DS', '1', 'ProcedureStepProgress'],
        '0x1006': ['ST', '1', 'ProcedureStepProgressDescription'],
        '0x1008': ['SQ', '1', 'ProcedureStepCommunicationsURISequence'],
        '0x100A': ['UR', '1', 'ContactURI'],
        '0x100C': ['LO', '1', 'ContactDisplayName'],
        '0x100E': ['SQ', '1', 'ProcedureStepDiscontinuationReasonCodeSequence'],
        '0x1020': ['SQ', '1', 'BeamTaskSequence'],
        '0x1022': ['CS', '1', 'BeamTaskType'],
        '0x1024': ['IS', '1', 'BeamOrderIndexTrial'],
        '0x1025': ['CS', '1', 'AutosequenceFlag'],
        '0x1026': ['FD', '1', 'TableTopVerticalAdjustedPosition'],
        '0x1027': ['FD', '1', 'TableTopLongitudinalAdjustedPosition'],
        '0x1028': ['FD', '1', 'TableTopLateralAdjustedPosition'],
        '0x102A': ['FD', '1', 'PatientSupportAdjustedAngle'],
        '0x102B': ['FD', '1', 'TableTopEccentricAdjustedAngle'],
        '0x102C': ['FD', '1', 'TableTopPitchAdjustedAngle'],
        '0x102D': ['FD', '1', 'TableTopRollAdjustedAngle'],
        '0x1030': ['SQ', '1', 'DeliveryVerificationImageSequence'],
        '0x1032': ['CS', '1', 'VerificationImageTiming'],
        '0x1034': ['CS', '1', 'DoubleExposureFlag'],
        '0x1036': ['CS', '1', 'DoubleExposureOrdering'],
        '0x1038': ['DS', '1', 'DoubleExposureMetersetTrial'],
        '0x103A': ['DS', '4', 'DoubleExposureFieldDeltaTrial'],
        '0x1040': ['SQ', '1', 'RelatedReferenceRTImageSequence'],
        '0x1042': ['SQ', '1', 'GeneralMachineVerificationSequence'],
        '0x1044': ['SQ', '1', 'ConventionalMachineVerificationSequence'],
        '0x1046': ['SQ', '1', 'IonMachineVerificationSequence'],
        '0x1048': ['SQ', '1', 'FailedAttributesSequence'],
        '0x104A': ['SQ', '1', 'OverriddenAttributesSequence'],
        '0x104C': ['SQ', '1', 'ConventionalControlPointVerificationSequence'],
        '0x104E': ['SQ', '1', 'IonControlPointVerificationSequence'],
        '0x1050': ['SQ', '1', 'AttributeOccurrenceSequence'],
        '0x1052': ['AT', '1', 'AttributeOccurrencePointer'],
        '0x1054': ['UL', '1', 'AttributeItemSelector'],
        '0x1056': ['LO', '1', 'AttributeOccurrencePrivateCreator'],
        '0x1057': ['IS', '1-n', 'SelectorSequencePointerItems'],
        '0x1200': ['CS', '1', 'ScheduledProcedureStepPriority'],
        '0x1202': ['LO', '1', 'WorklistLabel'],
        '0x1204': ['LO', '1', 'ProcedureStepLabel'],
        '0x1210': ['SQ', '1', 'ScheduledProcessingParametersSequence'],
        '0x1212': ['SQ', '1', 'PerformedProcessingParametersSequence'],
        '0x1216': ['SQ', '1', 'UnifiedProcedureStepPerformedProcedureSequence'],
        '0x1220': ['SQ', '1', 'RelatedProcedureStepSequence'],
        '0x1222': ['LO', '1', 'ProcedureStepRelationshipType'],
        '0x1224': ['SQ', '1', 'ReplacedProcedureStepSequence'],
        '0x1230': ['LO', '1', 'DeletionLock'],
        '0x1234': ['AE', '1', 'ReceivingAE'],
        '0x1236': ['AE', '1', 'RequestingAE'],
        '0x1238': ['LT', '1', 'ReasonForCancellation'],
        '0x1242': ['CS', '1', 'SCPStatus'],
        '0x1244': ['CS', '1', 'SubscriptionListStatus'],
        '0x1246': ['CS', '1', 'UnifiedProcedureStepListStatus'],
        '0x1324': ['UL', '1', 'BeamOrderIndex'],
        '0x1338': ['FD', '1', 'DoubleExposureMeterset'],
        '0x133A': ['FD', '4', 'DoubleExposureFieldDelta'],
    },
    '0x0076': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['LO', '1', 'ImplantAssemblyTemplateName'],
        '0x0003': ['LO', '1', 'ImplantAssemblyTemplateIssuer'],
        '0x0006': ['LO', '1', 'ImplantAssemblyTemplateVersion'],
        '0x0008': ['SQ', '1', 'ReplacedImplantAssemblyTemplateSequence'],
        '0x000A': ['CS', '1', 'ImplantAssemblyTemplateType'],
        '0x000C': ['SQ', '1', 'OriginalImplantAssemblyTemplateSequence'],
        '0x000E': ['SQ', '1', 'DerivationImplantAssemblyTemplateSequence'],
        '0x0010': ['SQ', '1', 'ImplantAssemblyTemplateTargetAnatomySequence'],
        '0x0020': ['SQ', '1', 'ProcedureTypeCodeSequence'],
        '0x0030': ['LO', '1', 'SurgicalTechnique'],
        '0x0032': ['SQ', '1', 'ComponentTypesSequence'],
        '0x0034': ['CS', '1', 'ComponentTypeCodeSequence'],
        '0x0036': ['CS', '1', 'ExclusiveComponentType'],
        '0x0038': ['CS', '1', 'MandatoryComponentType'],
        '0x0040': ['SQ', '1', 'ComponentSequence'],
        '0x0055': ['US', '1', 'ComponentID'],
        '0x0060': ['SQ', '1', 'ComponentAssemblySequence'],
        '0x0070': ['US', '1', 'Component1ReferencedID'],
        '0x0080': ['US', '1', 'Component1ReferencedMatingFeatureSetID'],
        '0x0090': ['US', '1', 'Component1ReferencedMatingFeatureID'],
        '0x00A0': ['US', '1', 'Component2ReferencedID'],
        '0x00B0': ['US', '1', 'Component2ReferencedMatingFeatureSetID'],
        '0x00C0': ['US', '1', 'Component2ReferencedMatingFeatureID'],
    },
    '0x0078': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['LO', '1', 'ImplantTemplateGroupName'],
        '0x0010': ['ST', '1', 'ImplantTemplateGroupDescription'],
        '0x0020': ['LO', '1', 'ImplantTemplateGroupIssuer'],
        '0x0024': ['LO', '1', 'ImplantTemplateGroupVersion'],
        '0x0026': ['SQ', '1', 'ReplacedImplantTemplateGroupSequence'],
        '0x0028': ['SQ', '1', 'ImplantTemplateGroupTargetAnatomySequence'],
        '0x002A': ['SQ', '1', 'ImplantTemplateGroupMembersSequence'],
        '0x002E': ['US', '1', 'ImplantTemplateGroupMemberID'],
        '0x0050': ['FD', '3', 'ThreeDImplantTemplateGroupMemberMatchingPoint'],
        '0x0060': ['FD', '9', 'ThreeDImplantTemplateGroupMemberMatchingAxes'],
        '0x0070': ['SQ', '1', 'ImplantTemplateGroupMemberMatching2DCoordinatesSequence'],
        '0x0090': ['FD', '2', 'TwoDImplantTemplateGroupMemberMatchingPoint'],
        '0x00A0': ['FD', '4', 'TwoDImplantTemplateGroupMemberMatchingAxes'],
        '0x00B0': ['SQ', '1', 'ImplantTemplateGroupVariationDimensionSequence'],
        '0x00B2': ['LO', '1', 'ImplantTemplateGroupVariationDimensionName'],
        '0x00B4': ['SQ', '1', 'ImplantTemplateGroupVariationDimensionRankSequence'],
        '0x00B6': ['US', '1', 'ReferencedImplantTemplateGroupMemberID'],
        '0x00B8': ['US', '1', 'ImplantTemplateGroupVariationDimensionRank'],
    },
    '0x0080': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['SQ', '1', 'SurfaceScanAcquisitionTypeCodeSequence'],
        '0x0002': ['SQ', '1', 'SurfaceScanModeCodeSequence'],
        '0x0003': ['SQ', '1', 'RegistrationMethodCodeSequence'],
        '0x0004': ['FD', '1', 'ShotDurationTime'],
        '0x0005': ['FD', '1', 'ShotOffsetTime'],
        '0x0006': ['US', '1-n', 'SurfacePointPresentationValueData'],
        '0x0007': ['US', '3-3n', 'SurfacePointColorCIELabValueData'],
        '0x0008': ['SQ', '1', 'UVMappingSequence'],
        '0x0009': ['SH', '1', 'TextureLabel'],
        '0x0010': ['OF', '1-n', 'UValueData'],
        '0x0011': ['OF', '1-n', 'VValueData'],
        '0x0012': ['SQ', '1', 'ReferencedTextureSequence'],
        '0x0013': ['SQ', '1', 'ReferencedSurfaceDataSequence'],
    },
    '0x0088': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0130': ['SH', '1', 'StorageMediaFileSetID'],
        '0x0140': ['UI', '1', 'StorageMediaFileSetUID'],
        '0x0200': ['SQ', '1', 'IconImageSequence'],
        '0x0904': ['LO', '1', 'TopicTitle'],
        '0x0906': ['ST', '1', 'TopicSubject'],
        '0x0910': ['LO', '1', 'TopicAuthor'],
        '0x0912': ['LO', '1-32', 'TopicKeywords'],
    },
    '0x0100': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0410': ['CS', '1', 'SOPInstanceStatus'],
        '0x0420': ['DT', '1', 'SOPAuthorizationDateTime'],
        '0x0424': ['LT', '1', 'SOPAuthorizationComment'],
        '0x0426': ['LO', '1', 'AuthorizationEquipmentCertificationNumber'],
    },
    '0x0400': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0005': ['US', '1', 'MACIDNumber'],
        '0x0010': ['UI', '1', 'MACCalculationTransferSyntaxUID'],
        '0x0015': ['CS', '1', 'MACAlgorithm'],
        '0x0020': ['AT', '1-n', 'DataElementsSigned'],
        '0x0100': ['UI', '1', 'DigitalSignatureUID'],
        '0x0105': ['DT', '1', 'DigitalSignatureDateTime'],
        '0x0110': ['CS', '1', 'CertificateType'],
        '0x0115': ['OB', '1', 'CertificateOfSigner'],
        '0x0120': ['OB', '1', 'Signature'],
        '0x0305': ['CS', '1', 'CertifiedTimestampType'],
        '0x0310': ['OB', '1', 'CertifiedTimestamp'],
        '0x0401': ['SQ', '1', 'DigitalSignaturePurposeCodeSequence'],
        '0x0402': ['SQ', '1', 'ReferencedDigitalSignatureSequence'],
        '0x0403': ['SQ', '1', 'ReferencedSOPInstanceMACSequence'],
        '0x0404': ['OB', '1', 'MAC'],
        '0x0500': ['SQ', '1', 'EncryptedAttributesSequence'],
        '0x0510': ['UI', '1', 'EncryptedContentTransferSyntaxUID'],
        '0x0520': ['OB', '1', 'EncryptedContent'],
        '0x0550': ['SQ', '1', 'ModifiedAttributesSequence'],
        '0x0561': ['SQ', '1', 'OriginalAttributesSequence'],
        '0x0562': ['DT', '1', 'AttributeModificationDateTime'],
        '0x0563': ['LO', '1', 'ModifyingSystem'],
        '0x0564': ['LO', '1', 'SourceOfPreviousValues'],
        '0x0565': ['CS', '1', 'ReasonForTheAttributeModification'],
    },
    '0x1000': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['US', '3', 'EscapeTriplet'],
        '0x0011': ['US', '3', 'RunLengthTriplet'],
        '0x0012': ['US', '1', 'HuffmanTableSize'],
        '0x0013': ['US', '3', 'HuffmanTableTriplet'],
        '0x0014': ['US', '1', 'ShiftTableSize'],
        '0x0015': ['US', '3', 'ShiftTableTriplet'],
    },
    '0x1010': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0004': ['US', '1-n', 'ZonalMap'],
    },
    '0x2000': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['IS', '1', 'NumberOfCopies'],
        '0x001E': ['SQ', '1', 'PrinterConfigurationSequence'],
        '0x0020': ['CS', '1', 'PrintPriority'],
        '0x0030': ['CS', '1', 'MediumType'],
        '0x0040': ['CS', '1', 'FilmDestination'],
        '0x0050': ['LO', '1', 'FilmSessionLabel'],
        '0x0060': ['IS', '1', 'MemoryAllocation'],
        '0x0061': ['IS', '1', 'MaximumMemoryAllocation'],
        '0x0062': ['CS', '1', 'ColorImagePrintingFlag'],
        '0x0063': ['CS', '1', 'CollationFlag'],
        '0x0065': ['CS', '1', 'AnnotationFlag'],
        '0x0067': ['CS', '1', 'ImageOverlayFlag'],
        '0x0069': ['CS', '1', 'PresentationLUTFlag'],
        '0x006A': ['CS', '1', 'ImageBoxPresentationLUTFlag'],
        '0x00A0': ['US', '1', 'MemoryBitDepth'],
        '0x00A1': ['US', '1', 'PrintingBitDepth'],
        '0x00A2': ['SQ', '1', 'MediaInstalledSequence'],
        '0x00A4': ['SQ', '1', 'OtherMediaAvailableSequence'],
        '0x00A8': ['SQ', '1', 'SupportedImageDisplayFormatsSequence'],
        '0x0500': ['SQ', '1', 'ReferencedFilmBoxSequence'],
        '0x0510': ['SQ', '1', 'ReferencedStoredPrintSequence'],
    },
    '0x2010': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['ST', '1', 'ImageDisplayFormat'],
        '0x0030': ['CS', '1', 'AnnotationDisplayFormatID'],
        '0x0040': ['CS', '1', 'FilmOrientation'],
        '0x0050': ['CS', '1', 'FilmSizeID'],
        '0x0052': ['CS', '1', 'PrinterResolutionID'],
        '0x0054': ['CS', '1', 'DefaultPrinterResolutionID'],
        '0x0060': ['CS', '1', 'MagnificationType'],
        '0x0080': ['CS', '1', 'SmoothingType'],
        '0x00A6': ['CS', '1', 'DefaultMagnificationType'],
        '0x00A7': ['CS', '1-n', 'OtherMagnificationTypesAvailable'],
        '0x00A8': ['CS', '1', 'DefaultSmoothingType'],
        '0x00A9': ['CS', '1-n', 'OtherSmoothingTypesAvailable'],
        '0x0100': ['CS', '1', 'BorderDensity'],
        '0x0110': ['CS', '1', 'EmptyImageDensity'],
        '0x0120': ['US', '1', 'MinDensity'],
        '0x0130': ['US', '1', 'MaxDensity'],
        '0x0140': ['CS', '1', 'Trim'],
        '0x0150': ['ST', '1', 'ConfigurationInformation'],
        '0x0152': ['LT', '1', 'ConfigurationInformationDescription'],
        '0x0154': ['IS', '1', 'MaximumCollatedFilms'],
        '0x015E': ['US', '1', 'Illumination'],
        '0x0160': ['US', '1', 'ReflectedAmbientLight'],
        '0x0376': ['DS', '2', 'PrinterPixelSpacing'],
        '0x0500': ['SQ', '1', 'ReferencedFilmSessionSequence'],
        '0x0510': ['SQ', '1', 'ReferencedImageBoxSequence'],
        '0x0520': ['SQ', '1', 'ReferencedBasicAnnotationBoxSequence'],
    },
    '0x2020': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['US', '1', 'ImageBoxPosition'],
        '0x0020': ['CS', '1', 'Polarity'],
        '0x0030': ['DS', '1', 'RequestedImageSize'],
        '0x0040': ['CS', '1', 'RequestedDecimateCropBehavior'],
        '0x0050': ['CS', '1', 'RequestedResolutionID'],
        '0x00A0': ['CS', '1', 'RequestedImageSizeFlag'],
        '0x00A2': ['CS', '1', 'DecimateCropResult'],
        '0x0110': ['SQ', '1', 'BasicGrayscaleImageSequence'],
        '0x0111': ['SQ', '1', 'BasicColorImageSequence'],
        '0x0130': ['SQ', '1', 'ReferencedImageOverlayBoxSequence'],
        '0x0140': ['SQ', '1', 'ReferencedVOILUTBoxSequence'],
    },
    '0x2030': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['US', '1', 'AnnotationPosition'],
        '0x0020': ['LO', '1', 'TextString'],
    },
    '0x2040': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['SQ', '1', 'ReferencedOverlayPlaneSequence'],
        '0x0011': ['US', '1-99', 'ReferencedOverlayPlaneGroups'],
        '0x0020': ['SQ', '1', 'OverlayPixelDataSequence'],
        '0x0060': ['CS', '1', 'OverlayMagnificationType'],
        '0x0070': ['CS', '1', 'OverlaySmoothingType'],
        '0x0072': ['CS', '1', 'OverlayOrImageMagnification'],
        '0x0074': ['US', '1', 'MagnifyToNumberOfColumns'],
        '0x0080': ['CS', '1', 'OverlayForegroundDensity'],
        '0x0082': ['CS', '1', 'OverlayBackgroundDensity'],
        '0x0090': ['CS', '1', 'OverlayMode'],
        '0x0100': ['CS', '1', 'ThresholdDensity'],
        '0x0500': ['SQ', '1', 'ReferencedImageBoxSequenceRetired'],
    },
    '0x2050': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['SQ', '1', 'PresentationLUTSequence'],
        '0x0020': ['CS', '1', 'PresentationLUTShape'],
        '0x0500': ['SQ', '1', 'ReferencedPresentationLUTSequence'],
    },
    '0x2100': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['SH', '1', 'PrintJobID'],
        '0x0020': ['CS', '1', 'ExecutionStatus'],
        '0x0030': ['CS', '1', 'ExecutionStatusInfo'],
        '0x0040': ['DA', '1', 'CreationDate'],
        '0x0050': ['TM', '1', 'CreationTime'],
        '0x0070': ['AE', '1', 'Originator'],
        '0x0140': ['AE', '1', 'DestinationAE'],
        '0x0160': ['SH', '1', 'OwnerID'],
        '0x0170': ['IS', '1', 'NumberOfFilms'],
        '0x0500': ['SQ', '1', 'ReferencedPrintJobSequencePullStoredPrint'],
    },
    '0x2110': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['CS', '1', 'PrinterStatus'],
        '0x0020': ['CS', '1', 'PrinterStatusInfo'],
        '0x0030': ['LO', '1', 'PrinterName'],
        '0x0099': ['SH', '1', 'PrintQueueID'],
    },
    '0x2120': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['CS', '1', 'QueueStatus'],
        '0x0050': ['SQ', '1', 'PrintJobDescriptionSequence'],
        '0x0070': ['SQ', '1', 'ReferencedPrintJobSequence'],
    },
    '0x2130': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['SQ', '1', 'PrintManagementCapabilitiesSequence'],
        '0x0015': ['SQ', '1', 'PrinterCharacteristicsSequence'],
        '0x0030': ['SQ', '1', 'FilmBoxContentSequence'],
        '0x0040': ['SQ', '1', 'ImageBoxContentSequence'],
        '0x0050': ['SQ', '1', 'AnnotationContentSequence'],
        '0x0060': ['SQ', '1', 'ImageOverlayBoxContentSequence'],
        '0x0080': ['SQ', '1', 'PresentationLUTContentSequence'],
        '0x00A0': ['SQ', '1', 'ProposedStudySequence'],
        '0x00C0': ['SQ', '1', 'OriginalImageSequence'],
    },
    '0x2200': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['CS', '1', 'LabelUsingInformationExtractedFromInstances'],
        '0x0002': ['UT', '1', 'LabelText'],
        '0x0003': ['CS', '1', 'LabelStyleSelection'],
        '0x0004': ['LT', '1', 'MediaDisposition'],
        '0x0005': ['LT', '1', 'BarcodeValue'],
        '0x0006': ['CS', '1', 'BarcodeSymbology'],
        '0x0007': ['CS', '1', 'AllowMediaSplitting'],
        '0x0008': ['CS', '1', 'IncludeNonDICOMObjects'],
        '0x0009': ['CS', '1', 'IncludeDisplayApplication'],
        '0x000A': ['CS', '1', 'PreserveCompositeInstancesAfterMediaCreation'],
        '0x000B': ['US', '1', 'TotalNumberOfPiecesOfMediaCreated'],
        '0x000C': ['LO', '1', 'RequestedMediaApplicationProfile'],
        '0x000D': ['SQ', '1', 'ReferencedStorageMediaSequence'],
        '0x000E': ['AT', '1-n', 'FailureAttributes'],
        '0x000F': ['CS', '1', 'AllowLossyCompression'],
        '0x0020': ['CS', '1', 'RequestPriority'],
    },
    '0x3002': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['SH', '1', 'RTImageLabel'],
        '0x0003': ['LO', '1', 'RTImageName'],
        '0x0004': ['ST', '1', 'RTImageDescription'],
        '0x000A': ['CS', '1', 'ReportedValuesOrigin'],
        '0x000C': ['CS', '1', 'RTImagePlane'],
        '0x000D': ['DS', '3', 'XRayImageReceptorTranslation'],
        '0x000E': ['DS', '1', 'XRayImageReceptorAngle'],
        '0x0010': ['DS', '6', 'RTImageOrientation'],
        '0x0011': ['DS', '2', 'ImagePlanePixelSpacing'],
        '0x0012': ['DS', '2', 'RTImagePosition'],
        '0x0020': ['SH', '1', 'RadiationMachineName'],
        '0x0022': ['DS', '1', 'RadiationMachineSAD'],
        '0x0024': ['DS', '1', 'RadiationMachineSSD'],
        '0x0026': ['DS', '1', 'RTImageSID'],
        '0x0028': ['DS', '1', 'SourceToReferenceObjectDistance'],
        '0x0029': ['IS', '1', 'FractionNumber'],
        '0x0030': ['SQ', '1', 'ExposureSequence'],
        '0x0032': ['DS', '1', 'MetersetExposure'],
        '0x0034': ['DS', '4', 'DiaphragmPosition'],
        '0x0040': ['SQ', '1', 'FluenceMapSequence'],
        '0x0041': ['CS', '1', 'FluenceDataSource'],
        '0x0042': ['DS', '1', 'FluenceDataScale'],
        '0x0050': ['SQ', '1', 'PrimaryFluenceModeSequence'],
        '0x0051': ['CS', '1', 'FluenceMode'],
        '0x0052': ['SH', '1', 'FluenceModeID'],
    },
    '0x3004': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['CS', '1', 'DVHType'],
        '0x0002': ['CS', '1', 'DoseUnits'],
        '0x0004': ['CS', '1', 'DoseType'],
        '0x0005': ['CS', '1', 'SpatialTransformOfDose'],
        '0x0006': ['LO', '1', 'DoseComment'],
        '0x0008': ['DS', '3', 'NormalizationPoint'],
        '0x000A': ['CS', '1', 'DoseSummationType'],
        '0x000C': ['DS', '2-n', 'GridFrameOffsetVector'],
        '0x000E': ['DS', '1', 'DoseGridScaling'],
        '0x0010': ['SQ', '1', 'RTDoseROISequence'],
        '0x0012': ['DS', '1', 'DoseValue'],
        '0x0014': ['CS', '1-3', 'TissueHeterogeneityCorrection'],
        '0x0040': ['DS', '3', 'DVHNormalizationPoint'],
        '0x0042': ['DS', '1', 'DVHNormalizationDoseValue'],
        '0x0050': ['SQ', '1', 'DVHSequence'],
        '0x0052': ['DS', '1', 'DVHDoseScaling'],
        '0x0054': ['CS', '1', 'DVHVolumeUnits'],
        '0x0056': ['IS', '1', 'DVHNumberOfBins'],
        '0x0058': ['DS', '2-2n', 'DVHData'],
        '0x0060': ['SQ', '1', 'DVHReferencedROISequence'],
        '0x0062': ['CS', '1', 'DVHROIContributionType'],
        '0x0070': ['DS', '1', 'DVHMinimumDose'],
        '0x0072': ['DS', '1', 'DVHMaximumDose'],
        '0x0074': ['DS', '1', 'DVHMeanDose'],
    },
    '0x3006': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['SH', '1', 'StructureSetLabel'],
        '0x0004': ['LO', '1', 'StructureSetName'],
        '0x0006': ['ST', '1', 'StructureSetDescription'],
        '0x0008': ['DA', '1', 'StructureSetDate'],
        '0x0009': ['TM', '1', 'StructureSetTime'],
        '0x0010': ['SQ', '1', 'ReferencedFrameOfReferenceSequence'],
        '0x0012': ['SQ', '1', 'RTReferencedStudySequence'],
        '0x0014': ['SQ', '1', 'RTReferencedSeriesSequence'],
        '0x0016': ['SQ', '1', 'ContourImageSequence'],
        '0x0018': ['SQ', '1', 'PredecessorStructureSetSequence'],
        '0x0020': ['SQ', '1', 'StructureSetROISequence'],
        '0x0022': ['IS', '1', 'ROINumber'],
        '0x0024': ['UI', '1', 'ReferencedFrameOfReferenceUID'],
        '0x0026': ['LO', '1', 'ROIName'],
        '0x0028': ['ST', '1', 'ROIDescription'],
        '0x002A': ['IS', '3', 'ROIDisplayColor'],
        '0x002C': ['DS', '1', 'ROIVolume'],
        '0x0030': ['SQ', '1', 'RTRelatedROISequence'],
        '0x0033': ['CS', '1', 'RTROIRelationship'],
        '0x0036': ['CS', '1', 'ROIGenerationAlgorithm'],
        '0x0038': ['LO', '1', 'ROIGenerationDescription'],
        '0x0039': ['SQ', '1', 'ROIContourSequence'],
        '0x0040': ['SQ', '1', 'ContourSequence'],
        '0x0042': ['CS', '1', 'ContourGeometricType'],
        '0x0044': ['DS', '1', 'ContourSlabThickness'],
        '0x0045': ['DS', '3', 'ContourOffsetVector'],
        '0x0046': ['IS', '1', 'NumberOfContourPoints'],
        '0x0048': ['IS', '1', 'ContourNumber'],
        '0x0049': ['IS', '1-n', 'AttachedContours'],
        '0x0050': ['DS', '3-3n', 'ContourData'],
        '0x0080': ['SQ', '1', 'RTROIObservationsSequence'],
        '0x0082': ['IS', '1', 'ObservationNumber'],
        '0x0084': ['IS', '1', 'ReferencedROINumber'],
        '0x0085': ['SH', '1', 'ROIObservationLabel'],
        '0x0086': ['SQ', '1', 'RTROIIdentificationCodeSequence'],
        '0x0088': ['ST', '1', 'ROIObservationDescription'],
        '0x00A0': ['SQ', '1', 'RelatedRTROIObservationsSequence'],
        '0x00A4': ['CS', '1', 'RTROIInterpretedType'],
        '0x00A6': ['PN', '1', 'ROIInterpreter'],
        '0x00B0': ['SQ', '1', 'ROIPhysicalPropertiesSequence'],
        '0x00B2': ['CS', '1', 'ROIPhysicalProperty'],
        '0x00B4': ['DS', '1', 'ROIPhysicalPropertyValue'],
        '0x00B6': ['SQ', '1', 'ROIElementalCompositionSequence'],
        '0x00B7': ['US', '1', 'ROIElementalCompositionAtomicNumber'],
        '0x00B8': ['FL', '1', 'ROIElementalCompositionAtomicMassFraction'],
        '0x00B9': ['SQ', '1', 'AdditionalRTROIIdentificationCodeSequence'],
        '0x00C0': ['SQ', '1', 'FrameOfReferenceRelationshipSequence'],
        '0x00C2': ['UI', '1', 'RelatedFrameOfReferenceUID'],
        '0x00C4': ['CS', '1', 'FrameOfReferenceTransformationType'],
        '0x00C6': ['DS', '16', 'FrameOfReferenceTransformationMatrix'],
        '0x00C8': ['LO', '1', 'FrameOfReferenceTransformationComment'],
    },
    '0x3008': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['SQ', '1', 'MeasuredDoseReferenceSequence'],
        '0x0012': ['ST', '1', 'MeasuredDoseDescription'],
        '0x0014': ['CS', '1', 'MeasuredDoseType'],
        '0x0016': ['DS', '1', 'MeasuredDoseValue'],
        '0x0020': ['SQ', '1', 'TreatmentSessionBeamSequence'],
        '0x0021': ['SQ', '1', 'TreatmentSessionIonBeamSequence'],
        '0x0022': ['IS', '1', 'CurrentFractionNumber'],
        '0x0024': ['DA', '1', 'TreatmentControlPointDate'],
        '0x0025': ['TM', '1', 'TreatmentControlPointTime'],
        '0x002A': ['CS', '1', 'TreatmentTerminationStatus'],
        '0x002B': ['SH', '1', 'TreatmentTerminationCode'],
        '0x002C': ['CS', '1', 'TreatmentVerificationStatus'],
        '0x0030': ['SQ', '1', 'ReferencedTreatmentRecordSequence'],
        '0x0032': ['DS', '1', 'SpecifiedPrimaryMeterset'],
        '0x0033': ['DS', '1', 'SpecifiedSecondaryMeterset'],
        '0x0036': ['DS', '1', 'DeliveredPrimaryMeterset'],
        '0x0037': ['DS', '1', 'DeliveredSecondaryMeterset'],
        '0x003A': ['DS', '1', 'SpecifiedTreatmentTime'],
        '0x003B': ['DS', '1', 'DeliveredTreatmentTime'],
        '0x0040': ['SQ', '1', 'ControlPointDeliverySequence'],
        '0x0041': ['SQ', '1', 'IonControlPointDeliverySequence'],
        '0x0042': ['DS', '1', 'SpecifiedMeterset'],
        '0x0044': ['DS', '1', 'DeliveredMeterset'],
        '0x0045': ['FL', '1', 'MetersetRateSet'],
        '0x0046': ['FL', '1', 'MetersetRateDelivered'],
        '0x0047': ['FL', '1-n', 'ScanSpotMetersetsDelivered'],
        '0x0048': ['DS', '1', 'DoseRateDelivered'],
        '0x0050': ['SQ', '1', 'TreatmentSummaryCalculatedDoseReferenceSequence'],
        '0x0052': ['DS', '1', 'CumulativeDoseToDoseReference'],
        '0x0054': ['DA', '1', 'FirstTreatmentDate'],
        '0x0056': ['DA', '1', 'MostRecentTreatmentDate'],
        '0x005A': ['IS', '1', 'NumberOfFractionsDelivered'],
        '0x0060': ['SQ', '1', 'OverrideSequence'],
        '0x0061': ['AT', '1', 'ParameterSequencePointer'],
        '0x0062': ['AT', '1', 'OverrideParameterPointer'],
        '0x0063': ['IS', '1', 'ParameterItemIndex'],
        '0x0064': ['IS', '1', 'MeasuredDoseReferenceNumber'],
        '0x0065': ['AT', '1', 'ParameterPointer'],
        '0x0066': ['ST', '1', 'OverrideReason'],
        '0x0068': ['SQ', '1', 'CorrectedParameterSequence'],
        '0x006A': ['FL', '1', 'CorrectionValue'],
        '0x0070': ['SQ', '1', 'CalculatedDoseReferenceSequence'],
        '0x0072': ['IS', '1', 'CalculatedDoseReferenceNumber'],
        '0x0074': ['ST', '1', 'CalculatedDoseReferenceDescription'],
        '0x0076': ['DS', '1', 'CalculatedDoseReferenceDoseValue'],
        '0x0078': ['DS', '1', 'StartMeterset'],
        '0x007A': ['DS', '1', 'EndMeterset'],
        '0x0080': ['SQ', '1', 'ReferencedMeasuredDoseReferenceSequence'],
        '0x0082': ['IS', '1', 'ReferencedMeasuredDoseReferenceNumber'],
        '0x0090': ['SQ', '1', 'ReferencedCalculatedDoseReferenceSequence'],
        '0x0092': ['IS', '1', 'ReferencedCalculatedDoseReferenceNumber'],
        '0x00A0': ['SQ', '1', 'BeamLimitingDeviceLeafPairsSequence'],
        '0x00B0': ['SQ', '1', 'RecordedWedgeSequence'],
        '0x00C0': ['SQ', '1', 'RecordedCompensatorSequence'],
        '0x00D0': ['SQ', '1', 'RecordedBlockSequence'],
        '0x00E0': ['SQ', '1', 'TreatmentSummaryMeasuredDoseReferenceSequence'],
        '0x00F0': ['SQ', '1', 'RecordedSnoutSequence'],
        '0x00F2': ['SQ', '1', 'RecordedRangeShifterSequence'],
        '0x00F4': ['SQ', '1', 'RecordedLateralSpreadingDeviceSequence'],
        '0x00F6': ['SQ', '1', 'RecordedRangeModulatorSequence'],
        '0x0100': ['SQ', '1', 'RecordedSourceSequence'],
        '0x0105': ['LO', '1', 'SourceSerialNumber'],
        '0x0110': ['SQ', '1', 'TreatmentSessionApplicationSetupSequence'],
        '0x0116': ['CS', '1', 'ApplicationSetupCheck'],
        '0x0120': ['SQ', '1', 'RecordedBrachyAccessoryDeviceSequence'],
        '0x0122': ['IS', '1', 'ReferencedBrachyAccessoryDeviceNumber'],
        '0x0130': ['SQ', '1', 'RecordedChannelSequence'],
        '0x0132': ['DS', '1', 'SpecifiedChannelTotalTime'],
        '0x0134': ['DS', '1', 'DeliveredChannelTotalTime'],
        '0x0136': ['IS', '1', 'SpecifiedNumberOfPulses'],
        '0x0138': ['IS', '1', 'DeliveredNumberOfPulses'],
        '0x013A': ['DS', '1', 'SpecifiedPulseRepetitionInterval'],
        '0x013C': ['DS', '1', 'DeliveredPulseRepetitionInterval'],
        '0x0140': ['SQ', '1', 'RecordedSourceApplicatorSequence'],
        '0x0142': ['IS', '1', 'ReferencedSourceApplicatorNumber'],
        '0x0150': ['SQ', '1', 'RecordedChannelShieldSequence'],
        '0x0152': ['IS', '1', 'ReferencedChannelShieldNumber'],
        '0x0160': ['SQ', '1', 'BrachyControlPointDeliveredSequence'],
        '0x0162': ['DA', '1', 'SafePositionExitDate'],
        '0x0164': ['TM', '1', 'SafePositionExitTime'],
        '0x0166': ['DA', '1', 'SafePositionReturnDate'],
        '0x0168': ['TM', '1', 'SafePositionReturnTime'],
        '0x0171': ['SQ', '1', 'PulseSpecificBrachyControlPointDeliveredSequence'],
        '0x0172': ['US', '1', 'PulseNumber'],
        '0x0173': ['SQ', '1', 'BrachyPulseControlPointDeliveredSequence'],
        '0x0200': ['CS', '1', 'CurrentTreatmentStatus'],
        '0x0202': ['ST', '1', 'TreatmentStatusComment'],
        '0x0220': ['SQ', '1', 'FractionGroupSummarySequence'],
        '0x0223': ['IS', '1', 'ReferencedFractionNumber'],
        '0x0224': ['CS', '1', 'FractionGroupType'],
        '0x0230': ['CS', '1', 'BeamStopperPosition'],
        '0x0240': ['SQ', '1', 'FractionStatusSummarySequence'],
        '0x0250': ['DA', '1', 'TreatmentDate'],
        '0x0251': ['TM', '1', 'TreatmentTime'],
    },
    '0x300A': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['SH', '1', 'RTPlanLabel'],
        '0x0003': ['LO', '1', 'RTPlanName'],
        '0x0004': ['ST', '1', 'RTPlanDescription'],
        '0x0006': ['DA', '1', 'RTPlanDate'],
        '0x0007': ['TM', '1', 'RTPlanTime'],
        '0x0009': ['LO', '1-n', 'TreatmentProtocols'],
        '0x000A': ['CS', '1', 'PlanIntent'],
        '0x000B': ['LO', '1-n', 'TreatmentSites'],
        '0x000C': ['CS', '1', 'RTPlanGeometry'],
        '0x000E': ['ST', '1', 'PrescriptionDescription'],
        '0x0010': ['SQ', '1', 'DoseReferenceSequence'],
        '0x0012': ['IS', '1', 'DoseReferenceNumber'],
        '0x0013': ['UI', '1', 'DoseReferenceUID'],
        '0x0014': ['CS', '1', 'DoseReferenceStructureType'],
        '0x0015': ['CS', '1', 'NominalBeamEnergyUnit'],
        '0x0016': ['LO', '1', 'DoseReferenceDescription'],
        '0x0018': ['DS', '3', 'DoseReferencePointCoordinates'],
        '0x001A': ['DS', '1', 'NominalPriorDose'],
        '0x0020': ['CS', '1', 'DoseReferenceType'],
        '0x0021': ['DS', '1', 'ConstraintWeight'],
        '0x0022': ['DS', '1', 'DeliveryWarningDose'],
        '0x0023': ['DS', '1', 'DeliveryMaximumDose'],
        '0x0025': ['DS', '1', 'TargetMinimumDose'],
        '0x0026': ['DS', '1', 'TargetPrescriptionDose'],
        '0x0027': ['DS', '1', 'TargetMaximumDose'],
        '0x0028': ['DS', '1', 'TargetUnderdoseVolumeFraction'],
        '0x002A': ['DS', '1', 'OrganAtRiskFullVolumeDose'],
        '0x002B': ['DS', '1', 'OrganAtRiskLimitDose'],
        '0x002C': ['DS', '1', 'OrganAtRiskMaximumDose'],
        '0x002D': ['DS', '1', 'OrganAtRiskOverdoseVolumeFraction'],
        '0x0040': ['SQ', '1', 'ToleranceTableSequence'],
        '0x0042': ['IS', '1', 'ToleranceTableNumber'],
        '0x0043': ['SH', '1', 'ToleranceTableLabel'],
        '0x0044': ['DS', '1', 'GantryAngleTolerance'],
        '0x0046': ['DS', '1', 'BeamLimitingDeviceAngleTolerance'],
        '0x0048': ['SQ', '1', 'BeamLimitingDeviceToleranceSequence'],
        '0x004A': ['DS', '1', 'BeamLimitingDevicePositionTolerance'],
        '0x004B': ['FL', '1', 'SnoutPositionTolerance'],
        '0x004C': ['DS', '1', 'PatientSupportAngleTolerance'],
        '0x004E': ['DS', '1', 'TableTopEccentricAngleTolerance'],
        '0x004F': ['FL', '1', 'TableTopPitchAngleTolerance'],
        '0x0050': ['FL', '1', 'TableTopRollAngleTolerance'],
        '0x0051': ['DS', '1', 'TableTopVerticalPositionTolerance'],
        '0x0052': ['DS', '1', 'TableTopLongitudinalPositionTolerance'],
        '0x0053': ['DS', '1', 'TableTopLateralPositionTolerance'],
        '0x0055': ['CS', '1', 'RTPlanRelationship'],
        '0x0070': ['SQ', '1', 'FractionGroupSequence'],
        '0x0071': ['IS', '1', 'FractionGroupNumber'],
        '0x0072': ['LO', '1', 'FractionGroupDescription'],
        '0x0078': ['IS', '1', 'NumberOfFractionsPlanned'],
        '0x0079': ['IS', '1', 'NumberOfFractionPatternDigitsPerDay'],
        '0x007A': ['IS', '1', 'RepeatFractionCycleLength'],
        '0x007B': ['LT', '1', 'FractionPattern'],
        '0x0080': ['IS', '1', 'NumberOfBeams'],
        '0x0082': ['DS', '3', 'BeamDoseSpecificationPoint'],
        '0x0084': ['DS', '1', 'BeamDose'],
        '0x0086': ['DS', '1', 'BeamMeterset'],
        '0x0088': ['FL', '1', 'BeamDosePointDepth'],
        '0x0089': ['FL', '1', 'BeamDosePointEquivalentDepth'],
        '0x008A': ['FL', '1', 'BeamDosePointSSD'],
        '0x008B': ['CS', '1', 'BeamDoseMeaning'],
        '0x008C': ['SQ', '1', 'BeamDoseVerificationControlPointSequence'],
        '0x008D': ['FL', '1', 'AverageBeamDosePointDepth'],
        '0x008E': ['FL', '1', 'AverageBeamDosePointEquivalentDepth'],
        '0x008F': ['FL', '1', 'AverageBeamDosePointSSD'],
        '0x00A0': ['IS', '1', 'NumberOfBrachyApplicationSetups'],
        '0x00A2': ['DS', '3', 'BrachyApplicationSetupDoseSpecificationPoint'],
        '0x00A4': ['DS', '1', 'BrachyApplicationSetupDose'],
        '0x00B0': ['SQ', '1', 'BeamSequence'],
        '0x00B2': ['SH', '1', 'TreatmentMachineName'],
        '0x00B3': ['CS', '1', 'PrimaryDosimeterUnit'],
        '0x00B4': ['DS', '1', 'SourceAxisDistance'],
        '0x00B6': ['SQ', '1', 'BeamLimitingDeviceSequence'],
        '0x00B8': ['CS', '1', 'RTBeamLimitingDeviceType'],
        '0x00BA': ['DS', '1', 'SourceToBeamLimitingDeviceDistance'],
        '0x00BB': ['FL', '1', 'IsocenterToBeamLimitingDeviceDistance'],
        '0x00BC': ['IS', '1', 'NumberOfLeafJawPairs'],
        '0x00BE': ['DS', '3-n', 'LeafPositionBoundaries'],
        '0x00C0': ['IS', '1', 'BeamNumber'],
        '0x00C2': ['LO', '1', 'BeamName'],
        '0x00C3': ['ST', '1', 'BeamDescription'],
        '0x00C4': ['CS', '1', 'BeamType'],
        '0x00C5': ['FD', '1', 'BeamDeliveryDurationLimit'],
        '0x00C6': ['CS', '1', 'RadiationType'],
        '0x00C7': ['CS', '1', 'HighDoseTechniqueType'],
        '0x00C8': ['IS', '1', 'ReferenceImageNumber'],
        '0x00CA': ['SQ', '1', 'PlannedVerificationImageSequence'],
        '0x00CC': ['LO', '1-n', 'ImagingDeviceSpecificAcquisitionParameters'],
        '0x00CE': ['CS', '1', 'TreatmentDeliveryType'],
        '0x00D0': ['IS', '1', 'NumberOfWedges'],
        '0x00D1': ['SQ', '1', 'WedgeSequence'],
        '0x00D2': ['IS', '1', 'WedgeNumber'],
        '0x00D3': ['CS', '1', 'WedgeType'],
        '0x00D4': ['SH', '1', 'WedgeID'],
        '0x00D5': ['IS', '1', 'WedgeAngle'],
        '0x00D6': ['DS', '1', 'WedgeFactor'],
        '0x00D7': ['FL', '1', 'TotalWedgeTrayWaterEquivalentThickness'],
        '0x00D8': ['DS', '1', 'WedgeOrientation'],
        '0x00D9': ['FL', '1', 'IsocenterToWedgeTrayDistance'],
        '0x00DA': ['DS', '1', 'SourceToWedgeTrayDistance'],
        '0x00DB': ['FL', '1', 'WedgeThinEdgePosition'],
        '0x00DC': ['SH', '1', 'BolusID'],
        '0x00DD': ['ST', '1', 'BolusDescription'],
        '0x00DE': ['DS', '1', 'EffectiveWedgeAngle'],
        '0x00E0': ['IS', '1', 'NumberOfCompensators'],
        '0x00E1': ['SH', '1', 'MaterialID'],
        '0x00E2': ['DS', '1', 'TotalCompensatorTrayFactor'],
        '0x00E3': ['SQ', '1', 'CompensatorSequence'],
        '0x00E4': ['IS', '1', 'CompensatorNumber'],
        '0x00E5': ['SH', '1', 'CompensatorID'],
        '0x00E6': ['DS', '1', 'SourceToCompensatorTrayDistance'],
        '0x00E7': ['IS', '1', 'CompensatorRows'],
        '0x00E8': ['IS', '1', 'CompensatorColumns'],
        '0x00E9': ['DS', '2', 'CompensatorPixelSpacing'],
        '0x00EA': ['DS', '2', 'CompensatorPosition'],
        '0x00EB': ['DS', '1-n', 'CompensatorTransmissionData'],
        '0x00EC': ['DS', '1-n', 'CompensatorThicknessData'],
        '0x00ED': ['IS', '1', 'NumberOfBoli'],
        '0x00EE': ['CS', '1', 'CompensatorType'],
        '0x00EF': ['SH', '1', 'CompensatorTrayID'],
        '0x00F0': ['IS', '1', 'NumberOfBlocks'],
        '0x00F2': ['DS', '1', 'TotalBlockTrayFactor'],
        '0x00F3': ['FL', '1', 'TotalBlockTrayWaterEquivalentThickness'],
        '0x00F4': ['SQ', '1', 'BlockSequence'],
        '0x00F5': ['SH', '1', 'BlockTrayID'],
        '0x00F6': ['DS', '1', 'SourceToBlockTrayDistance'],
        '0x00F7': ['FL', '1', 'IsocenterToBlockTrayDistance'],
        '0x00F8': ['CS', '1', 'BlockType'],
        '0x00F9': ['LO', '1', 'AccessoryCode'],
        '0x00FA': ['CS', '1', 'BlockDivergence'],
        '0x00FB': ['CS', '1', 'BlockMountingPosition'],
        '0x00FC': ['IS', '1', 'BlockNumber'],
        '0x00FE': ['LO', '1', 'BlockName'],
        '0x0100': ['DS', '1', 'BlockThickness'],
        '0x0102': ['DS', '1', 'BlockTransmission'],
        '0x0104': ['IS', '1', 'BlockNumberOfPoints'],
        '0x0106': ['DS', '2-2n', 'BlockData'],
        '0x0107': ['SQ', '1', 'ApplicatorSequence'],
        '0x0108': ['SH', '1', 'ApplicatorID'],
        '0x0109': ['CS', '1', 'ApplicatorType'],
        '0x010A': ['LO', '1', 'ApplicatorDescription'],
        '0x010C': ['DS', '1', 'CumulativeDoseReferenceCoefficient'],
        '0x010E': ['DS', '1', 'FinalCumulativeMetersetWeight'],
        '0x0110': ['IS', '1', 'NumberOfControlPoints'],
        '0x0111': ['SQ', '1', 'ControlPointSequence'],
        '0x0112': ['IS', '1', 'ControlPointIndex'],
        '0x0114': ['DS', '1', 'NominalBeamEnergy'],
        '0x0115': ['DS', '1', 'DoseRateSet'],
        '0x0116': ['SQ', '1', 'WedgePositionSequence'],
        '0x0118': ['CS', '1', 'WedgePosition'],
        '0x011A': ['SQ', '1', 'BeamLimitingDevicePositionSequence'],
        '0x011C': ['DS', '2-2n', 'LeafJawPositions'],
        '0x011E': ['DS', '1', 'GantryAngle'],
        '0x011F': ['CS', '1', 'GantryRotationDirection'],
        '0x0120': ['DS', '1', 'BeamLimitingDeviceAngle'],
        '0x0121': ['CS', '1', 'BeamLimitingDeviceRotationDirection'],
        '0x0122': ['DS', '1', 'PatientSupportAngle'],
        '0x0123': ['CS', '1', 'PatientSupportRotationDirection'],
        '0x0124': ['DS', '1', 'TableTopEccentricAxisDistance'],
        '0x0125': ['DS', '1', 'TableTopEccentricAngle'],
        '0x0126': ['CS', '1', 'TableTopEccentricRotationDirection'],
        '0x0128': ['DS', '1', 'TableTopVerticalPosition'],
        '0x0129': ['DS', '1', 'TableTopLongitudinalPosition'],
        '0x012A': ['DS', '1', 'TableTopLateralPosition'],
        '0x012C': ['DS', '3', 'IsocenterPosition'],
        '0x012E': ['DS', '3', 'SurfaceEntryPoint'],
        '0x0130': ['DS', '1', 'SourceToSurfaceDistance'],
        '0x0131': ['FL', '1', 'AverageBeamDosePointSourceToExternalContourSurfaceDistance'],
        '0x0132': ['FL', '1', 'SourceToExternalContourDistance'],
        '0x0133': ['FL', '3', 'ExternalContourEntryPoint'],
        '0x0134': ['DS', '1', 'CumulativeMetersetWeight'],
        '0x0140': ['FL', '1', 'TableTopPitchAngle'],
        '0x0142': ['CS', '1', 'TableTopPitchRotationDirection'],
        '0x0144': ['FL', '1', 'TableTopRollAngle'],
        '0x0146': ['CS', '1', 'TableTopRollRotationDirection'],
        '0x0148': ['FL', '1', 'HeadFixationAngle'],
        '0x014A': ['FL', '1', 'GantryPitchAngle'],
        '0x014C': ['CS', '1', 'GantryPitchRotationDirection'],
        '0x014E': ['FL', '1', 'GantryPitchAngleTolerance'],
        '0x0180': ['SQ', '1', 'PatientSetupSequence'],
        '0x0182': ['IS', '1', 'PatientSetupNumber'],
        '0x0183': ['LO', '1', 'PatientSetupLabel'],
        '0x0184': ['LO', '1', 'PatientAdditionalPosition'],
        '0x0190': ['SQ', '1', 'FixationDeviceSequence'],
        '0x0192': ['CS', '1', 'FixationDeviceType'],
        '0x0194': ['SH', '1', 'FixationDeviceLabel'],
        '0x0196': ['ST', '1', 'FixationDeviceDescription'],
        '0x0198': ['SH', '1', 'FixationDevicePosition'],
        '0x0199': ['FL', '1', 'FixationDevicePitchAngle'],
        '0x019A': ['FL', '1', 'FixationDeviceRollAngle'],
        '0x01A0': ['SQ', '1', 'ShieldingDeviceSequence'],
        '0x01A2': ['CS', '1', 'ShieldingDeviceType'],
        '0x01A4': ['SH', '1', 'ShieldingDeviceLabel'],
        '0x01A6': ['ST', '1', 'ShieldingDeviceDescription'],
        '0x01A8': ['SH', '1', 'ShieldingDevicePosition'],
        '0x01B0': ['CS', '1', 'SetupTechnique'],
        '0x01B2': ['ST', '1', 'SetupTechniqueDescription'],
        '0x01B4': ['SQ', '1', 'SetupDeviceSequence'],
        '0x01B6': ['CS', '1', 'SetupDeviceType'],
        '0x01B8': ['SH', '1', 'SetupDeviceLabel'],
        '0x01BA': ['ST', '1', 'SetupDeviceDescription'],
        '0x01BC': ['DS', '1', 'SetupDeviceParameter'],
        '0x01D0': ['ST', '1', 'SetupReferenceDescription'],
        '0x01D2': ['DS', '1', 'TableTopVerticalSetupDisplacement'],
        '0x01D4': ['DS', '1', 'TableTopLongitudinalSetupDisplacement'],
        '0x01D6': ['DS', '1', 'TableTopLateralSetupDisplacement'],
        '0x0200': ['CS', '1', 'BrachyTreatmentTechnique'],
        '0x0202': ['CS', '1', 'BrachyTreatmentType'],
        '0x0206': ['SQ', '1', 'TreatmentMachineSequence'],
        '0x0210': ['SQ', '1', 'SourceSequence'],
        '0x0212': ['IS', '1', 'SourceNumber'],
        '0x0214': ['CS', '1', 'SourceType'],
        '0x0216': ['LO', '1', 'SourceManufacturer'],
        '0x0218': ['DS', '1', 'ActiveSourceDiameter'],
        '0x021A': ['DS', '1', 'ActiveSourceLength'],
        '0x021B': ['SH', '1', 'SourceModelID'],
        '0x021C': ['LO', '1', 'SourceDescription'],
        '0x0222': ['DS', '1', 'SourceEncapsulationNominalThickness'],
        '0x0224': ['DS', '1', 'SourceEncapsulationNominalTransmission'],
        '0x0226': ['LO', '1', 'SourceIsotopeName'],
        '0x0228': ['DS', '1', 'SourceIsotopeHalfLife'],
        '0x0229': ['CS', '1', 'SourceStrengthUnits'],
        '0x022A': ['DS', '1', 'ReferenceAirKermaRate'],
        '0x022B': ['DS', '1', 'SourceStrength'],
        '0x022C': ['DA', '1', 'SourceStrengthReferenceDate'],
        '0x022E': ['TM', '1', 'SourceStrengthReferenceTime'],
        '0x0230': ['SQ', '1', 'ApplicationSetupSequence'],
        '0x0232': ['CS', '1', 'ApplicationSetupType'],
        '0x0234': ['IS', '1', 'ApplicationSetupNumber'],
        '0x0236': ['LO', '1', 'ApplicationSetupName'],
        '0x0238': ['LO', '1', 'ApplicationSetupManufacturer'],
        '0x0240': ['IS', '1', 'TemplateNumber'],
        '0x0242': ['SH', '1', 'TemplateType'],
        '0x0244': ['LO', '1', 'TemplateName'],
        '0x0250': ['DS', '1', 'TotalReferenceAirKerma'],
        '0x0260': ['SQ', '1', 'BrachyAccessoryDeviceSequence'],
        '0x0262': ['IS', '1', 'BrachyAccessoryDeviceNumber'],
        '0x0263': ['SH', '1', 'BrachyAccessoryDeviceID'],
        '0x0264': ['CS', '1', 'BrachyAccessoryDeviceType'],
        '0x0266': ['LO', '1', 'BrachyAccessoryDeviceName'],
        '0x026A': ['DS', '1', 'BrachyAccessoryDeviceNominalThickness'],
        '0x026C': ['DS', '1', 'BrachyAccessoryDeviceNominalTransmission'],
        '0x0280': ['SQ', '1', 'ChannelSequence'],
        '0x0282': ['IS', '1', 'ChannelNumber'],
        '0x0284': ['DS', '1', 'ChannelLength'],
        '0x0286': ['DS', '1', 'ChannelTotalTime'],
        '0x0288': ['CS', '1', 'SourceMovementType'],
        '0x028A': ['IS', '1', 'NumberOfPulses'],
        '0x028C': ['DS', '1', 'PulseRepetitionInterval'],
        '0x0290': ['IS', '1', 'SourceApplicatorNumber'],
        '0x0291': ['SH', '1', 'SourceApplicatorID'],
        '0x0292': ['CS', '1', 'SourceApplicatorType'],
        '0x0294': ['LO', '1', 'SourceApplicatorName'],
        '0x0296': ['DS', '1', 'SourceApplicatorLength'],
        '0x0298': ['LO', '1', 'SourceApplicatorManufacturer'],
        '0x029C': ['DS', '1', 'SourceApplicatorWallNominalThickness'],
        '0x029E': ['DS', '1', 'SourceApplicatorWallNominalTransmission'],
        '0x02A0': ['DS', '1', 'SourceApplicatorStepSize'],
        '0x02A2': ['IS', '1', 'TransferTubeNumber'],
        '0x02A4': ['DS', '1', 'TransferTubeLength'],
        '0x02B0': ['SQ', '1', 'ChannelShieldSequence'],
        '0x02B2': ['IS', '1', 'ChannelShieldNumber'],
        '0x02B3': ['SH', '1', 'ChannelShieldID'],
        '0x02B4': ['LO', '1', 'ChannelShieldName'],
        '0x02B8': ['DS', '1', 'ChannelShieldNominalThickness'],
        '0x02BA': ['DS', '1', 'ChannelShieldNominalTransmission'],
        '0x02C8': ['DS', '1', 'FinalCumulativeTimeWeight'],
        '0x02D0': ['SQ', '1', 'BrachyControlPointSequence'],
        '0x02D2': ['DS', '1', 'ControlPointRelativePosition'],
        '0x02D4': ['DS', '3', 'ControlPoint3DPosition'],
        '0x02D6': ['DS', '1', 'CumulativeTimeWeight'],
        '0x02E0': ['CS', '1', 'CompensatorDivergence'],
        '0x02E1': ['CS', '1', 'CompensatorMountingPosition'],
        '0x02E2': ['DS', '1-n', 'SourceToCompensatorDistance'],
        '0x02E3': ['FL', '1', 'TotalCompensatorTrayWaterEquivalentThickness'],
        '0x02E4': ['FL', '1', 'IsocenterToCompensatorTrayDistance'],
        '0x02E5': ['FL', '1', 'CompensatorColumnOffset'],
        '0x02E6': ['FL', '1-n', 'IsocenterToCompensatorDistances'],
        '0x02E7': ['FL', '1', 'CompensatorRelativeStoppingPowerRatio'],
        '0x02E8': ['FL', '1', 'CompensatorMillingToolDiameter'],
        '0x02EA': ['SQ', '1', 'IonRangeCompensatorSequence'],
        '0x02EB': ['LT', '1', 'CompensatorDescription'],
        '0x0302': ['IS', '1', 'RadiationMassNumber'],
        '0x0304': ['IS', '1', 'RadiationAtomicNumber'],
        '0x0306': ['SS', '1', 'RadiationChargeState'],
        '0x0308': ['CS', '1', 'ScanMode'],
        '0x030A': ['FL', '2', 'VirtualSourceAxisDistances'],
        '0x030C': ['SQ', '1', 'SnoutSequence'],
        '0x030D': ['FL', '1', 'SnoutPosition'],
        '0x030F': ['SH', '1', 'SnoutID'],
        '0x0312': ['IS', '1', 'NumberOfRangeShifters'],
        '0x0314': ['SQ', '1', 'RangeShifterSequence'],
        '0x0316': ['IS', '1', 'RangeShifterNumber'],
        '0x0318': ['SH', '1', 'RangeShifterID'],
        '0x0320': ['CS', '1', 'RangeShifterType'],
        '0x0322': ['LO', '1', 'RangeShifterDescription'],
        '0x0330': ['IS', '1', 'NumberOfLateralSpreadingDevices'],
        '0x0332': ['SQ', '1', 'LateralSpreadingDeviceSequence'],
        '0x0334': ['IS', '1', 'LateralSpreadingDeviceNumber'],
        '0x0336': ['SH', '1', 'LateralSpreadingDeviceID'],
        '0x0338': ['CS', '1', 'LateralSpreadingDeviceType'],
        '0x033A': ['LO', '1', 'LateralSpreadingDeviceDescription'],
        '0x033C': ['FL', '1', 'LateralSpreadingDeviceWaterEquivalentThickness'],
        '0x0340': ['IS', '1', 'NumberOfRangeModulators'],
        '0x0342': ['SQ', '1', 'RangeModulatorSequence'],
        '0x0344': ['IS', '1', 'RangeModulatorNumber'],
        '0x0346': ['SH', '1', 'RangeModulatorID'],
        '0x0348': ['CS', '1', 'RangeModulatorType'],
        '0x034A': ['LO', '1', 'RangeModulatorDescription'],
        '0x034C': ['SH', '1', 'BeamCurrentModulationID'],
        '0x0350': ['CS', '1', 'PatientSupportType'],
        '0x0352': ['SH', '1', 'PatientSupportID'],
        '0x0354': ['LO', '1', 'PatientSupportAccessoryCode'],
        '0x0356': ['FL', '1', 'FixationLightAzimuthalAngle'],
        '0x0358': ['FL', '1', 'FixationLightPolarAngle'],
        '0x035A': ['FL', '1', 'MetersetRate'],
        '0x0360': ['SQ', '1', 'RangeShifterSettingsSequence'],
        '0x0362': ['LO', '1', 'RangeShifterSetting'],
        '0x0364': ['FL', '1', 'IsocenterToRangeShifterDistance'],
        '0x0366': ['FL', '1', 'RangeShifterWaterEquivalentThickness'],
        '0x0370': ['SQ', '1', 'LateralSpreadingDeviceSettingsSequence'],
        '0x0372': ['LO', '1', 'LateralSpreadingDeviceSetting'],
        '0x0374': ['FL', '1', 'IsocenterToLateralSpreadingDeviceDistance'],
        '0x0380': ['SQ', '1', 'RangeModulatorSettingsSequence'],
        '0x0382': ['FL', '1', 'RangeModulatorGatingStartValue'],
        '0x0384': ['FL', '1', 'RangeModulatorGatingStopValue'],
        '0x0386': ['FL', '1', 'RangeModulatorGatingStartWaterEquivalentThickness'],
        '0x0388': ['FL', '1', 'RangeModulatorGatingStopWaterEquivalentThickness'],
        '0x038A': ['FL', '1', 'IsocenterToRangeModulatorDistance'],
        '0x0390': ['SH', '1', 'ScanSpotTuneID'],
        '0x0392': ['IS', '1', 'NumberOfScanSpotPositions'],
        '0x0394': ['FL', '1-n', 'ScanSpotPositionMap'],
        '0x0396': ['FL', '1-n', 'ScanSpotMetersetWeights'],
        '0x0398': ['FL', '2', 'ScanningSpotSize'],
        '0x039A': ['IS', '1', 'NumberOfPaintings'],
        '0x03A0': ['SQ', '1', 'IonToleranceTableSequence'],
        '0x03A2': ['SQ', '1', 'IonBeamSequence'],
        '0x03A4': ['SQ', '1', 'IonBeamLimitingDeviceSequence'],
        '0x03A6': ['SQ', '1', 'IonBlockSequence'],
        '0x03A8': ['SQ', '1', 'IonControlPointSequence'],
        '0x03AA': ['SQ', '1', 'IonWedgeSequence'],
        '0x03AC': ['SQ', '1', 'IonWedgePositionSequence'],
        '0x0401': ['SQ', '1', 'ReferencedSetupImageSequence'],
        '0x0402': ['ST', '1', 'SetupImageComment'],
        '0x0410': ['SQ', '1', 'MotionSynchronizationSequence'],
        '0x0412': ['FL', '3', 'ControlPointOrientation'],
        '0x0420': ['SQ', '1', 'GeneralAccessorySequence'],
        '0x0421': ['SH', '1', 'GeneralAccessoryID'],
        '0x0422': ['ST', '1', 'GeneralAccessoryDescription'],
        '0x0423': ['CS', '1', 'GeneralAccessoryType'],
        '0x0424': ['IS', '1', 'GeneralAccessoryNumber'],
        '0x0425': ['FL', '1', 'SourceToGeneralAccessoryDistance'],
        '0x0431': ['SQ', '1', 'ApplicatorGeometrySequence'],
        '0x0432': ['CS', '1', 'ApplicatorApertureShape'],
        '0x0433': ['FL', '1', 'ApplicatorOpening'],
        '0x0434': ['FL', '1', 'ApplicatorOpeningX'],
        '0x0435': ['FL', '1', 'ApplicatorOpeningY'],
        '0x0436': ['FL', '1', 'SourceToApplicatorMountingPositionDistance'],
        '0x0440': ['IS', '1', 'NumberOfBlockSlabItems'],
        '0x0441': ['SQ', '1', 'BlockSlabSequence'],
        '0x0442': ['DS', '1', 'BlockSlabThickness'],
        '0x0443': ['US', '1', 'BlockSlabNumber'],
        '0x0450': ['SQ', '1', 'DeviceMotionControlSequence'],
        '0x0451': ['CS', '1', 'DeviceMotionExecutionMode'],
        '0x0452': ['CS', '1', 'DeviceMotionObservationMode'],
        '0x0453': ['SQ', '1', 'DeviceMotionParameterCodeSequence'],
    },
    '0x300C': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['SQ', '1', 'ReferencedRTPlanSequence'],
        '0x0004': ['SQ', '1', 'ReferencedBeamSequence'],
        '0x0006': ['IS', '1', 'ReferencedBeamNumber'],
        '0x0007': ['IS', '1', 'ReferencedReferenceImageNumber'],
        '0x0008': ['DS', '1', 'StartCumulativeMetersetWeight'],
        '0x0009': ['DS', '1', 'EndCumulativeMetersetWeight'],
        '0x000A': ['SQ', '1', 'ReferencedBrachyApplicationSetupSequence'],
        '0x000C': ['IS', '1', 'ReferencedBrachyApplicationSetupNumber'],
        '0x000E': ['IS', '1', 'ReferencedSourceNumber'],
        '0x0020': ['SQ', '1', 'ReferencedFractionGroupSequence'],
        '0x0022': ['IS', '1', 'ReferencedFractionGroupNumber'],
        '0x0040': ['SQ', '1', 'ReferencedVerificationImageSequence'],
        '0x0042': ['SQ', '1', 'ReferencedReferenceImageSequence'],
        '0x0050': ['SQ', '1', 'ReferencedDoseReferenceSequence'],
        '0x0051': ['IS', '1', 'ReferencedDoseReferenceNumber'],
        '0x0055': ['SQ', '1', 'BrachyReferencedDoseReferenceSequence'],
        '0x0060': ['SQ', '1', 'ReferencedStructureSetSequence'],
        '0x006A': ['IS', '1', 'ReferencedPatientSetupNumber'],
        '0x0080': ['SQ', '1', 'ReferencedDoseSequence'],
        '0x00A0': ['IS', '1', 'ReferencedToleranceTableNumber'],
        '0x00B0': ['SQ', '1', 'ReferencedBolusSequence'],
        '0x00C0': ['IS', '1', 'ReferencedWedgeNumber'],
        '0x00D0': ['IS', '1', 'ReferencedCompensatorNumber'],
        '0x00E0': ['IS', '1', 'ReferencedBlockNumber'],
        '0x00F0': ['IS', '1', 'ReferencedControlPointIndex'],
        '0x00F2': ['SQ', '1', 'ReferencedControlPointSequence'],
        '0x00F4': ['IS', '1', 'ReferencedStartControlPointIndex'],
        '0x00F6': ['IS', '1', 'ReferencedStopControlPointIndex'],
        '0x0100': ['IS', '1', 'ReferencedRangeShifterNumber'],
        '0x0102': ['IS', '1', 'ReferencedLateralSpreadingDeviceNumber'],
        '0x0104': ['IS', '1', 'ReferencedRangeModulatorNumber'],
        '0x0111': ['SQ', '1', 'OmittedBeamTaskSequence'],
        '0x0112': ['CS', '1', 'ReasonForOmission'],
        '0x0113': ['LO', '1', 'ReasonForOmissionDescription'],
    },
    '0x300E': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0002': ['CS', '1', 'ApprovalStatus'],
        '0x0004': ['DA', '1', 'ReviewDate'],
        '0x0005': ['TM', '1', 'ReviewTime'],
        '0x0008': ['PN', '1', 'ReviewerName'],
    },
    '0x4000': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['LT', '1', 'Arbitrary'],
        '0x4000': ['LT', '1', 'TextComments'],
    },
    '0x4008': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0040': ['SH', '1', 'ResultsID'],
        '0x0042': ['LO', '1', 'ResultsIDIssuer'],
        '0x0050': ['SQ', '1', 'ReferencedInterpretationSequence'],
        '0x00FF': ['CS', '1', 'ReportProductionStatusTrial'],
        '0x0100': ['DA', '1', 'InterpretationRecordedDate'],
        '0x0101': ['TM', '1', 'InterpretationRecordedTime'],
        '0x0102': ['PN', '1', 'InterpretationRecorder'],
        '0x0103': ['LO', '1', 'ReferenceToRecordedSound'],
        '0x0108': ['DA', '1', 'InterpretationTranscriptionDate'],
        '0x0109': ['TM', '1', 'InterpretationTranscriptionTime'],
        '0x010A': ['PN', '1', 'InterpretationTranscriber'],
        '0x010B': ['ST', '1', 'InterpretationText'],
        '0x010C': ['PN', '1', 'InterpretationAuthor'],
        '0x0111': ['SQ', '1', 'InterpretationApproverSequence'],
        '0x0112': ['DA', '1', 'InterpretationApprovalDate'],
        '0x0113': ['TM', '1', 'InterpretationApprovalTime'],
        '0x0114': ['PN', '1', 'PhysicianApprovingInterpretation'],
        '0x0115': ['LT', '1', 'InterpretationDiagnosisDescription'],
        '0x0117': ['SQ', '1', 'InterpretationDiagnosisCodeSequence'],
        '0x0118': ['SQ', '1', 'ResultsDistributionListSequence'],
        '0x0119': ['PN', '1', 'DistributionName'],
        '0x011A': ['LO', '1', 'DistributionAddress'],
        '0x0200': ['SH', '1', 'InterpretationID'],
        '0x0202': ['LO', '1', 'InterpretationIDIssuer'],
        '0x0210': ['CS', '1', 'InterpretationTypeID'],
        '0x0212': ['CS', '1', 'InterpretationStatusID'],
        '0x0300': ['ST', '1', 'Impressions'],
        '0x4000': ['ST', '1', 'ResultsComments'],
    },
    '0x4010': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['CS', '1', 'LowEnergyDetectors'],
        '0x0002': ['CS', '1', 'HighEnergyDetectors'],
        '0x0004': ['SQ', '1', 'DetectorGeometrySequence'],
        '0x1001': ['SQ', '1', 'ThreatROIVoxelSequence'],
        '0x1004': ['FL', '3', 'ThreatROIBase'],
        '0x1005': ['FL', '3', 'ThreatROIExtents'],
        '0x1006': ['OB', '1', 'ThreatROIBitmap'],
        '0x1007': ['SH', '1', 'RouteSegmentID'],
        '0x1008': ['CS', '1', 'GantryType'],
        '0x1009': ['CS', '1', 'OOIOwnerType'],
        '0x100A': ['SQ', '1', 'RouteSegmentSequence'],
        '0x1010': ['US', '1', 'PotentialThreatObjectID'],
        '0x1011': ['SQ', '1', 'ThreatSequence'],
        '0x1012': ['CS', '1', 'ThreatCategory'],
        '0x1013': ['LT', '1', 'ThreatCategoryDescription'],
        '0x1014': ['CS', '1', 'ATDAbilityAssessment'],
        '0x1015': ['CS', '1', 'ATDAssessmentFlag'],
        '0x1016': ['FL', '1', 'ATDAssessmentProbability'],
        '0x1017': ['FL', '1', 'Mass'],
        '0x1018': ['FL', '1', 'Density'],
        '0x1019': ['FL', '1', 'ZEffective'],
        '0x101A': ['SH', '1', 'BoardingPassID'],
        '0x101B': ['FL', '3', 'CenterOfMass'],
        '0x101C': ['FL', '3', 'CenterOfPTO'],
        '0x101D': ['FL', '6-n', 'BoundingPolygon'],
        '0x101E': ['SH', '1', 'RouteSegmentStartLocationID'],
        '0x101F': ['SH', '1', 'RouteSegmentEndLocationID'],
        '0x1020': ['CS', '1', 'RouteSegmentLocationIDType'],
        '0x1021': ['CS', '1-n', 'AbortReason'],
        '0x1023': ['FL', '1', 'VolumeOfPTO'],
        '0x1024': ['CS', '1', 'AbortFlag'],
        '0x1025': ['DT', '1', 'RouteSegmentStartTime'],
        '0x1026': ['DT', '1', 'RouteSegmentEndTime'],
        '0x1027': ['CS', '1', 'TDRType'],
        '0x1028': ['CS', '1', 'InternationalRouteSegment'],
        '0x1029': ['LO', '1-n', 'ThreatDetectionAlgorithmandVersion'],
        '0x102A': ['SH', '1', 'AssignedLocation'],
        '0x102B': ['DT', '1', 'AlarmDecisionTime'],
        '0x1031': ['CS', '1', 'AlarmDecision'],
        '0x1033': ['US', '1', 'NumberOfTotalObjects'],
        '0x1034': ['US', '1', 'NumberOfAlarmObjects'],
        '0x1037': ['SQ', '1', 'PTORepresentationSequence'],
        '0x1038': ['SQ', '1', 'ATDAssessmentSequence'],
        '0x1039': ['CS', '1', 'TIPType'],
        '0x103A': ['CS', '1', 'DICOSVersion'],
        '0x1041': ['DT', '1', 'OOIOwnerCreationTime'],
        '0x1042': ['CS', '1', 'OOIType'],
        '0x1043': ['FL', '3', 'OOISize'],
        '0x1044': ['CS', '1', 'AcquisitionStatus'],
        '0x1045': ['SQ', '1', 'BasisMaterialsCodeSequence'],
        '0x1046': ['CS', '1', 'PhantomType'],
        '0x1047': ['SQ', '1', 'OOIOwnerSequence'],
        '0x1048': ['CS', '1', 'ScanType'],
        '0x1051': ['LO', '1', 'ItineraryID'],
        '0x1052': ['SH', '1', 'ItineraryIDType'],
        '0x1053': ['LO', '1', 'ItineraryIDAssigningAuthority'],
        '0x1054': ['SH', '1', 'RouteID'],
        '0x1055': ['SH', '1', 'RouteIDAssigningAuthority'],
        '0x1056': ['CS', '1', 'InboundArrivalType'],
        '0x1058': ['SH', '1', 'CarrierID'],
        '0x1059': ['CS', '1', 'CarrierIDAssigningAuthority'],
        '0x1060': ['FL', '3', 'SourceOrientation'],
        '0x1061': ['FL', '3', 'SourcePosition'],
        '0x1062': ['FL', '1', 'BeltHeight'],
        '0x1064': ['SQ', '1', 'AlgorithmRoutingCodeSequence'],
        '0x1067': ['CS', '1', 'TransportClassification'],
        '0x1068': ['LT', '1', 'OOITypeDescriptor'],
        '0x1069': ['FL', '1', 'TotalProcessingTime'],
        '0x106C': ['OB', '1', 'DetectorCalibrationData'],
        '0x106D': ['CS', '1', 'AdditionalScreeningPerformed'],
        '0x106E': ['CS', '1', 'AdditionalInspectionSelectionCriteria'],
        '0x106F': ['SQ', '1', 'AdditionalInspectionMethodSequence'],
        '0x1070': ['CS', '1', 'AITDeviceType'],
        '0x1071': ['SQ', '1', 'QRMeasurementsSequence'],
        '0x1072': ['SQ', '1', 'TargetMaterialSequence'],
        '0x1073': ['FD', '1', 'SNRThreshold'],
        '0x1075': ['DS', '1', 'ImageScaleRepresentation'],
        '0x1076': ['SQ', '1', 'ReferencedPTOSequence'],
        '0x1077': ['SQ', '1', 'ReferencedTDRInstanceSequence'],
        '0x1078': ['ST', '1', 'PTOLocationDescription'],
        '0x1079': ['SQ', '1', 'AnomalyLocatorIndicatorSequence'],
        '0x107A': ['FL', '3', 'AnomalyLocatorIndicator'],
        '0x107B': ['SQ', '1', 'PTORegionSequence'],
        '0x107C': ['CS', '1', 'InspectionSelectionCriteria'],
        '0x107D': ['SQ', '1', 'SecondaryInspectionMethodSequence'],
        '0x107E': ['DS', '6', 'PRCSToRCSOrientation'],
    },
    '0x4FFE': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0001': ['SQ', '1', 'MACParametersSequence'],
    },
    '0x5000': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0005': ['US', '1', 'CurveDimensions'],
        '0x0010': ['US', '1', 'NumberOfPoints'],
        '0x0020': ['CS', '1', 'TypeOfData'],
        '0x0022': ['LO', '1', 'CurveDescription'],
        '0x0030': ['SH', '1-n', 'AxisUnits'],
        '0x0040': ['SH', '1-n', 'AxisLabels'],
        '0x0103': ['US', '1', 'DataValueRepresentation'],
        '0x0104': ['US', '1-n', 'MinimumCoordinateValue'],
        '0x0105': ['US', '1-n', 'MaximumCoordinateValue'],
        '0x0106': ['SH', '1-n', 'CurveRange'],
        '0x0110': ['US', '1-n', 'CurveDataDescriptor'],
        '0x0112': ['US', '1-n', 'CoordinateStartValue'],
        '0x0114': ['US', '1-n', 'CoordinateStepValue'],
        '0x1001': ['CS', '1', 'CurveActivationLayer'],
        '0x2000': ['US', '1', 'AudioType'],
        '0x2002': ['US', '1', 'AudioSampleFormat'],
        '0x2004': ['US', '1', 'NumberOfChannels'],
        '0x2006': ['UL', '1', 'NumberOfSamples'],
        '0x2008': ['UL', '1', 'SampleRate'],
        '0x200A': ['UL', '1', 'TotalTime'],
        '0x200C': ['ox', '1', 'AudioSampleData'],
        '0x200E': ['LT', '1', 'AudioComments'],
        '0x2500': ['LO', '1', 'CurveLabel'],
        '0x2600': ['SQ', '1', 'CurveReferencedOverlaySequence'],
        '0x2610': ['US', '1', 'CurveReferencedOverlayGroup'],
        '0x3000': ['ox', '1', 'CurveData'],
    },
    '0x5200': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x9229': ['SQ', '1', 'SharedFunctionalGroupsSequence'],
        '0x9230': ['SQ', '1', 'PerFrameFunctionalGroupsSequence'],
    },
    '0x5400': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0100': ['SQ', '1', 'WaveformSequence'],
        '0x0110': ['ox', '1', 'ChannelMinimumValue'],
        '0x0112': ['ox', '1', 'ChannelMaximumValue'],
        '0x1004': ['US', '1', 'WaveformBitsAllocated'],
        '0x1006': ['CS', '1', 'WaveformSampleInterpretation'],
        '0x100A': ['ox', '1', 'WaveformPaddingValue'],
        '0x1010': ['ox', '1', 'WaveformData'],
    },
    '0x5600': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['OF', '1', 'FirstOrderPhaseCorrectionAngle'],
        '0x0020': ['OF', '1', 'SpectroscopyData'],
    },
    '0x6000': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['US', '1', 'OverlayRows'],
        '0x0011': ['US', '1', 'OverlayColumns'],
        '0x0012': ['US', '1', 'OverlayPlanes'],
        '0x0015': ['IS', '1', 'NumberOfFramesInOverlay'],
        '0x0022': ['LO', '1', 'OverlayDescription'],
        '0x0040': ['CS', '1', 'OverlayType'],
        '0x0045': ['LO', '1', 'OverlaySubtype'],
        '0x0050': ['SS', '2', 'OverlayOrigin'],
        '0x0051': ['US', '1', 'ImageFrameOrigin'],
        '0x0052': ['US', '1', 'OverlayPlaneOrigin'],
        '0x0060': ['CS', '1', 'OverlayCompressionCode'],
        '0x0061': ['SH', '1', 'OverlayCompressionOriginator'],
        '0x0062': ['SH', '1', 'OverlayCompressionLabel'],
        '0x0063': ['CS', '1', 'OverlayCompressionDescription'],
        '0x0066': ['AT', '1-n', 'OverlayCompressionStepPointers'],
        '0x0068': ['US', '1', 'OverlayRepeatInterval'],
        '0x0069': ['US', '1', 'OverlayBitsGrouped'],
        '0x0100': ['US', '1', 'OverlayBitsAllocated'],
        '0x0102': ['US', '1', 'OverlayBitPosition'],
        '0x0110': ['CS', '1', 'OverlayFormat'],
        '0x0200': ['US', '1', 'OverlayLocation'],
        '0x0800': ['CS', '1-n', 'OverlayCodeLabel'],
        '0x0802': ['US', '1', 'OverlayNumberOfTables'],
        '0x0803': ['AT', '1-n', 'OverlayCodeTableLocation'],
        '0x0804': ['US', '1', 'OverlayBitsForCodeWord'],
        '0x1001': ['CS', '1', 'OverlayActivationLayer'],
        '0x1100': ['US', '1', 'OverlayDescriptorGray'],
        '0x1101': ['US', '1', 'OverlayDescriptorRed'],
        '0x1102': ['US', '1', 'OverlayDescriptorGreen'],
        '0x1103': ['US', '1', 'OverlayDescriptorBlue'],
        '0x1200': ['US', '1-n', 'OverlaysGray'],
        '0x1201': ['US', '1-n', 'OverlaysRed'],
        '0x1202': ['US', '1-n', 'OverlaysGreen'],
        '0x1203': ['US', '1-n', 'OverlaysBlue'],
        '0x1301': ['IS', '1', 'ROIArea'],
        '0x1302': ['DS', '1', 'ROIMean'],
        '0x1303': ['DS', '1', 'ROIStandardDeviation'],
        '0x1500': ['LO', '1', 'OverlayLabel'],
        '0x3000': ['ox', '1', 'OverlayData'],
        '0x4000': ['LT', '1', 'OverlayComments'],
    },
    '0x7FE0': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0008': ['OF', '1', 'FloatPixelData'],
        '0x0009': ['OD', '1', 'DoubleFloatPixelData'],
        '0x0010': ['ox', '1', 'PixelData'],
        '0x0020': ['OW', '1', 'CoefficientsSDVN'],
        '0x0030': ['OW', '1', 'CoefficientsSDHN'],
        '0x0040': ['OW', '1', 'CoefficientsSDDN'],
    },
    '0x7F00': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0x0010': ['ox', '1', 'VariablePixelData'],
        '0x0011': ['US', '1', 'VariableNextDataGroup'],
        '0x0020': ['OW', '1', 'VariableCoefficientsSDVN'],
        '0x0030': ['OW', '1', 'VariableCoefficientsSDHN'],
        '0x0040': ['OW', '1', 'VariableCoefficientsSDDN'],
    },
    '0xFFFA': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0xFFFA': ['SQ', '1', 'DigitalSignaturesSequence'],
    },
    '0xFFFC': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0xFFFC': ['OB', '1', 'DataSetTrailingPadding'],
    },
    '0xFFFE': {
        '0x0000': ['UL', '1', 'GenericGroupLength'],
        '0xE000': ['NONE', '1', 'Item'],
        '0xE00D': ['NONE', '1', 'ItemDelimitationItem'],
        '0xE0DD': ['NONE', '1', 'SequenceDelimitationItem'],
    }
}; // dwv.dicom.Dictionnary

// taken from gdcm-2.6.1\Source\DataDictionary\GroupName.dic
// -> removed duplicates (commented)
dwv.dicom.TagGroups = {
  'x0000' :'Command',
  'x0002': 'Meta Element',
  'x0004': 'File Set',
  //'x0004': 'Directory',
  'x0008': 'Identifying',
  'x0009': 'SPI Identifying',
  'x0010': 'Patient',
  'x0012': 'Clinical Trial',
  'x0018': 'Acquisition',
  'x0019': 'SPI Acquisition',
  'x0020': 'Image',
  'x0021': 'SPI Image',
  'x0022': 'Ophtalmology',
  'x0028': 'Image Presentation',
  'x0032': 'Study',
  'x0038': 'Visit',
  'x003A': 'Waveform',
  'x0040': 'Procedure',
  //'x0040': ''Modality Worklist',
  'x0042': 'Encapsulated Document',
  'x0050': 'Device Informations',
  //'x0050': 'XRay Angio Device',
  'x0054': 'Nuclear Medicine',
  'x0060': 'Histogram',
  'x0070': 'Presentation State',
  'x0072': 'Hanging Protocol',
  'x0088': 'Storage',
  //'x0088': 'Medicine',
  'x0100': 'Authorization',
  'x0400': 'Digital Signature',
  'x1000': 'Code Table',
  'x1010': 'Zonal Map',
  'x2000': 'Film Session',
  'x2010': 'Film Box',
  'x2020': 'Image Box',
  'x2030': 'Annotation',
  'x2040': 'Overlay Box',
  'x2050': 'Presentation LUT',
  'x2100': 'Print Job',
  'x2110': 'Printer',
  'x2120': 'Queue',
  'x2130': 'Print Content',
  'x2200': 'Media Creation',
  'x3002': 'RT Image',
  'x3004': 'RT Dose',
  'x3006': 'RT StructureSet',
  'x3008': 'RT Treatment',
  'x300A': 'RT Plan',
  'x300C': 'RT Relationship',
  'x300E': 'RT Approval',
  'x4000': 'Text',
  'x4008': 'Results',
  'x4FFE': 'MAC Parameters',
  'x5000': 'Curve',
  'x5002': 'Curve',
  'x5004': 'Curve',
  'x5006': 'Curve',
  'x5008': 'Curve',
  'x500A': 'Curve',
  'x500C': 'Curve',
  'x500E': 'Curve',
  'x5400': 'Waveform Data',
  'x6000': 'Overlays',
  'x6002': 'Overlays',
  'x6004': 'Overlays',
  'x6008': 'Overlays',
  'x600A': 'Overlays',
  'x600C': 'Overlays',
  'x600E': 'Overlays',
  'xFFFC': 'Generic',
  'x7FE0': 'Pixel Data',
  'xFFFF': 'Unknown'
  };
