/**
 * Application launcher.
 */
 
// Default colour maps.
dwv.tool.colourMaps = {
    "plain": dwv.image.lut.plain,
    "invplain": dwv.image.lut.invPlain,
    "rainbow": dwv.image.lut.rainbow,
    "hot": dwv.image.lut.hot,
    "hot iron": dwv.image.lut.hot_iron,
    "pet": dwv.image.lut.pet,
    "hot metal blue": dwv.image.lut.hot_metal_blue,
    "pet 20 step": dwv.image.lut.pet_20step
};
// Default window level presets.
dwv.tool.defaultpresets = {};
// Default window level presets for CT.
dwv.tool.defaultpresets.CT = {
    "mediastinum": {"center": 40, "width": 400},
    "lung": {"center": -500, "width": 1500},
    "bone": {"center": 500, "width": 2000},
    "brain": {"center": 40, "width": 80},
    "head": {"center": 90, "width": 350}
};

//decode query
dwv.utils.decodeQuery = function (query, callback)
{
    if (query.type === "gdrive") {
        var gAuth = new dwv.google.Auth();
        var gDrive = new dwv.google.Drive();
        gDrive.setIds( query.input.split(',') );
        // pipeline
        gAuth.onload = gDrive.load;
        gAuth.onfail = function () {
            $("#popupAuth").popup("open");
            var authorizeButton = document.getElementById('gauth-button');
            // explicit auth from button to allow popup
            authorizeButton.onclick = function() {
                $("#popupAuth").popup("close");
                gAuth.load();
            };
        };
        gDrive.onload = dwv.google.getAuthorizedCallback(callback);
        // launch with silent auth
        gAuth.loadSilent();
    }
    else {
        // default
        dwv.utils.base.decodeQuery(query, callback);
    }
};

// Window
dwv.gui.getWindowSize = function () {
    return { 'width': ($(window).width()), 'height': ($(window).height() - 147) };
};
// Progress
dwv.gui.displayProgress = function (percent) {
    if( percent < 100 ) {
        $.mobile.loading("show", {text: percent+"%", textVisible: true, theme: "b"} );
    }
    else if( percent === 100 ) {
        $.mobile.loading("hide");
    }
};
// get element
dwv.gui.getElement = dwv.gui.base.getElement;
// refresh
dwv.gui.refreshElement = function (element) {
    if( $(element)[0].nodeName.toLowerCase() === 'select' ) {
        $(element).selectmenu('refresh');
    }
    else {
        $(element).enhanceWithin();
    }
};
// Slider
dwv.gui.Slider = dwv.gui.base.Slider;
// Tags gui
dwv.gui.DicomTags = dwv.gui.base.DicomTags;

// Loaders
dwv.gui.Loadbox = dwv.gui.base.Loadbox;
// File loader
dwv.gui.FileLoad = dwv.gui.base.FileLoad;
dwv.gui.FileLoad.prototype.onchange = function (/*event*/) {
    $("#popupOpen").popup("close");
};
// Url loader
dwv.gui.UrlLoad = dwv.gui.base.UrlLoad;
dwv.gui.UrlLoad.prototype.onchange = function (/*event*/) {
    $("#popupOpen").popup("close");
};

// Toolbox
dwv.gui.Toolbox = function (app)
{
    var base = new dwv.gui.base.Toolbox(app);
	var node_b;
	var buttonClass;
	
    this.setup = function (list)
    {
        base.setup(list);

        // toolbar
        buttonClass = "ui-btn ui-btn-inline ui-btn-icon-notext ui-mini";
        var bt;
		var node = app.getElement("toolbar");
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Zoom & Pan";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_zoom");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Zoom Reset";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_reset");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Window & Level";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_level");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Window Level Min Max";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_mix_max");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Plain";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_plain");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Invplain";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_invplain");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Rainbow";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_rainbow");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Hot";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_hot");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Hot Iron";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_hot_iron");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Hot Metal Blue";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_pet_blue");
        node.appendChild(bt);
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Pet";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_pet");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Pet 20 step";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_hot_20");
        node.appendChild(bt);
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Info";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_info");
        node.appendChild(bt);

		bt = document.createElement("a");
        bt.href = "#tags_page";
		bt.title = "Dicom Tags";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_tag");
        node.appendChild(bt);


/*		
        var open = document.createElement("a");
        open.href = "#popupOpen";
        open.setAttribute("class", buttonClass + " ui-icon-plus");
        open.setAttribute("data-rel", "popup");
        open.setAttribute("data-position-to", "window");

        var undo = document.createElement("a");
        undo.setAttribute("class", buttonClass + " ui-icon-back");
        undo.onclick = app.onUndo;

        var redo = document.createElement("a");
        redo.setAttribute("class", buttonClass + " ui-icon-forward");
        redo.onclick = app.onToolClick;

        var toggleInfo = document.createElement("a");
        toggleInfo.setAttribute("class", buttonClass + " ui-icon-info");
        toggleInfo.onclick = app.onToggleInfoLayer;

        var toggleSaveState = document.createElement("a");
        toggleSaveState.setAttribute("class", buttonClass + " download-state ui-icon-action");
        toggleSaveState.onclick = app.onStateSave;
        toggleSaveState.download = "state.json";

        var tags = document.createElement("a");
        tags.href = "#tags_page";
        tags.setAttribute("class", buttonClass + " ui-icon-grid");

        
        node.appendChild(open);
        node.appendChild(zoom);
        node.appendChild(level);
        node.appendChild(undo);
        node.appendChild(redo);
        node.appendChild(toggleInfo);
        node.appendChild(toggleSaveState);
        node.appendChild(tags);
		*/
		
		/*--------------------toolbar_bom--------------------------*/
        node_b = app.getElement("toolbar_bom");
		node_b.style.display = "inline";
        
		bt = document.createElement("a");
		bt.onclick = app.onUndo;;
		bt.title = "Un do";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_undo");
        node_b.appendChild(bt);
		
		bt = document.createElement("a");
        bt.onclick = app.onRedo;;
		bt.title = "Re do";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_redo");
        node_b.appendChild(bt);
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Measure";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_line");
        node_b.appendChild(bt);
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Rectangle";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_rect");
        node_b.appendChild(bt);
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Ellipse";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_ellip");
        node_b.appendChild(bt);		
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Protractor";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_protrack");
        node_b.appendChild(bt);
		
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Roi";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_roi");
        node_b.appendChild(bt);
	
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Livewire";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_livewire");
        node_b.appendChild(bt);
			
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Sharpen";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_shapen");
        node_b.appendChild(bt);
	
		bt = document.createElement("a");
        bt.onclick = app.onToolClick;
		bt.title = "Sobel";
        bt.setAttribute("class", buttonClass + " png_icon_g icon_sobel");
        node_b.appendChild(bt);
	
		//var xx = window.document.getElementById("threshold-div");
		//node_b.appendChild(xx);
		/*
        var min = 0;
        var max = 1;
		var inputMin = document.createElement("input");
        inputMin.id = "threshold-min";
        inputMin.type = "range";
        inputMin.max = max;
        inputMin.min = min;
        inputMin.value = min;
        // maximum input
        var inputMax = document.createElement("input");
        inputMax.id = "threshold-max";
        inputMax.type = "range";
        inputMax.max = max;
        inputMax.min = min;
        inputMax.value = max;
		var div = document.createElement("div");
        div.id = "threshold-div";
        div.setAttribute("data-role", "rangeslider");
        div.appendChild(inputMin);
        div.appendChild(inputMax);
        div.setAttribute("data-mini", "true");
       // bind change
        $("#threshold-div").on("change",
                function() {
                    app.onChangeMinMax(
                        { "min":$("#threshold-min").val(),
                          "max":$("#threshold-max").val() } );
                }
            );
		sdiv.appendChild(div);	
        node_b.appendChild(sdiv);*/
		/*--------------------toolbar_bom--------------------------*/

        dwv.gui.refreshElement(node);
        dwv.gui.refreshElement(node_b);
    };
    this.display = function (flag)
    {
        base.display(flag);
    };
    this.initialise = function (list)
    {
        base.initialise(list);
		
		var sdiv = document.createElement("div");
        sdiv.id = "slider-div";
		sdiv.setAttribute("class", "ui-btn ui-btn-icon-notext ui-mini" );
		sdiv.setAttribute("style", "display:inline-block;width:230px;overflow:hidden;padding:0;margin:0;background:#eee; background-color:#eee;position: inherit;" );
		var xx = window.document.getElementById("threshold-div");
		xx.setAttribute("style", "padding:0;margin:0;" );
		sdiv.appendChild(xx);
		node_b.appendChild(sdiv);
    };
};

// Window/level
dwv.gui.WindowLevel = dwv.gui.base.WindowLevel;
// Draw
dwv.gui.Draw = dwv.gui.base.Draw;
// Livewire
dwv.gui.Livewire = dwv.gui.base.Livewire;
// ZoomAndPan
dwv.gui.ZoomAndPan = dwv.gui.base.ZoomAndPan;
// Scroll
dwv.gui.Scroll = dwv.gui.base.Scroll;
// Filter
dwv.gui.Filter = dwv.gui.base.Filter;

// Filter: threshold
dwv.gui.Threshold = dwv.gui.base.Threshold;
// Filter: sharpen
dwv.gui.Sharpen = dwv.gui.base.Sharpen;
// Filter: sobel
dwv.gui.Sobel = dwv.gui.base.Sobel;

// Undo/redo
dwv.gui.Undo = dwv.gui.base.Undo;
// Help
dwv.gui.appendHelpHtml = dwv.gui.base.appendHelpHtml;
// Version
dwv.gui.appendVersionHtml = dwv.gui.base.appendVersionHtml;

// check browser support
dwv.browser.check();

// launch when page is loaded
$(document).ready( function()
{
    // main application
    var myapp = new dwv.App();

    // display loading time
    var listener = function (event) { 
        if (event.type === "load-start") {
            console.time("load-data");
        }
        else {
            console.timeEnd("load-data");
        }
    };
    // before myapp.init since it does the url load
    myapp.addEventListener("load-start", listener);
    myapp.addEventListener("load-end", listener);
    
    // also available:
    //myapp.addEventListener("load-progress", listener);
    //myapp.addEventListener("draw-create", listener);
    //myapp.addEventListener("draw-move", listener);
    //myapp.addEventListener("draw-change", listener);
    //myapp.addEventListener("draw-delete", listener);
    //myapp.addEventListener("wl-change", listener);
    //myapp.addEventListener("colour-change", listener);
    //myapp.addEventListener("position-change", listener);
    //myapp.addEventListener("slice-change", listener);

    // initialise the application
    myapp.init({
        "containerDivId": "dwv",
        "fitToWindow": true,
        "gui": ["tool", "load", "help", "undo", "version", "tags"],
        "loaders": ["File", "Url"],
        "tools": ["Scroll", "Window/Level", "Zoom/Pan", "Draw", "Livewire", "Filter"],
        "filters": ["Threshold", "Sharpen", "Sobel"],
        "shapes": ["Line", "Protractor", "Rectangle", "Roi", "Ellipse"],
        "isMobile": false,
        "useWebWorkers": false
    });


    var size = dwv.gui.getWindowSize();
    $(".layerContainer").height(size.height);

	if ( fileurl == "" )
	{
		var sfiles =  new Array();
		sfiles[0] = top.window.arr_fileob[file_id];
		myapp.loadFiles(sfiles);
	}
	else
	{
		myapp.loadURLs([fileurl]);
	}
});
