<?php // encoding: utf-8
	error_reporting(0);
	
	include_once("shell_safe_fun.php");
	
	//----------------function---------------------------
	function output_intime($txt)
	{
			echo str_pad(" ", 2046);
			echo $txt;
			ob_flush();
			flush();
	}

	function check_file_avaible($path)
	{
		clearstatcache();
		if ( file_exists($path)&& filesize($path) > 0 )
		{	
			return true;
		}
		else
		{
			return false;
		}
	}
	
	function extend_2($file_name)  
	{  
		$extend = pathinfo($file_name);  
		$extend = strtolower($extend["extension"]);  
		return $extend;  
	}  	

	function outputloginfo( $info )
	{
		$now = date("Y-m-d H:m:s", time());
		
		$file="/tmp/ofoctrunlog.log";
		$f = fopen($file, 'a');
		fwrite($f, "-- $now --:".$info );
		fwrite($f, "\r\n" );
		fclose($f);
		
		//echo "-- $now --:".$info;
		//echo "\r\n";
	}

	function outputloginfo_err( $info )
	{
		$now = date("Y-m-d H:m:s", time());
		
		$file="/tmp/ofoctrun_err.log";
		$f = fopen($file, 'a');
		fwrite($f, "-- $now --:".$info );
		fwrite($f, "\r\n" );
		fclose($f);
	}


	function runExternal( $cmd )
	{

		$descriptorspec = array(
		0 => array("pipe", "r"), // stdin is a pipe that the child will read from
		1 => array("pipe", "w"), // stdout is a pipe that the child will write to
		2 => array("pipe", "w") // stderr is a file to write to
		);
		
		$pipes= array();
		$process = proc_open($cmd, $descriptorspec, $pipes);
		
		$output= "";

		if (!@is_resource($process)) return false;

		#close child's input imidiately
		fclose($pipes[0]);

		stream_set_blocking($pipes[1],false);
		stream_set_blocking($pipes[2],false);
		
		$todo= array($pipes[1],$pipes[2]);
		while( true ) {
			$read= array();
			if( !feof($pipes[1]) ) $read[]= $pipes[1];
			if( !feof($pipes[2]) ) $read[]= $pipes[2];
			
			if (!$read) break;
			
			$ready= stream_select($read, $write=NULL, $ex= NULL, 2);
			
			if ($ready === false) {
				break; #should never happen - something died
			}
			
			foreach ($read as $r) {
				$s= fread($r,1024);
				$output.= $s;
			}
		}

		fclose($pipes[1]);
		fclose($pipes[2]);
		
		proc_close($process);
		
		return $output;
	}
	function getparam($item)
	{
		$value = isset($_GET[$item]) ? $_GET[$item] : (isset($_POST[$item]) ? $_POST[$item] : '');
		return $value;
	}

	function check_filetype_by_url($fileurl)
	{
		$extension = pathinfo($fileurl, PATHINFO_EXTENSION);
		$extension = strtolower($extension);
		//echo "11 $extension -- <br>";
		$mapinfo = array(
			'ai' 	=> 'ai',
			'eps' 	=> 'eps',
			'xps' 	=> 'xps',
			'cdr' 	=> 'cdr',
			'djvu' 	=> 'djvu',
			'djv' 	=> 'djvu',
			'oxps' 	=> 'oxps',
			'psd' 	=> 'psd',
			'svg' 	=> 'svg',
			'tiff' 	=> 'tiff',
			'tif' 	=> 'tiff',
			'cr2' 	=> 'cr2',
			'dcm' 	=> 'dcm',
			'epub' 	=> 'epub',
			'vsd' 	=> 'vsd',
			'doc' 	=> 'doc',
			'docx' 	=> 'docx',
			'ppt' 	=> 'ppt',
			'pptx' 	=> 'pptx',
			'xls' 	=> 'xls',
			'xlsx' 	=> 'xlsx'
		);
		if ( isset($mapinfo[$extension]) )
		{
			
			return $mapinfo[$extension];
		}

		$xx = get_headers($fileurl,1);
		if ( isset($xx['Content-Disposition']) )
		{
			$tmp = $xx['Content-Disposition'];
			//echo "12 $tmp -- <br>";
			$tmp = strtolower($tmp);
			if ( strpos($tmp, '.ai"') !== FALSE )
			{
				return "ai";
			}
			else if ( strpos($tmp, '.psd"') !== FALSE )
			{
				return "psd";
			}
			else if ( strpos($tmp, '.eps"') !== FALSE )
			{
				return "eps";
			}
			else if ( strpos($tmp, '.xps"') !== FALSE )
			{
				return "xps";
			}
			else if ( strpos($tmp, '.cdr"') !== FALSE )
			{
				return "cdr";
			}
			else if ( strpos($tmp, '.djvu"') !== FALSE || strpos($tmp, '.djv"') !== FALSE )
			{
				return "djvu";
			}
			else if ( strpos($tmp, '.oxps"') !== FALSE )
			{
				return "oxps";
			}
			else if ( strpos($tmp, '.svg"') !== FALSE )
			{
				return "svg";
			}
			else if ( strpos($tmp, '.tiff"') !== FALSE || strpos($tmp, '.tif"') !== FALSE )
			{
				return "tiff";
			}
			else if ( strpos($tmp, '.cr2"') !== FALSE )
			{
				return "cr2";
			}
			else if ( strpos($tmp, '.dcm"') !== FALSE )
			{
				return "dcm";
			}
			else if ( strpos($tmp, '.epub"') !== FALSE )
			{
				return "epub";
			}
			else if ( strpos($tmp, '.vsd"') !== FALSE )
			{
				return "vsd";
			}
			else if ( strpos($tmp, '.doc"') !== FALSE )
			{
				return "doc";
			}
			else if ( strpos($tmp, '.docx"') !== FALSE )
			{
				return "docx";
			}
			else if ( strpos($tmp, '.xls"') !== FALSE )
			{
				return "xls";
			}
			else if ( strpos($tmp, '.xlsx"') !== FALSE )
			{
				return "xlsx";
			}
			else if ( strpos($tmp, '.ppt"') !== FALSE )
			{
				return "ppt";
			}
			else if ( strpos($tmp, '.pptx"') !== FALSE )
			{
				return "pptx";
			}
		}

		if ( isset($xx['Content-Type']) )
		{
			$tmp = $xx['Content-Type'];
			$map = array(
				'application/postscript'   => 'ai',
				'application/oxps'   => 'oxps',
				'application/vnd.ms-xpsdocument'   => 'xps',
				'image/vnd.adobe.photoshop'   => 'psd',
				'image/x-coreldraw'   => 'cdr',
				'image/vnd.djvu'   => 'djvu',
				'image/svg+xml'   => 'svg',
				'image/tiff'   => 'tiff',
				'image/tif'   => 'tif',
				'image/cr2'   => 'cr2',
				'image/nef'   => 'nef',
				'image/dcm'   => 'dcm',
				'image/dicom'   => 'dcm',
				'application/epub+zip'   => 'epub',
				'image/nef'   => 'nef',
				'application/vnd.visio'   => 'vsd',
				'application/msword'   => 'doc',
				'application/vnd.openxmlformats-officedocument.wordprocessingml.document'   => 'docx',
				'application/vnd.ms-excel'   => 'xls',
				'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'   => 'xlsx',
				'application/vnd.ms-powerpoint'   => 'ppt',
				'application/vnd.openxmlformats-officedocument.presentationml.presentation'   => 'pptx'
			);
			if (isset($map[$tmp]))
			{
				//echo "13 $tmp -- <br>";           
				return $map[$tmp];
			}
		}	
		
		return "";
	}

	function get_file_by_url($fileurl)
	{
		$temp_dir = tempnam(sys_get_temp_dir(), 'tmp');
		$temp_dir = str_replace(".tmp", "", $temp_dir);
		
		//--create folder
		$cmd_line = "rm ".$temp_dir;
		runExternal($cmd_line);
		$cmd_line = "mkdir ".$temp_dir;
		runExternal($cmd_line);
		//cd folder 
		$cmd_line = "cd ".$temp_dir;
		runExternal($cmd_line);
		//wget 
		$cmd_line = "wget --no-check-certificate -P $temp_dir $fileurl";
		runExternal($cmd_line);
		//ls
		$cmd_line = "ls $temp_dir";
		$ret = runExternal($cmd_line);

		$tmpfile = "/tmp/$ret";
		if (!check_file_avaible($tmpfile)) 
		{
			return "";
		}	
		
		return $tmpfile;
	}

	//-------------------main ------------------------------

	//--get params
	$cid 				= getparam('cid');
	$output 			= getparam('output');
	$output 			= get_safe_shell_param($output);
	$downloadsavename 	= getparam('downloadsavename');
	$tmpfpath 			= getparam('tmpfpath');
	$tmpfpath 			= get_safe_shell_param($tmpfpath);
	$frmid 				= getparam('frmid');
	$quality 			= getparam('quality');
	$fileurl 			= getparam('fileurl');
	$showads 			= getparam('showads');
	$filetype 			= getparam('filetype');

	//--from url 
	if ( $fileurl != "")
	{
		if ( $filetype == "" )
		{
			//check file type
			$checktype = check_filetype_by_url($fileurl);
			if ($checktype == "")
			{
				output_intime("can't check the file type. you can to set param filetype. example: http://www.ofoct.com/?...&filetype=psd");
				exit;
			}
			$filetype = $checktype;
			$downloadsavename = "filesavename";
			//download file
			$temp_file_source = tempnam(sys_get_temp_dir(), 'tmp');
			$temp_file_source = $temp_file_source.".$filetype";
			file_put_contents($temp_file_source, fopen($fileurl, 'r'));
			$tmpfpath = $temp_file_source;
			if ( !check_file_avaible($tmpfpath) ) 
			{
				echo "can't get the file from url:$fileurl";
				exit;
			}
		}
		if ( $filetype == "dcm" )
		{
			$cid = "dicom_viewer";
		}
		if ( $filetype == "epub" )
		{
			$cid = "epub_viewer";
		}
		else if ( $filetype == "nef" ||  $filetype == "cr2" )
		{
			$cid = "cr2_viewer";
		}
		else if ( $filetype == "tiff" ||  $filetype == "tif" )
		{
			$cid = "tiff_viewer";
		}
		else if ( $filetype == "djvu" ||  $filetype == "djv" )
		{
			$cid = "djvu_viewer";
		}
		else if ( $filetype == "xps" ||  $filetype == "oxps" )
		{
			$cid = "xps_viewer";
		}
		else if ( $filetype == "doc" ||  $filetype == "docx" ||  $filetype == "xls" ||  $filetype == "xlsx" ||  $filetype == "ppt" ||  $filetype == "pptx" )
		{
			$cid = "office_viewer";
		}
		else
		{
			$cid = $filetype."_viewer";
		}
	}

	if ( $cid != "dicom_viewer" && $cid != "epub_viewer" )
	{
		//--check input file
		if (!check_file_avaible($tmpfpath) ) 
		{
			$retstr = "ERROR: Can not find the upload file! or the view file has expired. please upload again.";
			output_intime( $retstr );
			exit;
		}
	}
	
	//--Converting
	$out_ext = '';
	if ($cid == "ai_viewer" or $cid == "eps_viewer" )
	{
		$out_ext = ".jpg";
	}
	else if($cid == "psd_viewer" or $cid == "svg_viewer" or $cid == "tiff_viewer" or $cid == "cr2_viewer" or $cid == "cdr_viewer"  )
	{
		$out_ext = ".png";
	}
	else if($cid == "dicom_viewer" )
	{
		$out_ext = "";
	}
	else if($cid == "epub_viewer" )
	{
		$out_ext = "";
	}
	else if($cid == "vsd_viewer" )
	{
		$out_ext = ".png";
	}
	else if($cid == "djvu_viewer" )
	{
		$out_ext = "";
	}
	else if($cid == "office_viewer" or $cid == "xps_viewer")
	{
		$out_ext = ".png";
	}
	else
	{
		$out_ext = "";
		output_intime("cid param error!");
		exit;
	}
	$downloadsavename = $downloadsavename.$out_ext;
	$out_file_path = $tmpfpath.$out_ext;
	$cmd_line = '';
	if( $cid == "ai_viewer" or $cid == "eps_viewer"  )
	{
		$cmd_line = "";
		if ( $quality == "high-resolution" )
		{
			$cmd_line = "/usr/bin/convert -density 500 $tmpfpath $out_file_path";
		}
		else
		{
			$cmd_line = "/usr/bin/convert $tmpfpath $out_file_path";
		}
		outputloginfo($cmd_line);
		runExternal($cmd_line);
		if ( !check_file_avaible($out_file_path) )
		{
			$cmd_line = "gimp -d -i -b '(imgconv \"$tmpfpath\" \"$out_file_path\")' -b '(gimp-quit 0)'";
			outputloginfo($cmd_line);
			runExternal($cmd_line);
		}
	}
	else if( $cid == "cdr_viewer" )
	{
		$mid_file_path = $tmpfpath.".svg";
		
		//convert to svg 
		$cmd_line = "/usr/bin/uniconvertor $tmpfpath $mid_file_path";
		runExternal($cmd_line);
		outputloginfo($cmd_line);
	
		if ( $quality == "high-resolution" )
		{
			$cmd_line = "/usr/bin/rsvg-convert -d 200 -p 200 -z 2.0 $mid_file_path -f png -o $out_file_path";
		}
		else
		{
			$cmd_line = "/usr/bin/rsvg-convert -z 1.5 $mid_file_path -f png -o $out_file_path";
		}
		//convert to png 
		outputloginfo($cmd_line);
		runExternal($cmd_line);
		
		/*
		//convert to png 
		$mid_file_path = $tmpfpath.".ai";
		$cmd_line = "/usr/bin/uniconvertor $tmpfpath $mid_file_path";
		runExternal($cmd_line);
		outputloginfo($cmd_line);
		if ( $quality == "high-resolution" )
		{
			$cmd_line = "/usr/bin/convert -density 300 $mid_file_path $out_file_path";
		}
		else
		{
			$cmd_line = "/usr/bin/convert $mid_file_path $out_file_path";
		}
		outputloginfo($cmd_line);
		runExternal($cmd_line);
		*/
	}
	else if( $cid == "cr2_viewer" )
	{
		$cmd_line = "/usr/bin/ufraw-batch --out-type png --overwrite $tmpfpath";
		$out_file_path = $tmpfpath;
		$out_file_path = str_replace(".cr2",".png",$out_file_path);
		$out_file_path = str_replace(".CR2",".png",$out_file_path);
		$out_file_path = str_replace(".nef",".png",$out_file_path);
		$out_file_path = str_replace(".NEF",".png",$out_file_path);
		outputloginfo($cmd_line);
		runExternal($cmd_line);
	}
	else if ( $cid == "psd_viewer" )
	{
		//all layer to one png
		$density = "";
		if ( $quality == "high-resolution" )
		{
			$density = "-density 300";
		}
		else
		{
			$density = "-density 100";
		}
		
		$cmd_line = "/usr/bin/convert $density $tmpfpath -flatten $out_file_path";
		outputloginfo($cmd_line);
		runExternal($cmd_line);
		
		//split layer to separately png
		$cmd_line = "/usr/bin/convert $density $tmpfpath $out_file_path";
		outputloginfo($cmd_line);
		runExternal($cmd_line);
	}
	else if ( $cid == "svg_viewer" )
	{
		$cmd_line = "";
		if ( $quality == "high-resolution" )
		{
			//$cmd_line = "/usr/bin/convert -density 500 $tmpfpath -flatten $out_file_path";
			//$cmd_line = "/root/ofoct/ImageMagick-6.9.2-5/utilities/convert $tmpfpath -set density 200 $out_file_path";
			$cmd_line = "/usr/bin/rsvg-convert -d 300 -p 300 -z 3.0 $tmpfpath -f png -o $out_file_path";
		}
		else
		{
			//$cmd_line = "gimp -d -i -b '(imgconv \"$tmpfpath\" \"$out_file_path\")' -b '(gimp-quit 0)'";
			$cmd_line = "/usr/bin/rsvg-convert -z 1.5 $tmpfpath -f png -o $out_file_path";
		}
		//$cmd_line = "/usr/bin/convert -size 800x600 $tmpfpath -flatten $out_file_path";
		outputloginfo($cmd_line);
		runExternal($cmd_line);
		if ( !check_file_avaible($out_file_path) )
		{
			$cmd_line = "gimp -d -i -b '(imgconv \"$tmpfpath\" \"$out_file_path\")' -b '(gimp-quit 0)'";
			outputloginfo($cmd_line);
			runExternal($cmd_line);
			if ( !check_file_avaible($out_file_path) )
			{
				$cmd_line = "/usr/bin/convert -size 800x600 $tmpfpath -flatten $out_file_path";
				outputloginfo($cmd_line);
				runExternal($cmd_line);
			}
		}
		//$cmd_line = "ls $out_file_path -l";
		//echo runExternal($cmd_line);
	}
	else if ( $cid == "tiff_viewer" )
	{
		$cmd_line = "";
		if ( $quality == "high-resolution" )
		{
			$cmd_line = "/usr/bin/convert -density 500 $tmpfpath -flatten $out_file_path";
		}
		else
		{
			$cmd_line = "/usr/bin/convert -density 150 $tmpfpath -flatten $out_file_path";
		}
		//$cmd_line = "/usr/bin/convert -size 800x600 $tmpfpath -flatten $out_file_path";
		outputloginfo($cmd_line);
		runExternal($cmd_line);
		if ( !check_file_avaible($out_file_path) )
		{
			//$cmd_line = "/usr/bin/convert $tmpfpath -flatten $out_file_path";
			$cmd_line = "gimp -d -i -b '(imgconv \"$tmpfpath\" \"$out_file_path\")' -b '(gimp-quit 0)'";
			outputloginfo($cmd_line);
			runExternal($cmd_line);
		}		
	}
	else if ( $cid == "vsd_viewer" )
	{
		$mid_file_path = $tmpfpath.".svg";

		$density = "";
		if ( $quality == "high-resolution" )
		{
			$density = "-z 3.5";
		}
		else
		{
			$density = "-z 2.0";
		}
		
		//convert vsd to svg 
		/*"export LD_LIBRARY_PATH=/gcc/gcc-4.6.4/lib2/lib"; */
		$cmd_line = "/root/ofoct/vsd2svg/bin/vsd2svg -a $tmpfpath $mid_file_path";
		outputloginfo($cmd_line);
		runExternal($cmd_line);
		
		$pt = 1;
		$s_lfilename = str_replace(".svg","$pt.svg",$mid_file_path);
		$d_lfilename = str_replace(".svg","-$pt.png",$mid_file_path);
		while( file_exists($s_lfilename) )
		{
			//$cmd_line = "/usr/bin/convert $density $s_lfilename -flatten $d_lfilename";
			//$cmd_line = "gimp -d -i -b '(imgconv \"$s_lfilename\" \"$d_lfilename\")' -b '(gimp-quit 0)'";
			$cmd_line = "/usr/bin/rsvg-convert $density $s_lfilename -f png -o $d_lfilename";
			runExternal($cmd_line);
			outputloginfo($cmd_line);
			$pt = $pt + 1;
			$s_lfilename = str_replace(".svg","$pt.svg",$mid_file_path);
			$d_lfilename = str_replace(".svg","-$pt.png",$mid_file_path);
		}
		
		//convert svg to png 
		//$cmd_line = "/usr/bin/convert -size 800x600 $mid_file_path -flatten $out_file_path";
		$lfilename = str_replace(".svg","1.svg",$mid_file_path);
		//$cmd_line = "gimp -d -i -b '(imgconv \"$lfilename\" \"$out_file_path\")' -b '(gimp-quit 0)'";
		outputloginfo($cmd_line);
		runExternal($cmd_line);
	}
	else if ( $cid == "dicom_viewer" )
	{
		//no need converting
		$out_file_path = $tmpfpath;
	}
	else if ( $cid == "epub_viewer" )
	{
		//no need converting
		$out_file_path = $tmpfpath;
	}
	else if ( $cid == "djvu_viewer" )
	{
		//no need converting
		$out_file_path = $tmpfpath;
	}
	else if ( $cid == "office_viewer" )
	{
		$mid_file_path = $tmpfpath.".pdf";
		
		//convert office to pdf 
		$cmd_line = "/opt/openoffice.org3/program/python /root/script/DocumentConverter.py $tmpfpath $mid_file_path";
		runExternal($cmd_line);
		outputloginfo($cmd_line);

		if ( check_file_avaible($mid_file_path) ) 
		{
			//convert pdf to jpg files
			//$fileexn = extend_2($tmpfpath);
			//$outpngfile = str_replace( ".$fileexn", "", $tmpfpath);
			if ( $quality == "high-resolution" )
			{
				$cmd_line = "/usr/bin/convert -density 300 -quality 100 $mid_file_path $tmpfpath-%d.png ";
			}
			else
			{
				$cmd_line = "/usr/bin/convert -density 100 -quality 100 $mid_file_path $tmpfpath-%d.png ";
			}
			runExternal($cmd_line);
			outputloginfo($cmd_line);
		}
	}
	else if ( $cid == "xps_viewer" )
	{
		/*$mid_file_path = $tmpfpath.".pdf";
		
		//convert office to pdf 
		$cmd_line = "/root/xps/ghostxps-9.19-linux-x86_64/gxps sDEVICE=pdfwrite -sOutputFile=$mid_file_path -dNOPAUSE $tmpfpath";
		runExternal($cmd_line);
		outputloginfo($cmd_line);

		if ( check_file_avaible($mid_file_path) ) 
		{
			//convert pdf to jpg files
			//$fileexn = extend_2($tmpfpath);
			//$outpngfile = str_replace( ".$fileexn", "", $tmpfpath);
			if ( $quality == "high-resolution" )
			{
				$cmd_line = "/usr/bin/convert -density 300 -quality 100 $mid_file_path $tmpfpath-%d.png ";
			}
			else
			{
				$cmd_line = "/usr/bin/convert -density 100 -quality 100 $mid_file_path $tmpfpath-%d.png ";
			}
			runExternal($cmd_line);
			outputloginfo($cmd_line);
		}
		else
		{
			outputloginfo_err("ERROR: Convert failed! source:$tmpfpath, dest:$mid_file_path");
			outputloginfo_err($cmd_line);
			echo "ERROR: Convert failed!";
			exit;
		}*/
		
		//convert xps to png 
		if ( $quality == "high-resolution" )
		{
			$cmd_line = "/root/xps/mupdf/mupdf/build/release/mutool draw -o $tmpfpath-%d.png -r 500 $tmpfpath";
		}
		else
		{
			$cmd_line = "/root/xps/mupdf/mupdf/build/release/mutool draw -o $tmpfpath-%d.png -r 300 $tmpfpath";
		}
		runExternal($cmd_line);
		outputloginfo($cmd_line);
	}
	
	//--check convert result
	if ( $cid != "vsd_viewer" && $cid != "office_viewer"  &&  $cid != "dicom_viewer" &&  $cid != "epub_viewer" && $cid != "xps_viewer" && $cid != "djvu_viewer")
	{
		if ( !check_file_avaible($out_file_path) )
		{
			$filesize = filesize($out_file_path);
			outputloginfo_err("ERROR: Convert failed! filesize:$filesize, source:$tmpfpath, dest:$out_file_path");
			outputloginfo_err($cmd_line);
			echo "ERROR: Convert failed!";
			exit;
		}
	}
	
	//--output html code
	$retstr = "";
	$adsscript = "";
	$htmlbegin = "";
	$htmlmid = "";
	$htmlend = "";

	if ( $showads != "hide" )
	{
		$adsscript = <<<EOF

EOF;
	}

	if (!( $frmid == "" ))
	{
		//viewer in iframe
		$htmlbegin = <<<EOF
			<html>
				<head>
					<title>$cid - $downloadsavename</title>
						<style type="text/css">
							body, html, #main{
								width: 100%;
								height: 100%;
								margin: 0px;
								padding: 0px;
								text-align:center;
								background-color: #eee;
							}
						</style>
EOF;
		$htmlmid =  <<<EOF
				</head>
				<body>
					<div id="main" >
EOF;
		$htmlend =  <<<EOF
					</div>
				</body>
			</html>
EOF;
		
	}

	$nwidth = 0;$nheight = 0;
	if( $cid == "ai_viewer" or $cid == "eps_viewer"  or $cid == "cdr_viewer" or $cid == "svg_viewer" or $cid == "tiff_viewer" or $cid == "cr2_viewer" )
	{
		list($nwidth, $nheight) = getimagesize($out_file_path);
		$downloadsavename = urlencode($downloadsavename);
		$out_file_path = urlencode($out_file_path);
		$retstr = <<<EOF
			$htmlbegin
						<style>	
							.smooth_zoom_preloader {
								background-image: url(/zoom_assets/preloader.gif);
							}	
							.smooth_zoom_icons {
								background-image: url(/zoom_assets/icons.png);
							}
						</style>
						<script src="/zoom_assets/jquery-1.11.1.min.js"></script>
						<script src="/zoom_assets/jquery.smoothZoom.min.js"></script>
						
						<script>
						/* 
						Native FullScreen JavaScript API
						-------------
						Assumes Mozilla naming conventions instead of W3C for now
						*/

						(function() {
							var 
								fullScreenApi = { 
									supportsFullScreen: false,
									isFullScreen: function() { return false; }, 
									requestFullScreen: function() {}, 
									cancelFullScreen: function() {},
									fullScreenEventName: '',
									prefix: ''
								},
								browserPrefixes = 'webkit moz o ms khtml'.split(' ');
							
							// check for native support
							if (typeof document.cancelFullScreen != 'undefined') {
								fullScreenApi.supportsFullScreen = true;
							} else {	 
								// check for fullscreen support by vendor prefix
								for (var i = 0, il = browserPrefixes.length; i < il; i++ ) {
									fullScreenApi.prefix = browserPrefixes[i];
									
									if (typeof document[fullScreenApi.prefix + 'CancelFullScreen' ] != 'undefined' ) {
										fullScreenApi.supportsFullScreen = true;
										
										break;
									}
								}
							}
							
							// update methods to do something useful
							if (fullScreenApi.supportsFullScreen) {
								fullScreenApi.fullScreenEventName = fullScreenApi.prefix + 'fullscreenchange';
								
								fullScreenApi.isFullScreen = function() {
									switch (this.prefix) {	
										case '':
											return top.window.document.fullScreen;
										case 'webkit':
											return top.window.document.webkitIsFullScreen;
										default:
											return top.window.document[this.prefix + 'FullScreen'];
									}
								}
								fullScreenApi.requestFullScreen = function(el) {
									return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();
								}
								fullScreenApi.cancelFullScreen = function(el) {
									return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();
								}		
							}

							// jQuery plugin
							if (typeof jQuery != 'undefined') {
								jQuery.fn.requestFullScreen = function() {
							
									return this.each(function() {
										var el = jQuery(this);
										if (fullScreenApi.supportsFullScreen) {
											fullScreenApi.requestFullScreen(el);
										}
									});
								};
							}

							// export api
							window.fullScreenApi = fullScreenApi;	
						})();
						
						</script>
						<style type="text/css">
							.img_center {
								 display: block;
								 position: absolute;
								 top: 50%;
								 left: 50%;
								 transform: translate(-50%, -50%);
								 -webkit-transform: translate(-50%, -50%); /* Safari and Chrome */
								 -moz-transform: translate(-50%, -50%); /* Firefox */
								 -ms-transform: translate(-50%, -50%); /* IE 9 */
								 -o-transform: translate(-50%, -50%); /* Opera */
								 I suppose you may like those too:
								 // max-width: 80%;
								 // max-height: 80%;
								 width:100%;
								 height:100%;
							}
							IMG.displayed {
								display: block;
								margin-left: auto;
								margin-right: auto 
							}
						</style>
				$htmlmid
						<div class="img_center">
							<div style="float:left;padding-top:8px;padding-left:15px;">
								$adsscript
							</div>
							<div style="float:right;cursor:pointer;">
								<img style="height:32px;width:32px;z-index:999" id="tofullscreen" src="/zoom_assets/full-screen.png">
							</div>
							<div id="imagecaintor" style="width:100%;height:100%;">
							</div>
						</div>
						<script>
							var sw;
							var sh;
							function fun1(sw,sh)
							{
								$('#imagecaintor').smoothZoom({
									image_url: "http://www.ofoct.com/get-file.php?type=get&genfpath=$out_file_path&downloadsavename=$downloadsavename&converter=$cid&informat=&outformat=$out_ext&insize=&outsize=",
									image_original_width: "$nwidth",
									image_original_height: "$nheight",
									width: "100%",
									height: "100%",
									button_SIZE: 22,
									button_ALIGN: "top right",
									zoom_OUT_TO_FIT: "YES",
									button_AUTO_HIDE: "NO",
									button_AUTO_HIDE_DELAY: 2,
									zoom_MIN:10,										
									/******************************************
									Enable Responsive settings below if needed.
									Max width and height values are optional.
									******************************************/
									responsive: false,
									responsive_maintain_ratio: true,
									border_SIZE: 0,
									max_WIDTH: '',
									max_HEIGHT: ''
									
								});	
								$('#imagecaintor').parent().width(sw).height(sh);
								$('#imagecaintor').width(sw).height(sh);
								
								$('#tofullscreen').click(function () {
									if (window.fullScreenApi.supportsFullScreen)
									{
										var fsElement;
										var frmid = '$frmid';
										if ( frmid == "" )
										{
											fsElement = top.window.document.getElementsByTagName("body")[0];
										}
										else
										{
											fsElement = top.window.document.getElementById('$frmid');
										}
										window.fullScreenApi.requestFullScreen(fsElement);
										fsElement.addEventListener(fullScreenApi.fullScreenEventName, function() {
											if (fullScreenApi.isFullScreen()) {
												fun1(top.window.screen.width,top.window.screen.height);
												$('#tofullscreen').hide();
											} else {
												fun1(sw, sh);
												$('#tofullscreen').show();
											}
										}, true);
									}
									else
									{
										alert("can not fullscreen");
									}
									
								});
							}
							function loaded()
							{
								sw = document.body.clientWidth * 7 / 10;
								sh = document.body.clientHeight * 9 / 10;
								if ( typeof( $("#main").attr('id') ) == "undefined" || sw == 0 )
								{
									console.log("main undefined")
									console.log(sw)
									console.log(sh)
									setTimeout("loaded()", 200);
									return;
								}
								sw = "100%"; sh = "100%";
								console.log("main ok")
								console.log(sw)
								console.log(sh)
								fun1(sw, sh);
							}
							setTimeout("loaded()", 200);
						</script>
						
				$htmlend
EOF;
				//			<img  id="yourImageID" src="http://www.ofoct.com/get-file.php?type=get&genfpath=$out_file_path&downloadsavename=$downloadsavename&converter=$cid&informat=&outformat=$out_ext&insize=&outsize=" /> 
	}
	else if ( $cid == "psd_viewer" or $cid == "vsd_viewer" or $cid == "office_viewer" or $cid == "xps_viewer" )
	{
		$imglist = "";
		$pt = (($cid == "vsd_viewer" or $cid == "xps_viewer") ? 1 : 0);
		$lfilename = str_replace(".png","-$pt.png",$out_file_path);
		outputloginfo("lfilename $lfilename");
		while( file_exists($lfilename) )
		{
			$imglist = $imglist."<li><a href=\"http://www.ofoct.com/get-file.php?type=get&genfpath=$lfilename\"><div class=\"liitem\"><img src=\"http://www.ofoct.com/get-file.php?type=get&genfpath=$lfilename\"></div></a></li> \r\n";
			$pt = $pt + 1;
			$lfilename = str_replace(".png","-$pt.png",$out_file_path);
			outputloginfo("lfilename $lfilename");
		}
		$retstr = <<<EOF
			$htmlbegin
							<style>    
								.smooth_zoom_preloader {
									background-image: url(/zoom_assets/preloader.gif);
								}	
								.smooth_zoom_icons {
									background-image: url(/zoom_assets/icons.png);
								}
								#zoom_container {
									overflow: hidden;
								}
								.zoom_thumbnails {
									margin: 0px;
									padding: 0px;
									display: inline-block;
									
								}
								.liitem
								{
									background-color:white;
									width:100px;
									border:0px solid gray;
									box-shadow: 2px 2px 2px #888888;
									float: left;
									margin: 3px;
									display: inline; 
									overflow: hidden;
									padding: 3px;
								}
								.zoom_thumbnails li {
									display: inline-block;
								}
								.zoom_thumbnails li img {
									width: 80px;
									margin: 5px;
									border: 1px;
								}
							</style>
						<script src="/zoom_assets/jquery-1.11.1.min.js"></script>
						<script src="/zoom_assets/jquery.smoothZoom.min.js"></script>	
						
						<script>

						/* 
						Native FullScreen JavaScript API
						-------------
						Assumes Mozilla naming conventions instead of W3C for now
						*/

						(function() {
							var 
								fullScreenApi = { 
									supportsFullScreen: false,
									isFullScreen: function() { return false; }, 
									requestFullScreen: function() {}, 
									cancelFullScreen: function() {},
									fullScreenEventName: '',
									prefix: ''
								},
								browserPrefixes = 'webkit moz o ms khtml'.split(' ');
							
							// check for native support
							if (typeof document.cancelFullScreen != 'undefined') {
								fullScreenApi.supportsFullScreen = true;
							} else {	 
								// check for fullscreen support by vendor prefix
								for (var i = 0, il = browserPrefixes.length; i < il; i++ ) {
									fullScreenApi.prefix = browserPrefixes[i];
									
									if (typeof document[fullScreenApi.prefix + 'CancelFullScreen' ] != 'undefined' ) {
										fullScreenApi.supportsFullScreen = true;
										
										break;
									}
								}
							}
							
							// update methods to do something useful
							if (fullScreenApi.supportsFullScreen) {
								fullScreenApi.fullScreenEventName = fullScreenApi.prefix + 'fullscreenchange';
								
								fullScreenApi.isFullScreen = function() {
									switch (this.prefix) {	
										case '':
											return top.window.document.fullScreen;
										case 'webkit':
											return top.window.document.webkitIsFullScreen;
										default:
											return top.window.document[this.prefix + 'FullScreen'];
									}
								}
								fullScreenApi.requestFullScreen = function(el) {
									return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();
								}
								fullScreenApi.cancelFullScreen = function(el) {
									return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();
								}		
							}

							// jQuery plugin
							if (typeof jQuery != 'undefined') {
								jQuery.fn.requestFullScreen = function() {
							
									return this.each(function() {
										var el = jQuery(this);
										if (fullScreenApi.supportsFullScreen) {
											fullScreenApi.requestFullScreen(el);
										}
									});
								};
							}

							// export api
							window.fullScreenApi = fullScreenApi;	
						})();
						
						</script>

						<style type="text/css">
							.img_center {
								 display: block;
								 position: absolute;
								 top: 50%;
								 left: 50%;
								 transform: translate(-50%, -50%);
								 -webkit-transform: translate(-50%, -50%); /* Safari and Chrome */
								 -moz-transform: translate(-50%, -50%); /* Firefox */
								 -ms-transform: translate(-50%, -50%); /* IE 9 */
								 -o-transform: translate(-50%, -50%); /* Opera */
								 // I suppose you may like those too:
								 // max-width: 80%;
								 // max-height: 80%;
								 width:100%;
								 height:100%;
							}
							IMG.displayed {
								display: block;
								margin-left: auto;
								margin-right: auto 
							}
						</style>
					$htmlmid
						<div class="img_center">
							<div style="float:left;padding-top:8px;padding-left:15px;">
								$adsscript
							</div>
							<div style="float:right;cursor:pointer;">
								<img style="height:32px;width:32px;z-index:999" id="tofullscreen" src="/zoom_assets/full-screen.png">
							</div>
							<div style="clear:both;float:none;"></div>
							<div id="imglist" style="OVERFLOW-Y: auto;width:130px;height:100%;float:left;margin:3px;padding:3px;">
								<ul class="zoom_thumbnails">
									$imglist
								</ul>
								<div style="clear:both;float:none;"></div>
								<div style="height:15px;width:1px;">&nbsp;</div>
							</div>
							<div id="imgmain" style="height:100%;float:left;">
								<div id="zoom_container"></div>
							</div>
			
							
							<!-- -->
						</div>
						<script>
							(function(){
								//width
								var leftWidth=document.body.clientWidth - $('#imglist').width() - 20;
								var widthperent = (leftWidth * 100 /document.body.clientWidth).toString() + "%";
								$('#imgmain').width(widthperent);
								//height
								var aheight=document.body.clientHeight - $('#tofullscreen').height() - 5;
								var heightperent = (aheight * 100 /document.body.clientHeight).toString() + "%";
								$('#imgmain').height(heightperent);
								$('#imglist').height(heightperent);
								
								$('.zoom_thumbnails').find('li a').each(function (){        
									$(this).bind('click', {src: $(this).attr('href')}, function (e){

										//Add your zoom settings here
										//var sw = document.body.clientWidth * 9 / 10 ;
										//var sh = document.body.clientHeight * 8 / 10;
										var sw = document.body.clientWidth - ( fullScreenApi.isFullScreen() ? 0 : 50*2 );
										var sh = document.body.clientHeight - ( fullScreenApi.isFullScreen() ? (100+2) : (100+32+4) );
										$('#zoom_container').smoothZoom('destroy').css('background-image', 'url(/zoom_assets/preloader.gif)').smoothZoom({
											width: "100%",
											height: "100%",
											zoom_OUT_TO_FIT: "YES",
											zoom_MIN:20,
											button_ALIGN: "top right",
											image_url: e.data.src
										});
										return false;

									});            
								}).eq(0).trigger('click');

								$('#tofullscreen').click(function () {
									if (window.fullScreenApi.supportsFullScreen)
									{
										var fsElement;
										var frmid = '$frmid';
										if ( frmid == "" )
										{
											fsElement = top.window.document.getElementsByTagName("body")[0];
										}
										else
										{
											fsElement = top.window.document.getElementById('$frmid');
										}
										window.fullScreenApi.requestFullScreen(fsElement);
										fsElement.addEventListener(fullScreenApi.fullScreenEventName, function() {
											if (fullScreenApi.isFullScreen()) {
												$('.zoom_thumbnails').find('li a').eq(0).trigger('click');
												$('#tofullscreen').hide();
											} else {
												$('.zoom_thumbnails').find('li a').eq(0).trigger('click');
												$('#tofullscreen').show();
											}
										}, true);
									}
									else
									{
										alert("can not fullscreen");
									}
									
								});
								
							})();
						</script>
					$htmlend
EOF;
	}
	else if( $cid == "djvu_viewer" )
	{
		$fileid = getparam('fileid');
		$savetojpg = getparam('savetojpg');
		$out_file_path = urlencode($out_file_path);
		$downloadsavename = $downloadsavename;
		if ( $fileid == "" )
		{
			$fileid  = "0";
		}

		$self_fileurl = "http://www.ofoct.com/get-file.php?type=get&genfpath=$out_file_path&downloadsavename=$downloadsavename&converter=&informat=&outformat=djvu&insize=&outsize=";
		
		$retstr = <<<EOF
			$htmlbegin
			<meta http-equiv="content-type" content="text/html; charset=UTF-8">
			<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
			<link type="text/css" rel="stylesheet" href="/djvu-viewer/Djvu_html5.css">
			<title>Djvu HTML5 browser demo</title>
			<script src="/zoom_assets/jquery-1.11.1.min.js"></script>
			<script type="text/javascript" language="javascript" src="/djvu-viewer/djvu_html5/djvu_html5.nocache.js"></script>
			<script>
				(function() {
					var 
						fullScreenApi = { 
							supportsFullScreen: false,
							isFullScreen: function() { return false; }, 
							requestFullScreen: function() {}, 
							cancelFullScreen: function() {},
							fullScreenEventName: '',
							prefix: ''
						},
						browserPrefixes = 'webkit moz o ms khtml'.split(' ');
					
					// check for native support
					if (typeof document.cancelFullScreen != 'undefined') {
						fullScreenApi.supportsFullScreen = true;
					} else {	 
						// check for fullscreen support by vendor prefix
						for (var i = 0, il = browserPrefixes.length; i < il; i++ ) {
							fullScreenApi.prefix = browserPrefixes[i];
							
							if (typeof document[fullScreenApi.prefix + 'CancelFullScreen' ] != 'undefined' ) {
								fullScreenApi.supportsFullScreen = true;
								
								break;
							}
						}
					}
					
					// update methods to do something useful
					if (fullScreenApi.supportsFullScreen) {
						fullScreenApi.fullScreenEventName = fullScreenApi.prefix + 'fullscreenchange';
						
						fullScreenApi.isFullScreen = function() {
							switch (this.prefix) {	
								case '':
									return top.window.document.fullScreen;
								case 'webkit':
									return top.window.document.webkitIsFullScreen;
								default:
									return top.window.document[this.prefix + 'FullScreen'];
							}
						}
						fullScreenApi.requestFullScreen = function(el) {
							return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();
						}
						fullScreenApi.cancelFullScreen = function(el) {
							return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();
						}		
					}

					// jQuery plugin
					if (typeof jQuery != 'undefined') {
						jQuery.fn.requestFullScreen = function() {
					
							return this.each(function() {
								var el = jQuery(this);
								if (fullScreenApi.supportsFullScreen) {
									fullScreenApi.requestFullScreen(el);
								}
							});
						};
					}

					// export api
					window.fullScreenApi = fullScreenApi;	
				})();
			</script>
			$htmlmid
			<div>
				<div style="float:left;padding-top:8px;padding-left:15px;">
					$adsscript
				</div>
				<div style="float:right;cursor:pointer;">
					<img style="height:32px;width:32px;z-index:999" id="tofullscreen" src="/zoom_assets/full-screen.png">
				</div>
			</div>
			<div style="clear:both;float:none;"></div>
			<script>
					$('#tofullscreen').click(function () {
						if (window.fullScreenApi.supportsFullScreen)
						{
							var fsElement;
							var frmid = '$frmid';
							if ( frmid == "" )
							{
								fsElement = top.window.document.getElementsByTagName("body")[0];
							}
							else
							{
								fsElement = top.window.document.getElementById('$frmid');
							}
							window.fullScreenApi.requestFullScreen(fsElement);
							fsElement.addEventListener(fullScreenApi.fullScreenEventName, function() {
								if (fullScreenApi.isFullScreen()) {
									fun1(top.window.screen.width,top.window.screen.height);
									$('#tofullscreen').hide();
								} else {
									fun1(sw, sh);
									$('#tofullscreen').show();
								}
							}, true);
						}
						else
						{
							alert("can not fullscreen");
						}
						
					});
			</script>

			<noscript>
				<div
					style="width: 22em; position: absolute; left: 50%; margin-left: -11em; color: red; background-color: white; border: 1px solid red; padding: 4px; font-family: sans-serif">
					Your web browser must have JavaScript enabled in order for this
					application to display correctly.</div>
			</noscript>

			<div id="djvuContainer" file="$self_fileurl"></div>
			<script type="text/javascript">
			var DJVU_CONTEXT = {
					background: "#666",
					uiHideDelay: 1500,
			};
			</script>
			
			$htmlend
EOF;
	}
	else if( $cid == "dicom_viewer" )
	{
		$fileid = getparam('fileid');
		$savetojpg = getparam('savetojpg');
		if ( $fileid == "" )
		{
			$fileid  = "0";
		}
		$savejpghtml = "";
		if ( $savetojpg != "" ) 
		{
			$savejpghtml = <<<EOF
				<style type="text/css" >
					body 
					{ 
						margin: 0px; padding: 0; overflow: hidden;
						width:1024px;height:768px;
					}
					#main
					{
						overflow:hidden;
					}
					a
					{
						text-decoration: none;	
						color:#fff;
					}
					a:visited
					{	
						text-decoration: none;
						color:#fff;
					}
				</style>
				<div id="savetojpg" style="width:150px;height:30px;">
					<div id="savetojpg_bt" style="float:left;"></div><div id="savetojpg_img" style="float:left;width:80px;height:28px;"></div> 
				</div>
EOF;
		}
		$downloadsavename = $downloadsavename;
		$out_file_path = urlencode($out_file_path);
		$retstr = <<<EOF
			$htmlbegin
			<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
			<link type="text/css" rel="stylesheet" href="/dicom-viewer/css/style.css" />
			<style type="text/css" >
			body { margin: 10px; padding: 0; }
			.layerContainer { margin: auto; text-align: center; }
			.imageLayer { left: 0px; }
			.dropBox { margin: 20px auto; }
			</style>
			<link rel="stylesheet" href="/dicom-viewer/ext/jquery-mobile/themes/dicom.min.css" />
			<link rel="stylesheet" href="/dicom-viewer/ext/jquery-mobile/themes/jquery.mobile.icons.min.css" />
			<link rel="stylesheet" href="/dicom-viewer/ext/jquery-mobile/jquery.mobile.structure-1.4.5.min.css" />
			<link rel="stylesheet" href="/dicom-viewer/icon_font/pngicon.css" type="text/css"> 
			<script>
				var file_id = $fileid;
				var fileurl = "$fileurl";
			</script>
			<script type="text/javascript" src="/dicom-viewer/viewers/dv.min.js"></script>
			<script>
				/* 
				Native FullScreen JavaScript API
				-------------
				Assumes Mozilla naming conventions instead of W3C for now
				*/
				(function() {
					var 
						fullScreenApi = { 
							supportsFullScreen: false,
							isFullScreen: function() { return false; }, 
							requestFullScreen: function() {}, 
							cancelFullScreen: function() {},
							fullScreenEventName: '',
							prefix: ''
						},
						browserPrefixes = 'webkit moz o ms khtml'.split(' ');
					
					// check for native support
					if (typeof document.cancelFullScreen != 'undefined') {
						fullScreenApi.supportsFullScreen = true;
					} else {	 
						// check for fullscreen support by vendor prefix
						for (var i = 0, il = browserPrefixes.length; i < il; i++ ) {
							fullScreenApi.prefix = browserPrefixes[i];
							
							if (typeof document[fullScreenApi.prefix + 'CancelFullScreen' ] != 'undefined' ) {
								fullScreenApi.supportsFullScreen = true;
								
								break;
							}
						}
					}
					
					// update methods to do something useful
					if (fullScreenApi.supportsFullScreen) {
						fullScreenApi.fullScreenEventName = fullScreenApi.prefix + 'fullscreenchange';
						
						fullScreenApi.isFullScreen = function() {
							switch (this.prefix) {	
								case '':
									return top.window.document.fullScreen;
								case 'webkit':
									return top.window.document.webkitIsFullScreen;
								default:
									return top.window.document[this.prefix + 'FullScreen'];
							}
						}
						fullScreenApi.requestFullScreen = function(el) {
							return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();
						}
						fullScreenApi.cancelFullScreen = function(el) {
							return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();
						}		
					}

					// jQuery plugin
					if (typeof jQuery != 'undefined') {
						jQuery.fn.requestFullScreen = function() {
					
							return this.each(function() {
								var el = jQuery(this);
								if (fullScreenApi.supportsFullScreen) {
									fullScreenApi.requestFullScreen(el);
								}
							});
						};
					}

					// export api
					window.fullScreenApi = fullScreenApi;	
				})();
			</script>
			$htmlmid
			$savejpghtml
			<!-- Main page -->
			<div data-role="page" data-theme="b" id="main">

			<!-- pageHeader #dwvversion -->
			<div id="pageHeader" data-role="header">
				<div style="float:left;padding-top:8px;padding-left:15px;">
					$adsscript
				</div>
				<div style="float:right;cursor:pointer;">
					<img style="height:32px;width:32px;z-index:999" id="tofullscreen" src="/zoom_assets/full-screen.png">
				</div>
			</div><!-- /pageHeader -->
			<div style="clear:both;float:none;"></div>
			<script>
					$('#tofullscreen').click(function () {
						if (window.fullScreenApi.supportsFullScreen)
						{
							var fsElement;
							var frmid = '$frmid';
							if ( frmid == "" )
							{
								fsElement = top.window.document.getElementsByTagName("body")[0];
							}
							else
							{
								fsElement = top.window.document.getElementById('$frmid');
							}
							window.fullScreenApi.requestFullScreen(fsElement);
							fsElement.addEventListener(fullScreenApi.fullScreenEventName, function() {
								if (fullScreenApi.isFullScreen()) {
									fun1(top.window.screen.width,top.window.screen.height);
									$('#tofullscreen').hide();
								} else {
									fun1(sw, sh);
									$('#tofullscreen').show();
								}
							}, true);
						}
						else
						{
							alert("can not fullscreen");
						}
						
					});
			</script>
			<!-- DWV -->
			<div id="dwv">

			<div id="pageMain" data-role="content" style="padding:2px;">

			<!-- Toolbar -->
			<div class="toolbar"></div>

			<!-- Auth popup -->
			<div data-role="popup" id="popupAuth">
			<a href="#" data-rel="back" data-role="button"
			  data-icon="delete" data-iconpos="notext" class="ui-btn-right">Close</a>
			<div style="padding:10px 20px;">
			<h3>Google Drive Authorization</h3>
			<p>Please authorize DWV to access your Google Drive.
			<br>This is only needed the first time you connect.</p>
			<button id="gauth-button" class="ui-btn">Authorize</button>
			</div>
			</div><!-- /popup -->

			<!-- Open popup -->
			<div data-role="popup" id="popupOpen">
			<a href="#" data-rel="back" data-role="button"
			  data-icon="delete" data-iconpos="notext" class="ui-btn-right">Close</a>
			<div style="padding:10px 20px;">
			<h3>Open</h3>
			<div id="dwv-loaderlist"></div>
			</div>
			</div><!-- /popup -->

			<!-- Layer Container -->
			<div class="layerContainer">
			<div class="dropBox"></div>
			<canvas class="imageLayer">Only for HTML5 compatible browsers...</canvas>
			<div class="drawDiv"></div>
			<div class="infoLayer">
			<div class="infotl"></div>
			<div class="infotr"></div>
			<div class="infobl"></div>
			<div class="infobr"><div class="plot"></div></div>
			</div><!-- /infoLayer -->
			</div><!-- /layerContainer -->

			<!-- History -->
			<div class="history" title="History" style="display:none;"></div>

			</div><!-- /content -->

			<div data-role="footer">

			<div class="toolbar_bom"></div>
			
			<div data-role="navbar" class="toolList">
			</div><!-- /navbar -->
			</div><!-- /footer -->

			</div><!-- /page main -->

			</div><!-- /dwv -->

			<!-- Tags page -->
			<div data-role="page" data-theme="b" id="tags_page">

			<div data-role="header">
			<a href="#main" data-icon="back"
			  data-transition="slide" data-direction="reverse">Back</a>
			<h1>DICOM Tags</h1>
			</div><!-- /header -->

			<div data-role="content">
			<!-- Tags -->
			<div id="dwv-tags" title="Tags"></div>
			</div><!-- /content -->

			</div><!-- /page tags_page-->

			$htmlend
EOF;
	}		
	else if( $cid == "epub_viewer" )
	{
		$fileid = getparam('fileid');
		if ( $fileid == "" )
		{
			$fileid  = "0";
		}
		$downloadsavename = $downloadsavename;
		$out_file_path = urlencode($out_file_path);
		$self_fileurl = "http://www.ofoct.com/get-file.php?type=get&genfpath=$out_file_path&downloadsavename=$downloadsavename&converter=&informat=&outformat=djvu&insize=&outsize=";
		$retstr = <<<EOF
		<html>
			<head>
				<title>$cid - $downloadsavename</title>
				<style type="text/css">
					body, html, #mainct{
						width: 100%;
						height: 100%;
						margin: 0px;
						padding: 0px;
						text-align:center;
						background-color: #eee;
					}
				</style>
				<meta charset="utf-8">
				<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
				<title></title>
				<meta name="description" content="">
				<meta name="viewport" content="width=device-width, user-scalable=no">
				<meta name="apple-mobile-web-app-capable" content="yes">

				<link rel="stylesheet" href="/epub-reader/css/normalize.css">
				<link rel="stylesheet" href="/epub-reader/css/main.css">
				<link rel="stylesheet" href="/epub-reader/css/popup.css">

				<script src="/epub-reader/js/libs/jquery.min.js"></script>

				<script src="/epub-reader/js/libs/zip.min.js"></script>

				<!-- File Storage -->
				<!-- <script src="/epub-reader/js/libs/localforage.min.js"></script> -->

				<!-- Full Screen -->
				<script src="/epub-reader/js/libs/screenfull.min.js"></script>

				<!-- Render -->
				<script src="/epub-reader/js/epub.js"></script>

				<!-- Hooks -->
				<script src="/epub-reader/js/hooks.min.js"></script>

				<!-- Reader -->
				<script src="/epub-reader/js/reader.min.js"></script>

				<!-- Plugins -->
				<!-- <script src="/epub-reader/js/plugins/search.js"></script> -->

				<!-- Highlights -->
				<!-- <script src="/epub-reader/js/libs/jquery.highlight.js"></script> -->
				<!-- <script src="/epub-reader/js/hooks/extensions/highlight.js"></script> -->
				
				<script>
					"use strict";
					var fileid = $fileid;
					
					EPUBJS.filePath = "/epub-reader/js/libs/";
					EPUBJS.cssPath = "/epub-reader/css/";
				
					document.onreadystatechange = function () {
						if (document.readyState == "complete") {
							if ( fileid == 0 ) 
							{
								var xhr = new XMLHttpRequest();
								xhr.open('GET', '$self_fileurl', true);
								xhr.responseType = 'blob';
								xhr.onload = function(e) {
									if (this.status == 200) {
										var myBlob = this.response;
										if (window.FileReader) {
											var reader = new FileReader();
											reader.onload = function (e) {
												window.reader = ePubReader(e.target.result);
											}.bind(this);
											reader.readAsArrayBuffer(myBlob);
										}
									}
									else
									{
										$("#viewer").html("Load data failed.");
										$("#loader").hide();
									}
								};
								xhr.send();
							}
							else
							{
								var file = top.window.arr_fileob[fileid];
								if (window.FileReader) {
									var reader = new FileReader();
									reader.onload = function (e) {
										window.reader = ePubReader(e.target.result);
									}.bind(this);
									reader.readAsArrayBuffer(file);
								}
							}
						}
					};
				</script>
			</head>
			<body>
				<div id="mainct" >
					<div style="clear:both;float:none;">
						<div style="float:left;padding-top:8px;padding-left:15px;">
							$adsscript
						</div>
						<div style="float:right;cursor:pointer;">
						</div>
					</div>
					<div style="clear:both;float:none;"></div>
					<div id="sidebar">
						<div id="panels">
						  <input id="searchBox" placeholder="search" type="search">

						  <a id="show-Search" class="show_view icon-search" data-view="Search">Search</a>
						  <a id="show-Toc" class="show_view icon-list-1 active" data-view="Toc">TOC</a>
						  <a id="show-Bookmarks" class="show_view icon-bookmark" data-view="Bookmarks">Bookmarks</a>
						  <a id="show-Notes" class="show_view icon-edit" data-view="Notes">Notes</a>

						</div>
						<div id="tocView" class="view">
						</div>
						<div id="searchView" class="view">
						  <ul id="searchResults"></ul>
						</div>
						<div id="bookmarksView" class="view">
						  <ul id="bookmarks"></ul>
						</div>
						<div id="notesView" class="view">
						  <div id="new-note">
							<textarea id="note-text"></textarea>
							<button id="note-anchor">Anchor</button>
						  </div>
						  <ol id="notes"></ol>
						</div>
					</div>
					<div id="main">
						<div id="titlebar">
						  <div id="opener">
							<a id="slider" class="icon-menu">Menu</a>
						  </div>
						  <div id="metainfo">
							<span id="book-title"></span>
							<span id="title-seperator">&nbsp;&nbsp;–&nbsp;&nbsp;</span>
							<span id="chapter-title"></span>
						  </div>
						  <div id="title-controls">
							<a id="bookmark" class="icon-bookmark-empty">Bookmark</a>
							<a id="setting" class="icon-cog">Settings</a>
							<a id="fullscreen" class="icon-resize-full">Fullscreen</a>
						  </div>
						</div>

						<div id="divider"></div>
						<div id="prev" class="arrow">‹</div>
						<div id="viewer"></div>
						<div id="next" class="arrow">›</div>

						<div id="loader"><img src="/epub-reader/img/loader.gif"></div>
					</div>
					<div class="modal md-effect-1" id="settings-modal">
						<div class="md-content">
							<h3>Settings</h3>
							<div>
								<p>
									<input type="checkbox" id="sidebarReflow" name="sidebarReflow">Reflow text when sidebars are open.
								</p>
							</div>
							<div class="closer icon-cancel-circled"></div>
						</div>
					</div>
					<div class="overlay"></div>
				</div>
			</body>
		</html>
EOF;
	}		
	echo $retstr;


//------------------------------------------	
	/*else if ( $cid == "djvu_viewer" )
	{
		$mid_file_path = $tmpfpath.".pdf";
		
		//convert djvu to pdf 
		$cmd_line = "/usr/bin/ddjvu -format=pdf $tmpfpath $mid_file_path 2> /dev/null";
		runExternal($cmd_line);
		outputloginfo($cmd_line);

		if ( check_file_avaible($mid_file_path) ) 
		{
			if ( $quality == "high-resolution" )
			{
				$cmd_line = "/usr/bin/convert -density 300 -quality 100 $mid_file_path $tmpfpath-%d.png ";
			}
			else
			{
				$cmd_line = "/usr/bin/convert -density 100 -quality 100 $mid_file_path $tmpfpath-%d.png ";
			}
			runExternal($cmd_line);
			outputloginfo($cmd_line);
		}
		else
		{
			outputloginfo_err("ERROR: Convert failed! source:$tmpfpath, dest:$mid_file_path");
			outputloginfo_err($cmd_line);
			echo "ERROR: Convert failed!";
			exit;
		}
	}*/	
	
?>