<?php 
	$lang_texts = array();
	$lang_fullname = array("en" => "English", "zh" => "中文(简体)", "sp" => "Español", "fr" => "Français", "ru" => "Pусский",
		"ar" => "العربية", "pt" => "Português", "it" => "Italiano", "pl" => "Polski", "de" => "Deutsch", "jp" => "日本の",
		"no" => "Norsk", "dk" => "Dansk", "fi" => "Suomalainen", "hu" => "Magyar", "se" => "Svenska", "nl" => "Nederlands",
		"cs" => "český");
	$lang_iso_code = array("en" => "en", "zh" => "zh", "sp" => "es", "fr" => "fr", "ru" => "ru",
		"ar" => "ar", "pt" => "pt", "it" => "it", "pl" => "pl", "de" => "de", "jp" => "ja",
		"no" => "no", "dk" => "da", "fi" => "fi", "hu" => "hu", "se" => "sv", "nl" => "nl",
		"cs" => "cs");
	$lang_arr = array("ar","cs","de","dk","en","fi","fr","hu","it","jp","nl",
		"no","pl","pt","ru","se","sp","zh");

	function get_ltext($key)
	{
		global $lang_texts;
		
		return isset($lang_texts[$key]) ? $lang_texts[$key] : "";
	}
	
	function get_lang_list($uri,$cur_language,$domain)
	{
		global $lang_arr;
		global $lang_iso_code;
		
		if ( $cur_language == "" ) 
			$cur_language = "en";
		
		$htmlcode = "";
		for($x = 0; $x < count($lang_arr); $x++)
		{
			$lang = $lang_arr[$x];
			$lang_iso = $lang_iso_code[$lang];
			$linkitem = "";
			if ( $lang != "$cur_language" )
			{
				if ( $lang == "en" )
				{
					$linkitem = <<<EOF
<link hreflang="$lang_iso" href="$domain/$uri" rel="alternate" />

EOF;
				}
				else
				{
					$linkitem = <<<EOF
<link hreflang="$lang_iso" href="$domain/$lang/$uri" rel="alternate" />

EOF;
				}
			}
			$htmlcode = $htmlcode.$linkitem;
		}
		return $htmlcode;
	}

	function get_lang_bar($uri,$cur_language,$domain)
	{
		global $lang_arr;
		global $lang_fullname;
		
		if ( $cur_language == "" ) 
			$cur_language = "en";

		$htmlcode = "";
		for($x = 0; $x < count($lang_arr); $x++)
		{
			$lang = $lang_arr[$x];
			$ypos = $x * 24;
			$linkitem = "";
			if ( $lang != "$cur_language" )
			{
				$fullname_lang = $lang_fullname[$lang];
				if ( $lang == "en" )
				{
					/*$linkitem = <<<EOF
<li><a class="dropdown-item" href="$domain/$uri"><img  style="display:inline;" src="$domain/lang/$lang.png" /> $fullname_lang</a></li>
EOF;*/
					$linkitem = <<<EOF
<li><a class="dropdown-item" href="$domain/$uri"><i class="langImg" style="width: 24px; height: 24px; background-position: 0px -{$ypos}px;"></i> $fullname_lang</a></li>
EOF;
				}
				else if ( $lang == "ar" )
				{
					/*$linkitem = <<<EOF
<li><a class="dropdown-item" href="$domain/$lang/$uri"><img  style="display:inline;" src="$domain/lang/$lang.png" /> $fullname_lang</a></li>
EOF;*/
					$linkitem = <<<EOF
<li><a class="dropdown-item" href="$domain/$lang/$uri"><i class="langImg" style="width: 33px; height: 24px; background-position: 0px -{$ypos}px;"></i> $fullname_lang</a></li>
EOF;
				}
				else 
				{
					$linkitem = <<<EOF
<li><a class="dropdown-item" href="$domain/$lang/$uri"><span><i class="langImg" style="width: 24px; height: 24px; background-position: 0px -{$ypos}px;"></i></span> $fullname_lang</a></li>
EOF;
				}
			}
			$htmlcode = $htmlcode.$linkitem;
		}
		
		$html = <<<EOF
		<style>
			.langImg {
				background-image: url($domain/lang/langImg.png);
				background-repeat: no-repeat;
				display: block;
				float: left;
			}
		</style>
		
		<div class="btn-group" role="group" aria-label="">
			<div class="btn-group" role="group">
				<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
					  <img  width="20px" height="20px" src="$domain/lang/$cur_language.png" />Language
					  <span class="caret"></span>
				</button>
				<ul class="dropdown-menu">
					$htmlcode
				</ul>
			</div>
		</div>
EOF;
		return $html;
	}	
?>
